/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.resolver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.helpers.interaction.services.ExecutionEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecturePkg;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizard;
import org.polarsys.capella.core.refinement.framework.ui.model.ComponentSelectionItem;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.ScenarioRepresentation;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ResolverException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IResolver;

public class UISelectionResolver
implements IResolver {
    public Object getName() {
        return "UI Selection Resolver";
    }

    private String getString(MessageKind kind) {
        if (kind == MessageKind.ASYNCHRONOUS_CALL) {
            return "asynchronous";
        }
        if (kind == MessageKind.SYNCHRONOUS_CALL) {
            return "synchronous";
        }
        if (kind == MessageKind.CREATE) {
            return "create";
        }
        if (kind == MessageKind.DELETE) {
            return "delete";
        }
        if (kind == MessageKind.REPLY) {
            return "reply";
        }
        return "";
    }

    private String getString(MessageEndExt.COMPONENT_TYPE type) {
        if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
            return "SENDER";
        }
        if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
            return "RECEIVER";
        }
        return "";
    }

    private String getCustomizeStartMessage(MessageEndExt.COMPONENT_TYPE type) {
        if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
            return "received by";
        }
        if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
            return "sent by";
        }
        return "";
    }

    private String getCustomizeEndMessage(MessageEndExt.COMPONENT_TYPE type) {
        if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
            return "and sent by";
        }
        if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
            return "and received by";
        }
        return "";
    }

    private String getMessageStartName(SequenceMessage sm, MessageEndExt.COMPONENT_TYPE type) {
        if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
            return this.getPartName((NamedElement)sm.getReceivingPart());
        }
        if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
            return this.getPartName((NamedElement)sm.getSendingPart());
        }
        return "";
    }

    private String getMessageName(SequenceMessage sm) {
        if (sm.getName().equals("")) {
            if (sm.getInvokedOperation() == null) {
                return "";
            }
            return sm.getInvokedOperation().getName() == null ? "" : sm.getInvokedOperation().getName();
        }
        return sm.getName();
    }

    private String getMessageEndName(SequenceMessage sm, MessageEndExt.COMPONENT_TYPE type) {
        if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
            return this.getPartName((NamedElement)sm.getSendingPart());
        }
        if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
            return this.getPartName((NamedElement)sm.getReceivingPart());
        }
        return "";
    }

    public String getPartName(NamedElement _data) {
        if (_data != null) {
            if (_data instanceof LogicalArchitecture) {
                EObject container = _data.eContainer();
                if (!(container instanceof System) && !(container instanceof LogicalArchitecturePkg)) {
                    return String.valueOf(((NamedElement)container).getName()) + "." + _data.getName();
                }
            } else if (_data instanceof AbstractTypedElement) {
                AbstractType type = ((AbstractTypedElement)_data).getAbstractType();
                if (type != null) {
                    return String.valueOf(_data.getName()) + ": " + type.getName();
                }
                return String.valueOf(_data.getName()) + ": <undefined>";
            }
            return _data.getName();
        }
        return "<unamed>";
    }

    public List<AbstractInstance> resolving(List<AbstractInstance> candidateAbstractInstances, ScenarioRepresentation srcTree, ScenarioRepresentation tgtTree, AbstractEnd srcMsg, MessageEndExt.COMPONENT_TYPE type) throws ResolverException {
        ArrayList<AbstractInstance> selectedAbstractInstances = new ArrayList<AbstractInstance>();
        Scenario scenario = null;
        SequenceMessage sm = null;
        if (candidateAbstractInstances.size() == 1) {
            selectedAbstractInstances.add(candidateAbstractInstances.get(0));
        } else if (candidateAbstractInstances.size() > 1) {
            SelectionItemNode selection;
            ComponentSelectionItem rootItem;
            SelectionWizard wizard;
            SequenceMessage msg;
            String message = "An ambiguity has been detected during the refinement process.\n";
            message = String.valueOf(message) + "Select the ";
            if (srcMsg instanceof MessageEnd) {
                message = String.valueOf(message) + this.getString(type);
                msg = ((MessageEnd)srcMsg).getMessage();
                if (msg != null) {
                    message = String.valueOf(message) + " of the " + this.getString(msg.getKind()) + " message \"" + this.getMessageName(msg) + "\" " + this.getCustomizeStartMessage(type) + " \"" + this.getMessageStartName(msg, type) + "\" " + this.getCustomizeEndMessage(type) + " \"" + this.getMessageEndName(msg, type) + "\" from \"" + CapellaElementExt.getFullPath((NamedElement)((Scenario)msg.eContainer())) + "\".";
                    scenario = (Scenario)msg.eContainer();
                    sm = msg;
                }
            } else if (srcMsg instanceof ExecutionEnd && (msg = ExecutionEndExt.getMessage((ExecutionEnd)((ExecutionEnd)srcMsg))) != null) {
                message = String.valueOf(message) + "sender of the reply message '" + this.getMessageName(msg) + "\" " + this.getCustomizeStartMessage(type) + " \"" + this.getMessageStartName(msg, type) + "\" " + this.getCustomizeEndMessage(type) + " \"" + this.getMessageEndName(msg, type) + "\" from \"" + CapellaElementExt.getFullPath((NamedElement)((Scenario)msg.eContainer())) + "\".";
                scenario = (Scenario)msg.eContainer();
                sm = msg;
            }
            if ((wizard = new SelectionWizard((SelectionItemNode)(rootItem = new ComponentSelectionItem(scenario, sm, candidateAbstractInstances)), "Capella wizard", "Refinement ambiguity resolution", message, false, true)).open() == 0 && (selection = wizard.getSelection()) != null) {
                selectedAbstractInstances.add((AbstractInstance)((Part)selection.getData()));
            }
        }
        return selectedAbstractInstances;
    }
}

