/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.ted;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.platform.sirius.ted.PlatformSiriusTedActivator;
import org.polarsys.capella.common.platform.sirius.ted.SiriusSessionListener;

public class DataNotifier
extends EContentAdapter {
    private Map<Class<?>, Set<Adapter>> _classToAdapters = new HashMap(0);
    private Map<EObject, Set<Adapter>> _modelElementToAdapters = new HashMap<EObject, Set<Adapter>>(0);
    WeakReference<EditingDomain> _editingDomain;

    public DataNotifier(EditingDomain editingDomain) {
        this._editingDomain = new WeakReference<EditingDomain>(editingDomain);
    }

    public void addAdapter(Class<?> cls, Adapter adapter) {
        if (cls == null || adapter == null) {
            return;
        }
        Set<Adapter> adapters = this._classToAdapters.get(cls);
        if (adapters == null) {
            adapters = new HashSet<Adapter>(1);
            this._classToAdapters.put(cls, adapters);
        }
        adapters.add(adapter);
    }

    public void addAdapter(EObject element, Adapter adapter) {
        if (element == null || adapter == null) {
            return;
        }
        Set<Adapter> adapters = this._modelElementToAdapters.get(element);
        if (adapters == null) {
            adapters = new HashSet<Adapter>(1);
            this._modelElementToAdapters.put(element, adapters);
        }
        adapters.add(adapter);
    }

    public void notifyChanged(Notification notification) {
        try {
            super.notifyChanged(notification);
        }
        catch (Exception exception) {
            PlatformSiriusTedActivator.getDefault().getLog().log((IStatus)new Status(4, PlatformSiriusTedActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
        }
        Object notifier = notification.getNotifier();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        Object feature = notification.getFeature();
        boolean isContainmentReference = feature instanceof EReference && ((EReference)feature).isContainment();
        HashSet<Adapter> adapters = new HashSet<Adapter>(0);
        if (notifier != null) {
            adapters.addAll(this.searchAdapters(notifier, false));
        }
        switch (notification.getEventType()) {
            case 1: {
                if (notifier == null || newValue == null || newValue == notifier) break;
                adapters.addAll(this.searchAdapters(newValue, false));
                if (oldValue == null || oldValue == newValue) break;
                adapters.addAll(this.searchAdapters(oldValue, false));
                break;
            }
            case 3: {
                adapters.addAll(this.searchAdapters(newValue, false));
                break;
            }
            case 5: {
                adapters.addAll(this.searchAdapters((Collection)newValue, false));
                break;
            }
            case 4: {
                adapters.addAll(this.searchAdapters(oldValue, isContainmentReference));
                break;
            }
            case 6: {
                adapters.addAll(this.searchAdapters((Collection)oldValue, isContainmentReference));
                break;
            }
        }
        this.doNotifyAdapters(adapters, notification);
    }

    protected void doNotifyAdapters(Collection<Adapter> adapters, Notification notification) {
        if (adapters == null || notification == null) {
            return;
        }
        for (Adapter adapter : adapters) {
            adapter.notifyChanged(notification);
        }
    }

    protected Collection<Adapter> searchAdapters(Object object, boolean removeExistingAdapters) {
        Collection<Adapter> result = this.searchAdaptersByReference(object, removeExistingAdapters);
        Collection<Adapter> resultByClass = this.searchAdaptersByClass(object);
        if (result == null) {
            result = resultByClass;
        } else {
            result.addAll(resultByClass);
        }
        return result;
    }

    protected Collection<Adapter> searchAdapters(Collection<?> objects, boolean removeExistingAdapters) {
        HashSet<Adapter> result = new HashSet<Adapter>(0);
        for (Object object : objects) {
            result.addAll(this.searchAdapters(object, removeExistingAdapters));
        }
        return result;
    }

    protected Collection<Adapter> searchAdaptersByClass(Object object) {
        HashSet<Adapter> result = new HashSet<Adapter>(0);
        if (object instanceof EObject) {
            for (Class<?> modelElementClass : this._classToAdapters.keySet()) {
                if (!modelElementClass.isInstance(object)) continue;
                result.addAll((Collection<Adapter>)this._classToAdapters.get(modelElementClass));
            }
        }
        return result;
    }

    protected Collection<Adapter> searchAdaptersByReference(Object object, boolean removeAdapters) {
        Collection result = null;
        if (object instanceof EObject) {
            result = removeAdapters ? (Collection)this._modelElementToAdapters.remove(object) : (Collection)this._modelElementToAdapters.get(object);
        }
        return result;
    }

    public void remove(Adapter adapter) {
        ArrayList<Set<Adapter>> allAdapters = new ArrayList<Set<Adapter>>(0);
        allAdapters.addAll(this._modelElementToAdapters.values());
        allAdapters.addAll(this._classToAdapters.values());
        for (Set set : allAdapters) {
            boolean found = false;
            Iterator adapters = set.iterator();
            while (adapters.hasNext() && !found) {
                boolean bl = found = adapters.next() == adapter;
                if (!found) continue;
                adapters.remove();
            }
        }
    }

    protected boolean resolve() {
        if (SiriusSessionListener.isClosingSession((EditingDomain)this._editingDomain.get())) {
            return false;
        }
        return super.resolve();
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)this._editingDomain.get();
    }
}

