/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.ted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.platform.sirius.ted.IDerivedSemanticResourceProvider;
import org.polarsys.capella.common.platform.sirius.ted.PlatformSiriusTedActivator;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;

public class SiriusSessionFactory
implements SessionFactory {
    private List<IDerivedSemanticResourceProvider> _derivedSemanticResourceProviders;
    private static final String DERIVED_SEMANTIC_RESOURCE_PROVIDER_EXTENSION_ID = "derivedSemanticResourceProvider";

    public Session createSession(URI sessionResourceURI, IProgressMonitor monitor) throws CoreException {
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(sessionResourceURI);
        TransactionalEditingDomain transactionalEditingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain(set);
        if (Movida.isEnabled()) {
            transactionalEditingDomain.getResourceSet().setURIConverter((URIConverter)new ViewpointURIConverter((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()));
        }
        if (set instanceof ResourceSetImpl) {
            ResourceSetImpl resourceSetImpl = (ResourceSetImpl)set;
            new ResourceSetImpl.MappedResourceLocator(resourceSetImpl);
        }
        set.getLoadOptions().put("SIRIUS_USE_URI_FRAGMENT_AS_ID", true);
        boolean alreadyExistingResource = set.getURIConverter().exists(sessionResourceURI, null);
        Session session = null;
        session = alreadyExistingResource ? this.loadSessionModelResource(sessionResourceURI, transactionalEditingDomain, monitor) : this.createSessionResource(sessionResourceURI, transactionalEditingDomain, true, monitor);
        return session;
    }

    protected Session loadSessionModelResource(URI sessionResourceURI, final TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
        ResourceSetUtil.setProgressMonitor((ResourceSet)resourceSet, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        Object session = null;
        try {
            try {
                monitor.beginTask("Session loading", 4);
                Resource sessionModelResource = resourceSet.getResource(sessionResourceURI, true);
                if (sessionModelResource != null) {
                    DAnalysis analysis = null;
                    if (!sessionModelResource.getContents().isEmpty() && sessionModelResource.getContents().get(0) instanceof DAnalysis) {
                        analysis = (DAnalysis)sessionModelResource.getContents().get(0);
                        session = new DAnalysisSessionImpl(analysis){

                            public Collection<Resource> getSemanticResources() {
                                ArrayList<Resource> semanticResources = new ArrayList<Resource>(super.getSemanticResources());
                                semanticResources.addAll(SiriusSessionFactory.this.getDerivedSemanticResources(transactionalEditingDomain, semanticResources));
                                return Collections.unmodifiableCollection(semanticResources);
                            }
                        };
                        monitor.worked(2);
                    } else {
                        session = this.createSessionResource(sessionResourceURI, transactionalEditingDomain, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
            }
            catch (WrappedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "Error while loading representations file", (Throwable)e));
            }
        }
        finally {
            monitor.done();
            ResourceSetUtil.resetProgressMonitor((ResourceSet)resourceSet);
        }
        return session;
    }

    protected Session createSessionResource(URI sessionResourceURI, final TransactionalEditingDomain transactionalEditingDomain, boolean forceMetadataCreation, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Session creation", 2);
            Resource sessionModelResource = new ResourceSetImpl().createResource(sessionResourceURI);
            Resource metadataResource = null;
            if (forceMetadataCreation) {
                metadataResource = this.createMetadataResource(transactionalEditingDomain, sessionResourceURI, monitor);
            }
            DAnalysis analysis = ViewpointFactory.eINSTANCE.createDAnalysis();
            sessionModelResource.getContents().add((Object)analysis);
            try {
                sessionModelResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed", (Throwable)e));
            }
            monitor.worked(1);
            sessionModelResource = transactionalEditingDomain.getResourceSet().getResource(sessionResourceURI, true);
            if (sessionModelResource.getContents().isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed: the resource content is empty."));
            }
            analysis = (DAnalysis)sessionModelResource.getContents().get(0);
            DAnalysisSessionImpl session = new DAnalysisSessionImpl(analysis){

                public Collection<Resource> getSemanticResources() {
                    ArrayList<Resource> semanticResources = new ArrayList<Resource>(super.getSemanticResources());
                    semanticResources.addAll(SiriusSessionFactory.this.getDerivedSemanticResources(transactionalEditingDomain, semanticResources));
                    return Collections.unmodifiableCollection(semanticResources);
                }
            };
            if (metadataResource != null) {
                URI metadataResourceURI = metadataResource.getURI();
                ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)transactionalEditingDomain).execute((ICommand)new AbstractReadWriteCommand((Session)session, metadataResourceURI, monitor){
                    private final /* synthetic */ Session val$session;
                    private final /* synthetic */ URI val$metadataResourceURI;
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    {
                        this.val$session = session;
                        this.val$metadataResourceURI = uRI;
                        this.val$monitor = iProgressMonitor;
                    }

                    public void run() {
                        this.val$session.addSemanticResource(this.val$metadataResourceURI, this.val$monitor);
                    }
                });
            }
            monitor.worked(1);
            DAnalysisSessionImpl dAnalysisSessionImpl = session;
            return dAnalysisSessionImpl;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isCapellaProject(URI uri) {
        try {
            if (uri.isPlatformResource()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                IProject project = file.getProject();
                return project.hasNature("org.polarsys.capella.project.nature") || project.hasNature("org.polarsys.capella.library.nature");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected Resource createMetadataResource(TransactionalEditingDomain domain, URI resourceURI, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            if (!this.isCapellaProject(resourceURI)) {
                return null;
            }
            URI uri = resourceURI.trimFileExtension().appendFileExtension("afm");
            progress.beginTask("Create an empty metadata resource", 1);
            Resource resource = MetadataHelper.getViewpointMetadata((ResourceSet)domain.getResourceSet()).initMetadataStorage(uri);
            progress.worked(1);
            try {
                progress.beginTask("Save metadata model", 1);
                resource.save(Collections.emptyMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
            progress.worked(1);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            progress.done();
        }
    }

    protected Collection<Resource> getDerivedSemanticResources(TransactionalEditingDomain editingDomain, Collection<Resource> nonDerivedSemanticResources) {
        ArrayList<Resource> derivedSemanticResources = new ArrayList<Resource>();
        for (IDerivedSemanticResourceProvider provider : this.getAllDerivedSemanticResourceProviders()) {
            for (Resource resource : provider.getDerivedSemanticResources(editingDomain)) {
                if (nonDerivedSemanticResources.contains(resource) || derivedSemanticResources.contains(resource)) continue;
                derivedSemanticResources.add(resource);
            }
        }
        return derivedSemanticResources;
    }

    protected List<IDerivedSemanticResourceProvider> getAllDerivedSemanticResourceProviders() {
        if (this._derivedSemanticResourceProviders == null) {
            this._derivedSemanticResourceProviders = new ArrayList<IDerivedSemanticResourceProvider>();
            List<IConfigurationElement> BQProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)PlatformSiriusTedActivator.getDefault().getPluginId(), (String)DERIVED_SEMANTIC_RESOURCE_PROVIDER_EXTENSION_ID));
            for (IConfigurationElement configurationElement : BQProvider) {
                IDerivedSemanticResourceProvider contrib = (IDerivedSemanticResourceProvider)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                if (contrib == null) continue;
                this._derivedSemanticResourceProviders.add(contrib);
            }
        }
        return this._derivedSemanticResourceProviders;
    }

    public Session createDefaultSession(URI sessionResourceURI) throws CoreException {
        return this.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }
}

