/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.ctx;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.sharedmodel.GenericPkg;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.GenericPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_Actor_InheritedActors
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        boolean isElementFromSharedPkg = false;
        if (systemEngineering == null) {
            SharedPkg sharedPkg = SystemEngineeringExt.getSharedPkg((CapellaElement)element);
            for (ReuseLink link : sharedPkg.getReuseLinks()) {
                if (SystemEngineeringExt.getSystemEngineering((CapellaElement)link) == null) continue;
                systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)link);
                isElementFromSharedPkg = true;
                break;
            }
            if (systemEngineering == null) {
                return availableElements;
            }
        }
        if (element instanceof Actor) {
            Actor currentActor = (Actor)element;
            if (!isElementFromSharedPkg) {
                availableElements.addAll(this.getRule_MQRY_Actor_Inherited_11(systemEngineering, currentActor));
            }
            availableElements.addAll(this.getRule_MQRY_Actor_Inherited_12(systemEngineering, currentActor));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Actor_Inherited_11(SystemEngineering sysEng, Actor currentActor) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
        ActorPkg actorPkg = ca.getOwnedActorPkg();
        if (actorPkg != null) {
            for (Actor actor : ActorPkgExt.getAllActors((ActorPkg)actorPkg)) {
                if (actor == null || currentActor.equals(actor) || GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)currentActor).contains(actor) || GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)actor).contains(currentActor)) continue;
                availableElements.add((CapellaElement)actor);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Actor_Inherited_12(SystemEngineering systemEngineering, Actor currentActor) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        List sharedPkgs = SystemEngineeringExt.getSharedPkgs((SystemEngineering)systemEngineering);
        for (SharedPkg sharedPkg : sharedPkgs) {
            GenericPkg pkg = sharedPkg.getOwnedGenericPkg();
            if (pkg == null) continue;
            for (Actor actor : GenericPkgExt.getAllActors((GenericPkg)pkg)) {
                if (actor == null || currentActor.equals(actor) || GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)currentActor).contains(actor) || GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)actor).contains(currentActor)) continue;
                availableElements.add((CapellaElement)actor);
            }
        }
        return availableElements;
    }
}

