/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.interaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalArchitecture;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_InstanceRole_RepresentedInstance
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        if (capellaElement instanceof InstanceRole) {
            Scenario scenario = (Scenario)capellaElement.eContainer();
            InstanceRole ir = (InstanceRole)capellaElement;
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)capellaElement);
            if (sysEng != null) {
                if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
                    availableElements.addAll(this.getAvailableElementsForFunctionalScenario(scenario));
                } else if (scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERFACE) {
                    availableElements.addAll(this.getAvailableElementsForComponents(scenario));
                } else if (scenario.getKind() == ScenarioKind.INTERACTION) {
                    if (ir.getRepresentedInstance() instanceof OperationalActivity) {
                        availableElements.addAll(this.getAvailableElementsForFunctionalScenario(scenario));
                    } else {
                        availableElements.addAll(this.getAvailableElementsForEntities(scenario));
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                availableElements.removeAll(QueryInterpretor.executeQuery((String)"GetCurrent_InstanceRole_RepresentedInstance", (Object)ir, (IQueryContext)context));
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getAvailableElementsForFunctionalScenario(Scenario scenario) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        AbstractFunctionalArchitecture archi = (AbstractFunctionalArchitecture)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE);
        FunctionPkg fpackage = archi.getOwnedFunctionPkg();
        for (Object obj : EcoreUtil2.getAllContents((Collection)FunctionPkgExt.getOwnedFunctions((FunctionPkg)fpackage))) {
            if (!(obj instanceof AbstractFunction)) continue;
            AbstractFunction af = (AbstractFunction)obj;
            boolean found = false;
            for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
                if (ir.getRepresentedInstance() != obj) continue;
                found = true;
            }
            if (found) continue;
            result.add((CapellaElement)af);
        }
        return result;
    }

    private List<CapellaElement> getAvailableElementsForComponents(Scenario scenario) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        ArrayList<Part> excluded = new ArrayList<Part>();
        for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
            if (!(ir.getRepresentedInstance() instanceof Part)) continue;
            excluded.add((Part)ir.getRepresentedInstance());
        }
        result.addAll(ScenarioExt.getAllAvailableParts((EObject)scenario, excluded));
        for (AbstractActor aa : ScenarioExt.getAllActors((EObject)scenario)) {
            for (AbstractTypedElement ate : aa.getAbstractTypedElements()) {
                if (!(ate instanceof Part) || excluded.contains(ate)) continue;
                result.add((CapellaElement)((Part)ate));
            }
        }
        return result;
    }

    private Collection<? extends CapellaElement> getAvailableElementsForEntities(Scenario scenario) {
        ArrayList<Part> excluded = new ArrayList<Part>();
        for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
            if (!(ir.getRepresentedInstance() instanceof Part)) continue;
            excluded.add((Part)ir.getRepresentedInstance());
        }
        return ScenarioExt.getAllComponents((EObject)scenario, excluded);
    }
}

