/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.backup.command;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.backup.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;

public class BackupAndSaveCommand
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(BackupAndSaveCommand.class);
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String HOUR_FORMAT = "HH-mm-ss";
    private final String BACKUP_FOLDER_NAME = "backup-";

    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        block11: {
            URI uri = resource.getURI();
            String plugin_id = uri.segment(1);
            try {
                plugin_id = URLDecoder.decode(plugin_id, "UTF-8");
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(plugin_id);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new Date();
                String rootBackupFolder = "backup-" + dateFormat.format(date);
                EList resources = null;
                if (resource == null || resource.getResourceSet() == null) break block11;
                resources = resource.getResourceSet().getResources();
                int nbResources = resources.size();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)nbResources);
                subMonitor.beginTask(Messages.bind((String)Messages.BACKUP_RESOURCE_MESSAGE, (Object)resource.getURI()), nbResources);
                this.createRootBackupFolder(rootBackupFolder, project, (IProgressMonitor)subMonitor.newChild(1));
                String backupPath = this.createSubFolder(rootBackupFolder, plugin_id, project, date, (IProgressMonitor)subMonitor.newChild(1));
                Session session = SessionManager.INSTANCE.getExistingSession(uri);
                boolean saveResources = session == null;
                for (Resource resource2 : resources) {
                    if (resource2.getURI().isPlatformResource()) {
                        try {
                            if (resource2 == null) continue;
                            this.backupResource(resource2, backupPath, (IProgressMonitor)subMonitor.newChild(1));
                            subMonitor.subTask(Messages.bind((String)Messages.SAVE_RESOURCE_MESSAGE, (Object)resource2.getURI()));
                            if (saveResources) {
                                resource2.save(null);
                            }
                            subMonitor.worked(1);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    subMonitor.worked(1);
                }
                if (project != null) {
                    try {
                        subMonitor.subTask(Messages.bind((String)Messages.REFRESH_PROJECT_MESSAGE, (Object)plugin_id));
                        project.refreshLocal(2, (IProgressMonitor)subMonitor);
                        subMonitor.worked(1);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                subMonitor.done();
            }
            catch (UnsupportedEncodingException e1) {
                this.LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private String createSubFolder(String rootBackupFolder, String plugin_id, IProject project, Date date, IProgressMonitor monitor) {
        String subFolderPath = null;
        try {
            rootBackupFolder = URLDecoder.decode(rootBackupFolder, "UTF-8");
            IFolder rootFolder = project.getFolder((IPath)new Path(rootBackupFolder));
            if (!rootFolder.exists()) {
                this.createRootBackupFolder(rootBackupFolder, project, monitor);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH-mm-ss");
            String subFolderName = dateFormat.format(date);
            subFolderPath = String.valueOf(rootBackupFolder) + "/" + subFolderName;
            IFolder subFolder = project.getFolder((IPath)new Path(subFolderPath));
            if (!subFolder.exists()) {
                try {
                    monitor.subTask(Messages.bind((String)Messages.FOLDER_CREATION_MESSAGE, (Object)subFolderPath));
                    subFolder.create(true, true, monitor);
                    project.refreshLocal(2, monitor);
                    monitor.done();
                }
                catch (CoreException e) {
                    this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return String.valueOf(plugin_id) + "/" + (subFolderPath == null ? "default-backup" : subFolderPath);
    }

    private void createRootBackupFolder(String rootBackupFolder, IProject project, IProgressMonitor monitor) {
        try {
            rootBackupFolder = URLDecoder.decode(rootBackupFolder, "UTF-8");
            Path path = new Path(rootBackupFolder);
            IFolder folder = project.getFolder((IPath)path);
            if (!folder.exists()) {
                try {
                    monitor.subTask(Messages.bind((String)Messages.ROOT_FOLDER_CREATION_MESSAGE, (Object)rootBackupFolder));
                    folder.create(true, true, monitor);
                    monitor.done();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (UnsupportedEncodingException e1) {
            this.LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void backupResource(Resource resource2, String path, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            subMonitor.subTask(Messages.bind((String)Messages.BACKUP_RESOURCE_MESSAGE, (Object)resource2.getURI()));
            URI uri = resource2.getURI();
            path = URLDecoder.decode(path, "UTF-8");
            if (uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (iResource != null) {
                    String iResourceName = iResource.getName();
                    Path backupPath = new Path("/" + path + "/" + iResourceName);
                    iResource.copy((IPath)backupPath, true, (IProgressMonitor)subMonitor);
                }
            }
            subMonitor.done();
        }
        catch (UnsupportedEncodingException e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

