/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.acceleration;

import java.util.List;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ADataAnalyser;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ADataAnalyserHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.AEdge;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ANode;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.TreeAppendable;

public class DiagramTextAcceleration {
    private ADataAnalyser dataAnalyser;
    private IQualifiedNameProvider qualifiedNameProvider;
    private TreeAppendable appendable;
    private final String prefix;
    private static long diagram_suffix = 0L;

    public final ADataAnalyser getDataAnalyser() {
        return this.dataAnalyser;
    }

    public DiagramTextAcceleration(Class rootClass, IQualifiedNameProvider qualifiedNameProvider, TreeAppendable appendable) {
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.appendable = appendable;
        this.prefix = null;
        this.dataAnalyser = new ADataAnalyser(rootClass, false);
        this.dataAnalyser.Analyse();
        diagram_suffix = 0L;
    }

    public DiagramTextAcceleration(Class rootClass, IQualifiedNameProvider qualifiedNameProvider, TreeAppendable appendable, String prefix) {
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.appendable = appendable;
        this.prefix = prefix;
        this.dataAnalyser = new ADataAnalyser(rootClass, true);
        this.dataAnalyser.Analyse();
    }

    public boolean isRootNodesEmpty() {
        return this.dataAnalyser.getRootNodes().isEmpty();
    }

    public void generateNodesText() {
        for (ANode node : this.dataAnalyser.getRootNodes()) {
            this.printNode(node);
        }
    }

    public void generateEdgesText() {
        for (AEdge aEdge : this.dataAnalyser.getAllEdges()) {
            this.appendable.newLine();
            this.appendable.append((CharSequence)"Edge ").append((CharSequence)aEdge.getName()).append((CharSequence)" {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"association-context: ").append((CharSequence)((QualifiedName)this.qualifiedNameProvider.apply((Object)aEdge.getTargetReference())).toString());
            this.appendable.newLine();
            this.appendable.append((CharSequence)"source: ").append((CharSequence)this.getSourceNodesFQN(aEdge));
            this.appendable.newLine();
            this.appendable.append((CharSequence)"target: ").append((CharSequence)this.getTargetNodesFQN(aEdge));
            this.appendable.newLine();
            this.appendable.append((CharSequence)"Representation {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"Style {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"end-decorator: InputArrow").newLine();
            this.appendable.append((CharSequence)"color: black");
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
        }
    }

    public void generateActionsText() {
        this.generateActionsText(false);
    }

    public void generateActionsText(boolean considerRootAsChild) {
        for (ANode node : this.dataAnalyser.getAllNodes()) {
            this.appendable.increaseIndentation().newLine().newLine();
            this.appendable.append((CharSequence)"/*").append((CharSequence)node.getVPClass().getName()).append((CharSequence)" Actions */");
            this.appendable.newLine();
            long suffix = DiagramTextAcceleration.getAndIncrementDiagram_suffix();
            this.appendable.append((CharSequence)"Create ").append((CharSequence)node.getName().trim()).append((CharSequence)("_CT_" + suffix)).append((CharSequence)"{");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"label: \"").append((CharSequence)node.getVPClass().getName()).append((CharSequence)"\" ");
            this.appendable.append((CharSequence)"action-for: ");
            this.appendFirstPrefix(this.appendable).append((CharSequence)this.getFQN(node));
            this.appendable.decreaseIndentation().newLine();
            this.appendable.append((CharSequence)"}");
            if (node.getParent() != null || considerRootAsChild && this.dataAnalyser.getRootNodes().contains(node)) {
                this.appendable.newLine();
                this.appendable.append((CharSequence)"Drop ").append((CharSequence)node.getName().trim()).append((CharSequence)("_DT_" + suffix)).append((CharSequence)"{");
                this.appendable.increaseIndentation().newLine();
                this.appendable.append((CharSequence)"action-for: ");
                this.appendFirstPrefix(this.appendable).append((CharSequence)this.getFQN(node));
                this.appendable.decreaseIndentation().newLine();
                this.appendable.append((CharSequence)"}");
            }
            this.appendable.decreaseIndentation();
        }
        for (AEdge edge : this.dataAnalyser.getAllEdges()) {
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"/*").append((CharSequence)edge.getName()).append((CharSequence)" Actions */ ");
            this.appendable.newLine();
            this.appendable.append((CharSequence)"Create ").append((CharSequence)edge.getName().trim()).append((CharSequence)"_CT {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"label: \"").append((CharSequence)edge.getName()).append((CharSequence)"\" action-for: ").append((CharSequence)edge.getName());
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
            this.appendable.newLine();
            this.appendable.append((CharSequence)"Delete ").append((CharSequence)edge.getName().trim()).append((CharSequence)"_DT {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"action-for: ").append((CharSequence)edge.getName());
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
            this.appendable.newLine();
            this.appendable.append((CharSequence)"ReconnectEdge ").append((CharSequence)edge.getName().trim()).append((CharSequence)"_RET {");
            this.appendable.increaseIndentation().newLine();
            this.appendable.append((CharSequence)"action-for: ").append((CharSequence)edge.getName());
            this.appendable.decreaseIndentation().newLine().append((CharSequence)"}");
            this.appendable.decreaseIndentation();
        }
        this.appendable.newLine();
        this.appendable.append((CharSequence)"}");
    }

    private void printNode(ANode node) {
        if (!node.isContainer()) {
            this.nodeGeneration(node);
        } else {
            this.beginContainerGeneration(node);
            List reuse = node.getReuse();
            if (!reuse.isEmpty()) {
                for (ANode aNode : reuse) {
                    int index = reuse.indexOf(aNode);
                    if (index == 0) {
                        this.appendable.append((CharSequence)"reuse ").append((CharSequence)this.getFQN(aNode)).newLine();
                        continue;
                    }
                    this.appendable.append((CharSequence)", ").append((CharSequence)this.getFQN(aNode)).append((CharSequence)" ");
                }
            }
            List children = node.getChildren();
            for (ANode aNode : children) {
                this.printNode(aNode);
            }
            this.endContainerGeneration();
        }
    }

    private void beginContainerGeneration(ANode node) {
        String classFQN = ((QualifiedName)this.qualifiedNameProvider.apply((Object)node.getVPClass())).toString();
        String associationFQN = ((QualifiedName)this.qualifiedNameProvider.apply((Object)node.getContainingReference())).toString();
        this.appendable.newLine();
        this.appendable.append((CharSequence)"Container ").append((CharSequence)node.getVPClass().getName()).append((CharSequence)"{");
        this.appendable.increaseIndentation().newLine();
        this.appendable.append((CharSequence)"domain-context: ").append((CharSequence)classFQN).append((CharSequence)" provided-by association ").append((CharSequence)associationFQN);
        this.appendable.newLine();
        this.generateRepresentation(this.getLabel(node), false);
        this.appendable.newLine();
        this.appendable.append((CharSequence)"Contains { ");
        this.appendable.increaseIndentation().newLine();
    }

    private void endContainerGeneration() {
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
    }

    private void nodeGeneration(ANode node) {
        String classFQN = ((QualifiedName)this.qualifiedNameProvider.apply((Object)node.getVPClass())).toString();
        String associationFQN = ((QualifiedName)this.qualifiedNameProvider.apply((Object)node.getContainingReference())).toString();
        this.appendable.newLine();
        this.appendable.append((CharSequence)"Node ").append((CharSequence)node.getVPClass().getName()).append((CharSequence)"{");
        this.appendable.increaseIndentation().newLine();
        this.appendable.append((CharSequence)"domain-context: ").append((CharSequence)classFQN);
        this.appendable.newLine();
        this.appendable.append((CharSequence)"provided-by association ").append((CharSequence)associationFQN);
        this.appendable.newLine();
        this.generateRepresentation(this.getLabel(node), true);
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
    }

    public void generateRepresentation(String label, boolean isNode) {
        this.appendable.append((CharSequence)"Representation { ");
        this.appendable.increaseIndentation().newLine();
        this.appendable.append((CharSequence)"Label {");
        this.appendable.increaseIndentation().newLine();
        this.appendable.append((CharSequence)"content: ").append((CharSequence)label);
        this.appendable.append((CharSequence)" police: black");
        if (isNode) {
            this.appendable.append((CharSequence)" position: node");
            this.appendable.append((CharSequence)" alignment: left");
        }
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
        this.appendable.newLine();
        this.appendable.append((CharSequence)"Style {");
        this.appendable.increaseIndentation().newLine();
        if (isNode) {
            this.appendable.append((CharSequence)"BasicStyle {");
            this.appendable.increaseIndentation();
            this.appendable.append((CharSequence)"border-color: black ");
        } else {
            this.appendable.append((CharSequence)"FlatStyle {");
            this.appendable.increaseIndentation();
        }
        this.appendable.append((CharSequence)"background: light_blue ");
        if (isNode) {
            this.appendable.append((CharSequence)"form: Square");
        } else {
            this.appendable.append((CharSequence)"foreground: white");
        }
        this.appendable.decreaseIndentation();
        this.appendable.append((CharSequence)"}");
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
        this.appendable.decreaseIndentation().newLine();
        this.appendable.append((CharSequence)"}");
    }

    public String getLabel(ANode node) {
        if (ADataAnalyserHelper.hasNameAttribute((Class)node.getVPClass())) {
            return "\"feature:name\"";
        }
        return "\"" + node.getVPClass().getName() + "\"";
    }

    public String getLabel(Class clazz) {
        if (ADataAnalyserHelper.hasNameAttribute((Class)clazz)) {
            return "\"feature:name\"";
        }
        return "\"" + clazz.getName() + "\"";
    }

    public final String getFQN(ANode node) {
        return node.getFQN();
    }

    private String getSourceNodesFQN(AEdge edge) {
        if (this.prefix != null) {
            String[] sources = edge.getSourceNodesFQN().split(",");
            return this.computeFQN(sources);
        }
        return edge.getSourceNodesFQN();
    }

    private String computeFQN(String[] refrences) {
        StringBuilder result = new StringBuilder();
        int size = refrences.length;
        String[] stringArray = refrences;
        int n = refrences.length;
        int n2 = 0;
        while (n2 < n) {
            String ref = stringArray[n2];
            String tmp = String.valueOf(this.prefix) + "Container." + ref.trim();
            result.append(tmp);
            if (!ref.equals(refrences[size - 1])) {
                result.append(", ");
            }
            ++n2;
        }
        return result.toString();
    }

    private String getTargetNodesFQN(AEdge edge) {
        if (this.prefix != null) {
            String[] targets = edge.getTargetNodesFQN().split(",");
            return this.computeFQN(targets);
        }
        return edge.getTargetNodesFQN();
    }

    private TreeAppendable appendFirstPrefix(TreeAppendable appendable) {
        if (this.prefix != null && !this.prefix.isEmpty()) {
            appendable.append((CharSequence)this.prefix).append((CharSequence)"Container.");
        }
        return appendable;
    }

    public static long getAndIncrementDiagram_suffix() {
        return ++diagram_suffix;
    }
}

