/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.filters.MultiFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.business.abstractqueries.helpers.CapellaElementsHelperForBusinessQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveSubTypesFilter;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveUnnamedElementFilter;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class AbstractTypeHelpers {
    public static List<EObject> getAvailableElements_Type_InheritedType(CapellaElement element, EClass typeClass, String allTypeInstanceQueryIdentifier) {
        ArrayList<EObject> availableElements = new ArrayList();
        BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        if (typeClass.isInstance((Object)element)) {
            GeneralizableElement currentElement = (GeneralizableElement)element;
            MultiFilter filter = new MultiFilter(new IQueryFilter[]{new RemoveUnnamedElementFilter(), new RemoveSubTypesFilter(currentElement)});
            java.util.Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
            for (IModel library : libraries) {
                BlockArchitecture correspondingBlock = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)currentBlock, (CapellaModel)((CapellaModel)library));
                for (BlockArchitecture blockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)correspondingBlock)) {
                    List elements = QueryInterpretor.executeQuery((String)allTypeInstanceQueryIdentifier, (Object)blockArchitecture, (IQueryContext)new QueryContext(), (IQueryFilter)filter);
                    availableElements.addAll(elements);
                }
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    public static List<EObject> getAvailableElements_Type_Type(CapellaElement element) {
        List<EObject> availableElements = new ArrayList();
        BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        if (element instanceof Property) {
            java.util.Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
            for (IModel library : libraries) {
                BlockArchitecture correspondingBlock = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)currentBlock, (CapellaModel)((CapellaModel)library));
                for (BlockArchitecture blockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)correspondingBlock)) {
                    DataPkg dataPkg = blockArchitecture.getOwnedDataPkg();
                    if (dataPkg == null) continue;
                    Association association = PropertyExt.getRegardingAssociation((CapellaElement)element);
                    List<EObject> returnValue = CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf((DataPkg)dataPkg, (EClass)InformationPackage.Literals.CLASS, null);
                    returnValue.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf((DataPkg)dataPkg, (EClass)InformationPackage.Literals.COLLECTION, null));
                    if (association != null) {
                        Property prop;
                        AggregationKind aggregationKind;
                        if (element instanceof Property && (aggregationKind = (prop = (Property)element).getAggregationKind()) == AggregationKind.ASSOCIATION) {
                            returnValue.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf((DataPkg)dataPkg, (EClass)CommunicationPackage.Literals.SIGNAL, null));
                            returnValue.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf((DataPkg)dataPkg, (EClass)CommunicationPackage.Literals.EXCEPTION, null));
                        }
                        returnValue = AbstractTypeHelpers.removePrimitiveOrNonPrimitiveClasses(returnValue, true);
                        returnValue = AbstractTypeHelpers.removePrimitiveOrNonPrimitiveCollections(returnValue, true);
                    } else {
                        List dataTypes = CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf((DataPkg)dataPkg, (EClass)DatatypePackage.Literals.DATA_TYPE, null);
                        returnValue.addAll(dataTypes);
                        returnValue = AbstractTypeHelpers.removePrimitiveOrNonPrimitiveClasses(returnValue, false);
                        returnValue = AbstractTypeHelpers.removePrimitiveOrNonPrimitiveCollections(returnValue, false);
                    }
                    availableElements.addAll(returnValue);
                }
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        RemoveUnnamedElementFilter filter = new RemoveUnnamedElementFilter();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject elt : availableElements) {
            if (!filter.keepElement((Object)elt, null)) continue;
            result.add(elt);
        }
        return result;
    }

    private static List<EObject> removePrimitiveOrNonPrimitiveClasses(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Class) {
                Class currentClass = (Class)element;
                if ((removePrimitive || !currentClass.isIsPrimitive()) && (!removePrimitive || currentClass.isIsPrimitive())) continue;
                returnValue.add((EObject)currentClass);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    private static List<EObject> removePrimitiveOrNonPrimitiveCollections(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Collection) {
                Collection currentCollection = (Collection)element;
                if ((removePrimitive || !currentCollection.isIsPrimitive()) && (!removePrimitive || currentCollection.isIsPrimitive())) continue;
                returnValue.add((EObject)currentCollection);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }
}

