/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.filters.MultiFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveUnnamedElementFilter;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class GetAvailable_Collection_Type__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList();
        BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        if (element instanceof Collection) {
            MultiFilter filter = new MultiFilter(new IQueryFilter[]{new RemoveUnnamedElementFilter()});
            java.util.Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
            for (IModel library : libraries) {
                BlockArchitecture correspondingBlock = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)currentBlock, (CapellaModel)((CapellaModel)library));
                for (BlockArchitecture blockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)correspondingBlock)) {
                    QueryContext context = new QueryContext();
                    List elements = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_DATA_TYPES, (Object)blockArchitecture, (IQueryContext)context, (IQueryFilter)filter);
                    availableElements.addAll(elements);
                    elements = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_COLLECTIONS, (Object)blockArchitecture, (IQueryContext)context, (IQueryFilter)filter);
                    availableElements.addAll(elements);
                    elements = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_CLASSES, (Object)blockArchitecture, (IQueryContext)context, (IQueryFilter)filter);
                    availableElements.addAll(elements);
                }
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }
}

