/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.capellacommon.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.AbstractStateRealization;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;

public class AbstractStateHelper {
    private static AbstractStateHelper instance;

    public static AbstractStateHelper getInstance() {
        if (instance == null) {
            instance = new AbstractStateHelper();
        }
        return instance;
    }

    public Object doSwitch(AbstractState element, EStructuralFeature feature) {
        List<Region> ret = null;
        if (feature.equals(CapellacommonPackage.Literals.ABSTRACT_STATE__REALIZED_ABSTRACT_STATES)) {
            ret = this.getRealizedAbstractStates(element);
        } else if (feature.equals(CapellacommonPackage.Literals.ABSTRACT_STATE__REALIZING_ABSTRACT_STATES)) {
            ret = this.getRealizingAbstractStates(element);
        } else if (feature.equals(CapellacommonPackage.Literals.ABSTRACT_STATE__INVOLVER_REGIONS)) {
            ret = this.getInvolverRegions(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        return ret;
    }

    protected List<AbstractState> getRealizedAbstractStates(AbstractState element) {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractState state;
            if (!(trace instanceof AbstractStateRealization) || (state = ((AbstractStateRealization)trace).getRealizedAbstractState()) == null) continue;
            result.add(state);
        }
        return result;
    }

    protected List<AbstractState> getRealizingAbstractStates(AbstractState element) {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractState state;
            if (!(trace instanceof AbstractStateRealization) || (state = ((AbstractStateRealization)trace).getRealizingAbstractState()) == null) continue;
            result.add(state);
        }
        return result;
    }

    protected List<Region> getInvolverRegions(AbstractState element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CapellacommonPackage.Literals.REGION__INVOLVED_STATES);
    }
}

