/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.Port;

public class PhysicalLinkExt {
    public static Collection<PhysicalLinkEnd> getRelatedPhysicalLinkEnds(Port element) {
        HashSet<PhysicalLinkEnd> result = new HashSet<PhysicalLinkEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CsPackage.Literals.PHYSICAL_LINK_END__PORT);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            result.add((PhysicalLinkEnd)objectRef);
        }
        return result;
    }

    public static Collection<PhysicalLinkEnd> getRelatedPhysicalLinkEnds(Part element) {
        HashSet<PhysicalLinkEnd> result = new HashSet<PhysicalLinkEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CsPackage.Literals.PHYSICAL_LINK_END__PART);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            result.add((PhysicalLinkEnd)objectRef);
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(PhysicalPort element) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        result.addAll((Collection<PhysicalLink>)element.getInvolvedLinks());
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds((Port)element)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(Component element) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        for (PhysicalPort port : element.getContainedPhysicalPorts()) {
            result.addAll(PhysicalLinkExt.getAllRelatedPhysicalLinks(port));
        }
        return result;
    }

    public static final List<PhysicalLink> getPhysicalLinks(Part part) {
        ArrayList<PhysicalLink> result = new ArrayList<PhysicalLink>();
        for (AbstractInformationFlow flow : part.getInformationFlows()) {
            if (!(flow instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)flow);
        }
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds(part)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static Collection<PhysicalLink> getAllRelatedPhysicalLinks(Part element) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        if (element.getAbstractType() instanceof Component) {
            Component component = (Component)element.getAbstractType();
            result.addAll(PhysicalLinkExt.getAllRelatedPhysicalLinks(component));
        }
        for (PhysicalLinkEnd end : PhysicalLinkExt.getRelatedPhysicalLinkEnds(element)) {
            result.addAll((Collection<PhysicalLink>)end.getInvolvedLinks());
        }
        return result;
    }

    public static EObject getSource(PhysicalLink link) {
        if (link.getLinkEnds().size() > 0) {
            return (EObject)link.getLinkEnds().get(0);
        }
        return null;
    }

    public static EObject getTarget(PhysicalLink link) {
        if (link.getLinkEnds().size() > 1) {
            return (EObject)link.getLinkEnds().get(1);
        }
        return null;
    }

    public static Port getSourcePort(PhysicalLink link) {
        EObject source = PhysicalLinkExt.getSource(link);
        if (source instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)source).getPort();
        }
        if (source instanceof Port) {
            return (Port)source;
        }
        return null;
    }

    public static Port getTargetPort(PhysicalLink link) {
        EObject target = PhysicalLinkExt.getTarget(link);
        if (target instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)target).getPort();
        }
        if (target instanceof Port) {
            return (Port)target;
        }
        return null;
    }

    public static Part getSourcePart(PhysicalLink link) {
        PartitionableElement container;
        Iterator iterator;
        EObject source = PhysicalLinkExt.getSource(link);
        if (source instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)source).getPart();
        }
        if (source instanceof Port && (iterator = (container = (PartitionableElement)source.eContainer()).getRepresentingPartitions().iterator()).hasNext()) {
            Partition aPartition = (Partition)iterator.next();
            return (Part)aPartition;
        }
        return null;
    }

    public static Collection<Part> getSourceParts(PhysicalLink link) {
        Part part = PhysicalLinkExt.getSourcePart(link);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component sourceComponent = PhysicalLinkExt.getSourceComponent(link);
        if (sourceComponent != null) {
            ArrayList<Part> result = new ArrayList<Part>();
            for (Partition partition : sourceComponent.getRepresentingPartitions()) {
                if (!(partition instanceof Part)) continue;
                result.add((Part)partition);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Part getTargetPart(PhysicalLink link) {
        PartitionableElement container;
        Iterator iterator;
        EObject target = PhysicalLinkExt.getTarget(link);
        if (target instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)target).getPart();
        }
        if (target instanceof Port && (iterator = (container = (PartitionableElement)target.eContainer()).getRepresentingPartitions().iterator()).hasNext()) {
            Partition aPartition = (Partition)iterator.next();
            return (Part)aPartition;
        }
        return null;
    }

    public static Collection<Part> getTargetParts(PhysicalLink link) {
        Part part = PhysicalLinkExt.getTargetPart(link);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component targetComponent = PhysicalLinkExt.getTargetComponent(link);
        if (targetComponent != null) {
            ArrayList<Part> result = new ArrayList<Part>();
            for (Partition partition : targetComponent.getRepresentingPartitions()) {
                if (!(partition instanceof Part)) continue;
                result.add((Part)partition);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Component getSourceComponent(PhysicalLink link) {
        EObject eContainer;
        Port sourcePort = PhysicalLinkExt.getSourcePort(link);
        if (sourcePort != null && (eContainer = sourcePort.eContainer()) != null && eContainer instanceof Component) {
            return (Component)eContainer;
        }
        return null;
    }

    public static Component getTargetComponent(PhysicalLink link) {
        EObject eContainer;
        Port sourcePort = PhysicalLinkExt.getTargetPort(link);
        if (sourcePort != null && (eContainer = sourcePort.eContainer()) != null && eContainer instanceof Component) {
            return (Component)eContainer;
        }
        return null;
    }

    public static Part getCommonPart(PhysicalLink link1, PhysicalLink link2) {
        Part sourceLink1Part = PhysicalLinkExt.getSourcePart(link1);
        Part targetLink1Part = PhysicalLinkExt.getTargetPart(link1);
        Part sourceLink2Part = PhysicalLinkExt.getSourcePart(link2);
        Part targetLink2Part = PhysicalLinkExt.getTargetPart(link2);
        if (sourceLink1Part.equals(sourceLink2Part) || sourceLink1Part.equals(targetLink2Part)) {
            return sourceLink1Part;
        }
        if (targetLink1Part.equals(sourceLink2Part) || targetLink1Part.equals(targetLink2Part)) {
            return targetLink1Part;
        }
        return null;
    }

    public static PhysicalPort getRelatedPort(AbstractPhysicalLinkEnd end) {
        if (end instanceof PhysicalPort) {
            return (PhysicalPort)end;
        }
        if (end instanceof PhysicalLinkEnd) {
            return ((PhysicalLinkEnd)end).getPort();
        }
        return null;
    }
}

