/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.services;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemCapabilityInvolvement;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractCapabilityExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;

public class CapabilityExt {
    public static void addInvolvedActor(Capability capability1, Actor actor) {
        if (capability1 != null && actor != null && !CapabilityExt.getInvolvedActors(capability1).contains(actor)) {
            Capability capability = (Capability)capability1.eContainer();
            ActorCapabilityInvolvement involvementLnk = CtxFactory.eINSTANCE.createActorCapabilityInvolvement();
            capability.getOwnedActorCapabilityInvolvements().add((Object)involvementLnk);
            involvementLnk.setInvolver((InvolverElement)capability1);
            involvementLnk.setInvolved((InvolvedElement)actor);
        }
    }

    public static void addInvolvedComponent(Capability capability, Component component) {
        if (component instanceof Actor) {
            CapabilityExt.addInvolvedActor(capability, (Actor)component);
        } else if (component instanceof System) {
            CapabilityExt.addInvolvedSystem(capability, (System)component);
        }
    }

    public static void addInvolvedSystem(Capability capability1, System system) {
        if (capability1 != null && system != null && !CapabilityExt.getInvolvedSystems(capability1).contains(system)) {
            Capability capability = (Capability)capability1.eContainer();
            SystemCapabilityInvolvement involvementLnk = CtxFactory.eINSTANCE.createSystemCapabilityInvolvement();
            capability.setOwnedSystemCapabilityInvolvement(involvementLnk);
            involvementLnk.setInvolver((InvolverElement)capability1);
            involvementLnk.setInvolved((InvolvedElement)system);
        }
    }

    public static List<Actor> getInvolvedActors(Capability capability) {
        return CapabilityExt.getInvolvedActors(capability, false);
    }

    public static List<Actor> getInvolvedActors(Capability capability1, boolean recurse) {
        ArrayList<Actor> involvedActors = new ArrayList<Actor>();
        for (ActorCapabilityInvolvement involvement : capability1.getInvolvedActors()) {
            involvedActors.add(involvement.getActor());
        }
        if (recurse) {
            for (AbstractCapability capability : AbstractCapabilityExt.getInheritanceHierarchy((AbstractCapability)capability1)) {
                involvedActors.addAll(CapabilityExt.getInvolvedActors((Capability)capability, false));
            }
        }
        return involvedActors;
    }

    public static List<Component> getInvolvedComponents(Capability capability) {
        return CapabilityExt.getInvolvedComponents(capability, false);
    }

    public static List<Component> getInvolvedComponents(Capability capability, boolean recurse) {
        ArrayList<Component> involvedComponents = new ArrayList<Component>();
        involvedComponents.addAll(CapabilityExt.getInvolvedActors(capability, recurse));
        involvedComponents.addAll(CapabilityExt.getInvolvedSystems(capability, recurse));
        return involvedComponents;
    }

    public static List<System> getInvolvedSystems(Capability capability) {
        return CapabilityExt.getInvolvedSystems(capability, false);
    }

    public static List<System> getInvolvedSystems(Capability capability1, boolean recurse) {
        ArrayList<System> contributingSystems = new ArrayList<System>();
        SystemCapabilityInvolvement contrib = capability1.getOwnedSystemCapabilityInvolvement();
        if (contrib != null) {
            contributingSystems.add(contrib.getSystem());
        }
        if (recurse) {
            for (AbstractCapability capability : AbstractCapabilityExt.getInheritanceHierarchy((AbstractCapability)capability1)) {
                contributingSystems.addAll(CapabilityExt.getInvolvedSystems((Capability)capability, false));
            }
        }
        return contributingSystems;
    }

    public static List<Mission> getPurposeMissions(Capability capability) {
        return CapabilityExt.getPurposeMissions(capability, false);
    }

    public static List<Mission> getPurposeMissions(Capability capability1, boolean recurse) {
        ArrayList<Mission> purposeMissions = new ArrayList<Mission>();
        for (CapabilityExploitation exploitation : capability1.getPurposes()) {
            purposeMissions.add(exploitation.getMission());
        }
        for (AbstractCapability capability : AbstractCapabilityExt.getIncludingHierarchy((AbstractCapability)capability1)) {
            for (CapabilityExploitation exploitation : ((Capability)capability).getPurposes()) {
                purposeMissions.add(exploitation.getMission());
            }
        }
        if (recurse) {
            for (AbstractCapability capability : AbstractCapabilityExt.getInheritanceHierarchy((AbstractCapability)capability1)) {
                purposeMissions.addAll(CapabilityExt.getPurposeMissions((Capability)capability, false));
            }
        }
        return purposeMissions;
    }

    public static boolean hasInvolved(Capability capability, Actor actor) {
        boolean isInvolved = false;
        for (ActorCapabilityInvolvement actorCapabilityInvolvement : capability.getInvolvedActors()) {
            if (!actorCapabilityInvolvement.getActor().equals(actor)) continue;
            isInvolved = true;
            break;
        }
        return isInvolved;
    }

    public static void removeInvolvedActor(Capability capability1, Actor actor1) {
        Capability capability = (Capability)capability1.eContainer();
        ActorCapabilityInvolvement actorCapabilityInvolvement = null;
        for (ActorCapabilityInvolvement involvement : capability1.getInvolvedActors()) {
            if (!involvement.getActor().equals(actor1)) continue;
            actorCapabilityInvolvement = involvement;
        }
        if (actorCapabilityInvolvement != null) {
            capability.getOwnedActorCapabilityInvolvements().remove(actorCapabilityInvolvement);
            capability1.getInvolvedActors().remove(actorCapabilityInvolvement);
            actorCapabilityInvolvement.destroy();
        }
    }

    public static void removeInvolvedComponent(Capability capability, Component component) {
        if (component instanceof Actor) {
            CapabilityExt.removeInvolvedActor(capability, (Actor)component);
        } else if (component instanceof System) {
            CapabilityExt.removeInvolvedSystem(capability, (System)component);
        }
    }

    public static void removeInvolvedSystem(Capability capability, System system) {
        SystemCapabilityInvolvement involvement = capability.getOwnedSystemCapabilityInvolvement();
        if (involvement.getSystem().equals(system)) {
            capability.setOwnedSystemCapabilityInvolvement(null);
        }
    }
}

