/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.TypeHelper;

public class AbstractFunctionalBlockHelper {
    private static AbstractFunctionalBlockHelper instance;

    private AbstractFunctionalBlockHelper() {
    }

    public static AbstractFunctionalBlockHelper getInstance() {
        if (instance == null) {
            instance = new AbstractFunctionalBlockHelper();
        }
        return instance;
    }

    public Object doSwitch(AbstractFunctionalBlock element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__ALLOCATED_FUNCTIONS)) {
            ret = this.getAllocatedFunctions(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__FUNCTIONAL_ALLOCATIONS)) {
            ret = this.getFunctionalAllocations(element);
        }
        if (ret == null) {
            ret = TypeHelper.getInstance().doSwitch((Type)element, feature);
        }
        return ret;
    }

    protected List<ComponentFunctionalAllocation> getFunctionalAllocations(AbstractFunctionalBlock element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<ComponentFunctionalAllocation> ret = new ArrayList<ComponentFunctionalAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof ComponentFunctionalAllocation)) continue;
            ret.add((ComponentFunctionalAllocation)trace);
        }
        return ret;
    }

    protected List<AbstractFunction> getAllocatedFunctions(AbstractFunctionalBlock element) {
        EList allocs = element.getFunctionalAllocations();
        ArrayList<AbstractFunction> ret = new ArrayList<AbstractFunction>();
        for (ComponentFunctionalAllocation componentFunctionalAllocation : allocs) {
            AbstractFunction function = componentFunctionalAllocation.getFunction();
            if (function == null) continue;
            ret.add(function);
        }
        return ret;
    }
}

