/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.Messages;
import org.polarsys.capella.core.data.helpers.information.delegates.ValueOfNumericValueSwitch;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;

public class DataValueHelper {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    private static DataValueHelper instance;

    private DataValueHelper() {
    }

    public static DataValueHelper getInstance() {
        if (instance == null) {
            instance = new DataValueHelper();
        }
        return instance;
    }

    public Object doSwitch(DataValue element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(DatavaluePackage.Literals.DATA_VALUE__TYPE)) {
            return this.getType(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        return ret;
    }

    protected Type getType(DataValue element) {
        AbstractType absType = element.getAbstractType();
        if (absType != null && absType instanceof Type) {
            return (Type)absType;
        }
        return null;
    }

    public static Object getValue(NumericValue value) {
        return new ValueOfNumericValueSwitch().doSwitch((EObject)value);
    }

    public static int getValueAsInt(NumericValue value) {
        int foundInt;
        try {
            String string = (String)DataValueHelper.getValue(value);
            foundInt = Integer.parseInt(string);
        }
        catch (ClassCastException exception) {
            __logger.warn((Object)(String.valueOf(Messages.DataValueHelper_cannotConvertToIntTheNumericValue) + value), (Throwable)exception);
            return -1;
        }
        catch (NumberFormatException exception) {
            return -1;
        }
        return foundInt;
    }
}

