/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;

public class ExchangeItemExt {
    public static ExchangeItem copyExchangeItem(ExchangeItem exchangeItem1) {
        ExchangeItem element = InformationFactory.eINSTANCE.createExchangeItem();
        element.setName(exchangeItem1.getName());
        element.setDescription(exchangeItem1.getDescription());
        element.setExchangeMechanism(exchangeItem1.getExchangeMechanism());
        for (ExchangeItemElement kid : exchangeItem1.getOwnedElements()) {
            element.getOwnedElements().add((Object)ExchangeItemExt.copyExchangeItemElement(kid));
        }
        return element;
    }

    public static ExchangeItemElement copyExchangeItemElement(ExchangeItemElement exchangeItemElement1) {
        ExchangeItemElement element = InformationFactory.eINSTANCE.createExchangeItemElement();
        element.setName(exchangeItemElement1.getName());
        element.setDirection(exchangeItemElement1.getDirection());
        element.setDescription(exchangeItemElement1.getDescription());
        element.setAbstractType(exchangeItemElement1.getAbstractType());
        element.setOwnedMaxCard(exchangeItemElement1.getOwnedMaxCard());
        element.setOwnedMinCard(exchangeItemElement1.getOwnedMinCard());
        return element;
    }

    public static ExchangeItemElement createExchangeItemElement(boolean initCard) {
        ExchangeItemElement item = InformationFactory.eINSTANCE.createExchangeItemElement();
        if (initCard) {
            LiteralNumericValue valueMin = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
            valueMin.setValue("1");
            item.setOwnedMinCard((NumericValue)valueMin);
            LiteralNumericValue valueMax = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
            valueMax.setValue("1");
            item.setOwnedMaxCard((NumericValue)valueMax);
        }
        return item;
    }

    public static List<AbstractType> getData(AbstractExchangeItem item) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        if (item instanceof ExchangeItem) {
            for (ExchangeItemElement element : ((ExchangeItem)item).getOwnedElements()) {
                if (element.getType() == null) continue;
                types.add((AbstractType)element.getType());
            }
        }
        return types;
    }

    public static List<ExchangeItem> getEvents(EList<ExchangeItem> exchangeItems) {
        ArrayList<ExchangeItem> types = new ArrayList<ExchangeItem>();
        for (ExchangeItem item : exchangeItems) {
            if (!ExchangeMechanism.EVENT.equals((Object)item.getExchangeMechanism())) continue;
            types.add(item);
        }
        return types;
    }

    public static List<AbstractType> getExceptions(ExchangeItem item) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        for (ExchangeItemElement element : item.getOwnedElements()) {
            if (!ElementKind.MEMBER.equals((Object)element.getKind()) || !ParameterDirection.EXCEPTION.equals((Object)element.getDirection())) continue;
            types.add((AbstractType)element.getType());
        }
        return types;
    }

    public static Map<AbstractDependenciesPkg, Collection<EObject>> getExchangeItemDependencies2(AbstractExchangeItem exchangeItem) {
        HashMap<AbstractDependenciesPkg, Collection<EObject>> result = new HashMap<AbstractDependenciesPkg, Collection<EObject>>();
        for (AbstractType aType : ExchangeItemExt.getData(exchangeItem)) {
            ExchangeItemExt.checkDependenciesAndAddToResult(result, (EObject)aType);
        }
        return result;
    }

    private static void checkDependenciesAndAddToResult(Map<AbstractDependenciesPkg, Collection<EObject>> map, EObject eobject) {
        AbstractDependenciesPkg adp;
        if (eobject != null && (adp = (AbstractDependenciesPkg)EcoreUtil2.getFirstContainer((EObject)eobject, (EClass)CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG)) != null) {
            if (!map.containsKey(adp)) {
                HashSet set = new HashSet();
                map.put(adp, set);
            }
            map.get(adp).add(eobject);
        }
    }

    public static Collection<AbstractDependenciesPkg> getExchangeItemDependencies(AbstractExchangeItem exchangeItem) {
        return ExchangeItemExt.getExchangeItemDependencies2(exchangeItem).keySet();
    }

    public static List<ExchangeItem> getExchangeItems(Interface element) {
        ArrayList<ExchangeItem> types = new ArrayList<ExchangeItem>();
        for (AbstractExchangeItem item : element.getExchangeItems()) {
            if (!(item instanceof ExchangeItem)) continue;
            types.add((ExchangeItem)item);
        }
        return types;
    }

    public static List<ExchangeItem> getOperations(List<? extends AbstractExchangeItem> exchangeItems) {
        ArrayList<ExchangeItem> types = new ArrayList<ExchangeItem>();
        for (AbstractExchangeItem abstractExchangeItem : exchangeItems) {
            if (!(abstractExchangeItem instanceof ExchangeItem) || ((ExchangeItem)abstractExchangeItem).getExchangeMechanism() != ExchangeMechanism.OPERATION) continue;
            types.add((ExchangeItem)abstractExchangeItem);
        }
        return types;
    }

    public static List<AbstractType> getParameters(AbstractExchangeItem item) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        if (item instanceof ExchangeItem) {
            for (ExchangeItemElement element : ((ExchangeItem)item).getOwnedElements()) {
                if (!ElementKind.MEMBER.equals((Object)element.getKind())) continue;
                types.add((AbstractType)element.getType());
            }
        }
        return types;
    }

    public static Collection<CommunicationLink> getRelatedCommunicationLinks(AbstractExchangeItem sndItem) {
        HashSet<CommunicationLink> result = new HashSet<CommunicationLink>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CommunicationPackage.Literals.COMMUNICATION_LINK__EXCHANGE_ITEM);
        for (Object objectRef : EObjectExt.getReferencers((EObject)sndItem, refs)) {
            result.add((CommunicationLink)objectRef);
        }
        return result;
    }

    public static Collection<ExchangeItemAllocation> getRelatedExchangeItemAllocations(ExchangeItem item) {
        HashSet<ExchangeItemAllocation> result = new HashSet<ExchangeItemAllocation>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
        for (Object objectRef : EObjectExt.getReferencers((EObject)item, refs)) {
            result.add((ExchangeItemAllocation)objectRef);
        }
        return result;
    }

    public static Collection<CommunicationLinkExchanger> getRelatedExchangers(AbstractExchangeItem item) {
        ArrayList<CommunicationLinkExchanger> result = new ArrayList<CommunicationLinkExchanger>();
        for (CommunicationLink link : ExchangeItemExt.getRelatedCommunicationLinks(item)) {
            if (!(link.eContainer() instanceof CommunicationLinkExchanger)) continue;
            CommunicationLinkExchanger exchanger = (CommunicationLinkExchanger)link.eContainer();
            result.add(exchanger);
            if (!(exchanger instanceof GeneralizableElement)) continue;
            for (GeneralizableElement child : GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)exchanger)) {
                if (!(child instanceof CommunicationLinkExchanger)) continue;
                result.add((CommunicationLinkExchanger)child);
            }
        }
        return result;
    }

    public static List<AbstractType> getTypes(AbstractExchangeItem item) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        if (item instanceof ExchangeItem) {
            for (ExchangeItemElement element : ((ExchangeItem)item).getOwnedElements()) {
                if (!ElementKind.TYPE.equals((Object)element.getKind())) continue;
                types.add((AbstractType)element.getType());
            }
        }
        return types;
    }

    public static boolean isAccess(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.ACCESS).contains(sndItem);
    }

    public static boolean isCall(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.CALL).contains(sndItem);
    }

    public static boolean isCoherentExchangeItem(Component sndCpnt, AbstractExchangeItem sndItem, Component rcvCpnt, AbstractExchangeItem rcvItem) {
        List<GeneralizableElement> sndComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)sndCpnt);
        List<GeneralizableElement> rcvComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)rcvCpnt);
        sndComponents.add((GeneralizableElement)sndCpnt);
        rcvComponents.add((GeneralizableElement)rcvCpnt);
        HashSet sndProduce = new HashSet();
        HashSet sndCall = new HashSet();
        HashSet sndSend = new HashSet();
        HashSet sndWrite = new HashSet();
        for (GeneralizableElement snd : sndComponents) {
            if (snd == null || !(snd instanceof Component)) continue;
            Component sndCompo = (Component)snd;
            sndProduce.addAll(sndCompo.getProduce());
            sndCall.addAll(sndCompo.getCall());
            sndSend.addAll(sndCompo.getSend());
            sndWrite.addAll(sndCompo.getWrite());
        }
        HashSet rcvConsume = new HashSet();
        HashSet rcvExecute = new HashSet();
        HashSet rcvReceive = new HashSet();
        HashSet rcvAccess = new HashSet();
        for (GeneralizableElement snd : rcvComponents) {
            if (snd == null || !(snd instanceof Component)) continue;
            Component sndCompo = (Component)snd;
            rcvConsume.addAll(sndCompo.getConsume());
            rcvExecute.addAll(sndCompo.getExecute());
            rcvReceive.addAll(sndCompo.getReceive());
            rcvAccess.addAll(sndCompo.getAccess());
        }
        return sndProduce.contains(sndItem) && rcvConsume.contains(rcvItem) || sndCall.contains(sndItem) && rcvExecute.contains(rcvItem) || sndSend.contains(sndItem) && rcvReceive.contains(rcvItem) || sndWrite.contains(sndItem) && rcvAccess.contains(rcvItem);
    }

    public static boolean isConsume(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.CONSUME).contains(sndItem);
    }

    public static boolean isExecute(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.EXECUTE).contains(sndItem);
    }

    public static boolean isProduce(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.PRODUCE).contains(sndItem);
    }

    public static boolean isReceive(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.RECEIVE).contains(sndItem);
    }

    public static boolean isSend(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.SEND).contains(sndItem);
    }

    public static boolean isSendingByLinks(CommunicationLinkExchanger sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKinds(CommunicationLinkExt.getAllCommunicationLinks(sndCpnt), new CommunicationLinkKind[]{CommunicationLinkKind.CONSUME, CommunicationLinkKind.EXECUTE, CommunicationLinkKind.RECEIVE, CommunicationLinkKind.ACCESS}).contains(sndItem);
    }

    public static boolean isUsingByLinks(CommunicationLinkExchanger sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKinds(CommunicationLinkExt.getAllCommunicationLinks(sndCpnt), new CommunicationLinkKind[]{CommunicationLinkKind.PRODUCE, CommunicationLinkKind.CALL, CommunicationLinkKind.SEND, CommunicationLinkKind.WRITE}).contains(sndItem);
    }

    public static boolean isWrite(Component sndCpnt, AbstractExchangeItem sndItem) {
        return CommunicationLinkExt.getExchangeItemsByKind(CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)sndCpnt), CommunicationLinkKind.WRITE).contains(sndItem);
    }
}

