/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractActorHelper;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.SystemActorRealization;
import org.polarsys.capella.core.data.pa.PhysicalActor;

public class LogicalActorHelper {
    private static LogicalActorHelper instance;

    private LogicalActorHelper() {
    }

    public static LogicalActorHelper getInstance() {
        if (instance == null) {
            instance = new LogicalActorHelper();
        }
        return instance;
    }

    public Object doSwitch(LogicalActor element, EStructuralFeature feature) {
        List<LogicalFunction> ret = null;
        if (feature.equals(LaPackage.Literals.LOGICAL_ACTOR__PARTICIPATIONS_IN_CAPABILITY_REALIZATIONS)) {
            ret = this.getParticipationInCapabilityRealizations(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ACTOR__SYSTEM_ACTOR_REALIZATIONS)) {
            ret = this.getSystemActorRealizations(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ACTOR__ALLOCATED_LOGICAL_FUNCTIONS)) {
            ret = this.getAllocatedLogicalFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ACTOR__REALIZING_PHYSICAL_ACTORS)) {
            ret = this.getRealizingPhysicalActors(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_ACTOR__REALIZED_SYSTEM_ACTORS)) {
            ret = this.getRealizedSystemActors(element);
        }
        if (ret == null) {
            ret = AbstractActorHelper.getInstance().doSwitch((AbstractActor)element, feature);
        }
        return ret;
    }

    protected List<ActorCapabilityRealizationInvolvement> getParticipationInCapabilityRealizations(LogicalActor element) {
        ArrayList<ActorCapabilityRealizationInvolvement> ret = new ArrayList<ActorCapabilityRealizationInvolvement>();
        for (CapabilityRealizationInvolvement involvement : element.getInvolvingCapabilityRealizationInvolvements()) {
            if (!(involvement instanceof ActorCapabilityRealizationInvolvement)) continue;
            ret.add((ActorCapabilityRealizationInvolvement)involvement);
        }
        return ret;
    }

    protected List<SystemActorRealization> getSystemActorRealizations(LogicalActor element) {
        ArrayList<SystemActorRealization> ret = new ArrayList<SystemActorRealization>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            if (!(componentAllocation instanceof SystemActorRealization)) continue;
            ret.add((SystemActorRealization)componentAllocation);
        }
        return ret;
    }

    protected List<LogicalFunction> getAllocatedLogicalFunctions(LogicalActor element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalActor> getRealizingPhysicalActors(LogicalActor element) {
        ArrayList<PhysicalActor> ret = new ArrayList<PhysicalActor>();
        for (Component cpnt : element.getAllocatingComponents()) {
            if (!(cpnt instanceof PhysicalActor)) continue;
            ret.add((PhysicalActor)cpnt);
        }
        return ret;
    }

    protected List<Actor> getRealizedSystemActors(LogicalActor element) {
        ArrayList<Actor> ret = new ArrayList<Actor>();
        for (Component cpnt : element.getAllocatedComponents()) {
            if (!(cpnt instanceof Actor)) continue;
            ret.add((Actor)cpnt);
        }
        return ret;
    }
}

