/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPhysicalArtifactHelper;
import org.polarsys.capella.core.data.helpers.pa.delegates.AbstractPhysicalComponentHelper;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class PhysicalComponentHelper {
    private static PhysicalComponentHelper instance;

    private PhysicalComponentHelper() {
    }

    public static PhysicalComponentHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalComponent element, EStructuralFeature feature) {
        List<LogicalComponent> ret = null;
        if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__SUB_PHYSICAL_COMPONENTS)) {
            ret = this.getSubPhysicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__LOGICAL_INTERFACE_REALIZATIONS)) {
            ret = this.getLogicalInterfaceRealizations(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__LOGICAL_COMPONENT_REALIZATIONS)) {
            ret = this.getLogicalComponentRealizations(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__REALIZED_LOGICAL_COMPONENTS)) {
            ret = this.getRealizedLogicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__ALLOCATED_PHYSICAL_FUNCTIONS)) {
            ret = this.getAllocatedPhysicalFunctions(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__DEPLOYED_PHYSICAL_COMPONENTS)) {
            ret = this.getDeployedPhysicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__DEPLOYING_PHYSICAL_ACTORS)) {
            ret = this.getDeployingPhysicalActors(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__DEPLOYING_PHYSICAL_COMPONENTS)) {
            ret = this.getDeployingPhysicalComponents(element);
        }
        if (ret == null) {
            ret = AbstractPhysicalArtifactHelper.getInstance().doSwitch((AbstractPhysicalArtifact)element, feature);
        }
        if (ret == null) {
            ret = AbstractPhysicalComponentHelper.getInstance().doSwitch((AbstractPhysicalComponent)element, feature);
        }
        return ret;
    }

    protected List<LogicalComponentRealization> getLogicalComponentRealizations(PhysicalComponent element) {
        ArrayList<LogicalComponentRealization> ret = new ArrayList<LogicalComponentRealization>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            if (!(componentAllocation instanceof LogicalComponentRealization)) continue;
            ret.add((LogicalComponentRealization)componentAllocation);
        }
        return ret;
    }

    protected List<LogicalInterfaceRealization> getLogicalInterfaceRealizations(PhysicalComponent element) {
        ArrayList<LogicalInterfaceRealization> ret = new ArrayList<LogicalInterfaceRealization>();
        for (InterfaceAllocation componentAllocation : element.getProvisionedInterfaceAllocations()) {
            if (!(componentAllocation instanceof LogicalInterfaceRealization)) continue;
            ret.add((LogicalInterfaceRealization)componentAllocation);
        }
        return ret;
    }

    protected List<PhysicalComponent> getSubPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (Partition thePartition : element.getOwnedPartitions()) {
            Type representedElement = thePartition.getType();
            if (representedElement == null || !representedElement.eClass().equals(PaPackage.Literals.PHYSICAL_COMPONENT)) continue;
            ret.add((PhysicalComponent)representedElement);
        }
        return ret;
    }

    protected List<LogicalComponent> getRealizedLogicalComponents(PhysicalComponent element) {
        ArrayList<LogicalComponent> ret = new ArrayList<LogicalComponent>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof LogicalComponentRealization) || !((elt = ((LogicalComponentRealization)trace).getTargetElement()) instanceof LogicalComponent)) continue;
            ret.add((LogicalComponent)elt);
        }
        return ret;
    }

    protected List<PhysicalFunction> getAllocatedPhysicalFunctions(PhysicalComponent element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalComponent> getDeployedPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deploymentLink : ((Part)obj).getDeploymentLinks()) {
                AbstractType type;
                DeployableElement deployableElement = deploymentLink.getDeployedElement();
                if (deployableElement instanceof PhysicalComponent) {
                    ret.add((PhysicalComponent)deployableElement);
                    continue;
                }
                if (!(deployableElement instanceof Part) || !((type = ((Part)deployableElement).getAbstractType()) instanceof PhysicalComponent)) continue;
                ret.add((PhysicalComponent)type);
            }
        }
        return ret;
    }

    protected List<PhysicalActor> getDeployingPhysicalActors(PhysicalComponent element) {
        ArrayList<PhysicalActor> ret = new ArrayList<PhysicalActor>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deployingLink : ((Part)obj).getDeployingLinks()) {
                AbstractType type;
                DeploymentTarget deploymentTarget = deployingLink.getLocation();
                if (deploymentTarget instanceof PhysicalActor) {
                    ret.add((PhysicalActor)deploymentTarget);
                    continue;
                }
                if (!(deploymentTarget instanceof Part) || !((type = ((Part)deploymentTarget).getAbstractType()) instanceof PhysicalActor)) continue;
                ret.add((PhysicalActor)type);
            }
        }
        return ret;
    }

    protected List<PhysicalComponent> getDeployingPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deployingLink : ((Part)obj).getDeployingLinks()) {
                AbstractType type;
                DeploymentTarget deploymentTarget = deployingLink.getLocation();
                if (deploymentTarget instanceof PhysicalComponent) {
                    ret.add((PhysicalComponent)deploymentTarget);
                    continue;
                }
                if (!(deploymentTarget instanceof Part) || !((type = ((Part)deploymentTarget).getAbstractType()) instanceof PhysicalComponent)) continue;
                ret.add((PhysicalComponent)type);
            }
        }
        return ret;
    }
}

