/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.utils.Utils;
import org.polarsys.capella.core.ui.properties.annotations.RepresentationAnnotationHelper;

public class ProgressSetDialog
extends Dialog {
    private Label dlgMessage;
    private Label dlgImage;
    private Collection<EObject> affectedObjects;
    private EnumerationPropertyLiteral selectedEnumLiteral = null;
    private PropagateChoice propagateChoiceFiltering = PropagateChoice.ONLY_BUSINESS_ELEMENTS;
    private boolean propagateToRepresentation = false;
    private boolean useFilterStatus = false;
    private EnumerationPropertyLiteral filterStatus = null;
    private boolean cleanReview = false;
    private boolean propagateStatus = true;
    private Combo combo;

    protected ProgressSetDialog(Shell parentShell, Collection<EObject> affectedObjects) {
        super(parentShell);
        this.affectedObjects = affectedObjects;
    }

    public EnumerationPropertyLiteral getSelectedEnum() {
        return this.selectedEnumLiteral;
    }

    public PropagateChoice getPropagateChoiceWithoutFiltering() {
        return this.propagateChoiceFiltering;
    }

    public boolean isPropagateToRepresentations() {
        return this.propagateToRepresentation;
    }

    public boolean mustPropagateStatus() {
        return this.propagateStatus;
    }

    public boolean mustCleanReview() {
        return this.cleanReview;
    }

    public boolean useFilterStatus() {
        return this.useFilterStatus;
    }

    public EnumerationPropertyLiteral getFilterStatus() {
        return this.filterStatus;
    }

    private void refreshWizard() {
        boolean propagateOn;
        boolean action = this.propagateStatus || this.cleanReview;
        boolean bl = propagateOn = this.propagateToRepresentation || this.propagateChoiceFiltering != PropagateChoice.NO_MODEL_ELEMENTS;
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(action && propagateOn);
        }
        if (!action) {
            this.dlgImage.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            this.dlgMessage.setText(MetricMessages.progressMonitoring_setAction_dialog_noAction_lbl);
        } else if (!propagateOn) {
            this.dlgImage.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            this.dlgMessage.setText(MetricMessages.progressMonitoring_setAction_dialog_noPropagateOn_lbl);
        } else if (this.propagateStatus) {
            this.selectedEnumLiteral = (EnumerationPropertyLiteral)this.combo.getData(String.valueOf(this.combo.getSelectionIndex()));
            if (this.selectedEnumLiteral == null) {
                this.dlgImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
                this.dlgMessage.setText(MetricMessages.progressMonitoring_setAction_dialog_clear_lbl);
            } else {
                this.dlgImage.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
                this.dlgMessage.setText(NLS.bind((String)MetricMessages.progressMonitoring_setAction_dialog_main_lbl, (Object)this.selectedEnumLiteral.getLabel()));
            }
        } else {
            this.dlgImage.setImage(null);
            this.dlgMessage.setText("");
        }
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(MetricMessages.progressMonitoring_setAction_dialog_title);
        this.getShell().setMinimumSize(300, 200);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite header = new Composite(composite, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.dlgImage = new Label(header, 0);
        GridData dlgImageLayoutData = new GridData(1, 1, false, false, 1, 1);
        dlgImageLayoutData.widthHint = 20;
        dlgImageLayoutData.minimumWidth = 10;
        this.dlgImage.setLayoutData((Object)dlgImageLayoutData);
        this.dlgMessage = new Label(header, 0);
        this.dlgMessage.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        Composite propagateComposite = new Composite(composite, 0);
        propagateComposite.setLayout((Layout)new GridLayout(2, false));
        propagateComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button propagateStatusField = new Button(propagateComposite, 32);
        propagateStatusField.setText(MetricMessages.progressMonitoring_setAction_dialog_combo_lbl);
        propagateStatusField.setToolTipText(MetricMessages.progressMonitoring_setAction_dialog_combo_lbl);
        propagateStatusField.setSelection(this.propagateStatus);
        this.combo = new Combo(propagateComposite, 2060);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProgressSetDialog.this.refreshWizard();
            }
        });
        propagateStatusField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressSetDialog.this.propagateStatus = ((Button)e.getSource()).getSelection();
                ProgressSetDialog.this.combo.setEnabled(ProgressSetDialog.this.propagateStatus);
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Button cleanReviewField = new Button(propagateComposite, 32);
        cleanReviewField.setText(MetricMessages.progressMonitoring_clearReview_button_lbl);
        cleanReviewField.setToolTipText(MetricMessages.progressMonitoring_clearReview_button_tooltip);
        cleanReviewField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressSetDialog.this.cleanReview = ((Button)e.getSource()).getSelection();
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Group filterGroup = this.createFilterGroup(composite);
        Button propagateNothingWithoutFilteringButton = new Button((Composite)filterGroup, 16);
        propagateNothingWithoutFilteringButton.setText(MetricMessages.progressMonitoring_dialog_propagate_nothing_button_lbl);
        propagateNothingWithoutFilteringButton.setToolTipText(MetricMessages.progressMonitoring_dialog_propagate_nothing_button_tooltip);
        propagateNothingWithoutFilteringButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        propagateNothingWithoutFilteringButton.setSelection(this.propagateChoiceFiltering == PropagateChoice.NO_MODEL_ELEMENTS);
        propagateNothingWithoutFilteringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressSetDialog.this.propagateChoiceFiltering = PropagateChoice.NO_MODEL_ELEMENTS;
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Button propagateSemanticWithoutFilteringButton = new Button((Composite)filterGroup, 16);
        propagateSemanticWithoutFilteringButton.setText(MetricMessages.progressMonitoring_dialog_propagate_semantic_button_lbl);
        propagateSemanticWithoutFilteringButton.setToolTipText(MetricMessages.progressMonitoring_dialog_propagate_semantic_button_tooltip);
        propagateSemanticWithoutFilteringButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        propagateSemanticWithoutFilteringButton.setSelection(this.propagateChoiceFiltering == PropagateChoice.ONLY_BUSINESS_ELEMENTS);
        propagateSemanticWithoutFilteringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressSetDialog.this.propagateChoiceFiltering = PropagateChoice.ONLY_BUSINESS_ELEMENTS;
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Button propagateTechnicalWithoutFilteringButton = new Button((Composite)filterGroup, 16);
        propagateTechnicalWithoutFilteringButton.setText(MetricMessages.progressMonitoring_dialog_propagate_technical_button_lbl);
        propagateTechnicalWithoutFilteringButton.setToolTipText(MetricMessages.progressMonitoring_dialog_propagate_technical_button_tooltip);
        propagateTechnicalWithoutFilteringButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        propagateTechnicalWithoutFilteringButton.setSelection(this.propagateChoiceFiltering == PropagateChoice.ALL_CAPELLA_ELEMENTS);
        propagateTechnicalWithoutFilteringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressSetDialog.this.propagateChoiceFiltering = PropagateChoice.ALL_CAPELLA_ELEMENTS;
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Button propagateToRepresentationButton = new Button((Composite)filterGroup, 32);
        propagateToRepresentationButton.setText(MetricMessages.progressMonitoring_dialog_propagate_to_representation_button_lbl);
        propagateToRepresentationButton.setToolTipText(MetricMessages.progressMonitoring_dialog_propagate_to_representation_button_tooltip);
        propagateToRepresentationButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        propagateToRepresentationButton.setSelection(this.propagateToRepresentation);
        propagateToRepresentationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressSetDialog.this.propagateToRepresentation = ((Button)event.getSource()).getSelection();
                ProgressSetDialog.this.refreshWizard();
            }
        });
        Button filterStatusButton = new Button((Composite)filterGroup, 32);
        filterStatusButton.setText(MetricMessages.progressMonitoring_filterStatus_button_lbl);
        filterStatusButton.setToolTipText(MetricMessages.progressMonitoring_filterStatus_button_tooltip);
        final Combo comboFilter = new Combo((Composite)filterGroup, 2060);
        comboFilter.setEnabled(false);
        comboFilter.setLayoutData((Object)new GridData(4, 4, true, true));
        comboFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProgressSetDialog.this.filterStatus = (EnumerationPropertyLiteral)comboFilter.getData(String.valueOf(comboFilter.getSelectionIndex()));
            }
        });
        filterStatusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressSetDialog.this.useFilterStatus = ((Button)e.getSource()).getSelection();
                comboFilter.setEnabled(ProgressSetDialog.this.useFilterStatus);
            }
        });
        this.fillComboBox(this.combo);
        int index = this.getSelectIndex(this.combo);
        this.combo.select(index);
        this.fillComboBox(comboFilter);
        return super.createContents(parent);
    }

    private void fillComboBox(Combo combo) {
        EnumerationPropertyType ept = this.getEnumerationPropertyType();
        int i = 0;
        for (EnumerationPropertyLiteral enumLiteral : ept.getOwnedLiterals()) {
            combo.add(enumLiteral.getLabel());
            combo.setData(String.valueOf(i), (Object)enumLiteral);
            ++i;
        }
        combo.add("");
        combo.setData(String.valueOf(i), null);
        combo.notifyListeners(24, new Event());
    }

    private Group createFilterGroup(Composite composite) {
        Group filterGroup = new Group(composite, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterGroup.setText(MetricMessages.progressMonitoring_filters_group_lbl);
        filterGroup.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        filterGroup.setLayout((Layout)filterLayout);
        filterGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        filterGroup.setFont(composite.getFont());
        return filterGroup;
    }

    private EnumerationPropertyType getEnumerationPropertyType() {
        EObject semanticElement = null;
        Iterator<EObject> iterator = this.affectedObjects.iterator();
        while (iterator.hasNext() && semanticElement == null) {
            EObject next = iterator.next();
            if (next instanceof CapellaElement) {
                semanticElement = next;
                continue;
            }
            if (!(next instanceof DRepresentation)) continue;
            semanticElement = Utils.getTarget((DRepresentation)next);
        }
        Assert.isNotNull(semanticElement);
        EnumerationPropertyType ept = CapellaProjectHelper.getEnumerationPropertyType(semanticElement, (String)"ProgressStatus");
        return ept;
    }

    private int getSelectIndex(Combo combo) {
        HashSet<String> labels = new HashSet<String>();
        for (EObject obj : this.affectedObjects) {
            if (obj instanceof CapellaElement && ((CapellaElement)obj).getStatus() != null) {
                labels.add(((CapellaElement)obj).getStatus().getLabel());
                continue;
            }
            if (!(obj instanceof DRepresentation) || RepresentationAnnotationHelper.getProgressStatus((DRepresentation)((DRepresentation)obj)) == null) continue;
            labels.add(RepresentationAnnotationHelper.getProgressStatus((DRepresentation)((DRepresentation)obj)));
        }
        if (labels.size() == 1) {
            int index = combo.indexOf((String)labels.iterator().next());
            return index != -1 ? index : 0;
        }
        return 0;
    }

    public boolean close() {
        this.affectedObjects = null;
        return super.close();
    }

    public static enum PropagateChoice {
        NO_MODEL_ELEMENTS,
        ONLY_BUSINESS_ELEMENTS,
        ALL_CAPELLA_ELEMENTS;

    }
}

