/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hierarchy;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class HierarchyInformationPresenter
extends InformationPresenter {
    private final ISourceViewer sourceViewer;
    private final IJavaElement javaElement;
    private IRegion region;

    protected static IInformationControlCreator getHierarchyPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                HierarchyInformationControl hierarchyInformationControl = new HierarchyInformationControl(parent, shellStyle, treeStyle);
                return hierarchyInformationControl;
            }
        };
    }

    public HierarchyInformationPresenter(ISourceViewer sourceViewer, IJavaElement javaElement, IRegion region) {
        super(HierarchyInformationPresenter.getHierarchyPresenterControlCreator());
        this.sourceViewer = sourceViewer;
        this.javaElement = javaElement;
        this.region = region;
    }

    protected void computeInformation() {
        this.setCustomInformationControlCreator(null);
        this.setInformation(this.javaElement, this.computeArea(this.region));
        this.presentInformation();
    }

    protected Rectangle computeArea(IRegion region) {
        Rectangle bounds;
        int start = 0;
        int end = 0;
        IRegion widgetRegion = this.modelRange2WidgetRange(region);
        if (widgetRegion != null) {
            start = widgetRegion.getOffset();
            end = widgetRegion.getOffset() + widgetRegion.getLength();
        }
        StyledText styledText = this.sourceViewer.getTextWidget();
        if (end > 0 && start < end) {
            bounds = styledText.getTextBounds(start, end - 1);
        } else {
            Point loc = styledText.getLocationAtOffset(start);
            bounds = new Rectangle(loc.x, loc.y, 0, styledText.getLineHeight(start));
        }
        return bounds;
    }

    protected IRegion modelRange2WidgetRange(IRegion region) {
        if (this.sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = this.sourceViewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }
}

