/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.ui.internal.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.polarsys.kitalpha.transposer.ui.TransposerUiPlugin;
import org.polarsys.kitalpha.transposer.ui.actions.LaunchTransposerAction;
import org.polarsys.kitalpha.transposer.ui.internal.configuration.TransposerLaunchConfigurationHelper;

public class TransposerContributionItem
extends CompoundContributionItem {
    public TransposerContributionItem() {
    }

    public TransposerContributionItem(String id_p) {
        super(id_p);
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = TransposerContributionItem.getPopupMenu();
        return items.toArray(new IContributionItem[items.size()]);
    }

    public static List<IContributionItem> getPopupMenu() {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        HashSet<ILaunchConfiguration> allConfigs = new HashSet<ILaunchConfiguration>();
        ISelection selection = null;
        try {
            selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().getSelection();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        List<?> adaptedSelection = TransposerContributionItem.adaptSelection(selection);
        allConfigs.addAll(TransposerContributionItem.getLaunchConfigurations(adaptedSelection));
        for (ILaunchConfiguration launchConfig : allConfigs) {
            if (launchConfig == null || launchConfig.getName() == "" || launchConfig.getName() == null) continue;
            result.add((IContributionItem)new ActionContributionItem((IAction)new LaunchTransposerAction(launchConfig)));
        }
        return result;
    }

    public static Set<ILaunchConfiguration> getLaunchConfigurations(List<?> selection_p) {
        HashSet<ILaunchConfiguration> result = new HashSet<ILaunchConfiguration>();
        ILaunchConfiguration[] launchConfigurations = new ILaunchConfiguration[]{};
        try {
            launchConfigurations = TransposerLaunchConfigurationHelper.getAllTransposerLaunchConfigurations(selection_p);
        }
        catch (CoreException e) {
            TransposerUiPlugin.getDefault().getLog().log(e.getStatus());
        }
        result.addAll(new HashSet<ILaunchConfiguration>(Arrays.asList(launchConfigurations)));
        return result;
    }

    public static List<?> adaptSelection(ISelection selection) {
        ArrayList result = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List list = structuredSelection.toList();
            return new ArrayList(list);
        }
        return result;
    }

    public static boolean haveLauchConfiguration() {
        return TransposerContributionItem.getPopupMenu().size() > 0;
    }
}

