/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.m2m.internal.qvt.oml.ModelExtentHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.SafeRunner;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TraceSerializer;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtLaunchConfigurationDelegateBase
extends LaunchConfigurationDelegate {
    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        IFile moduleFile = QvtLaunchConfigurationDelegateBase.getModuleFile(configuration);
        if (moduleFile == null || !moduleFile.exists()) {
            return new IProject[0];
        }
        return new IProject[]{moduleFile.getProject()};
    }

    public static QvtModule getQvtModule(ILaunchConfiguration configuration) throws CoreException {
        try {
            String moduleUri = QvtLaunchUtil.getTransformationURI(configuration);
            return TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleUri));
        }
        catch (MdaException e) {
            IStatus errorStatus = MiscUtil.makeErrorStatus(e.getMessage());
            throw new CoreException(errorStatus);
        }
    }

    public static IFile getModuleFile(ILaunchConfiguration configuration) throws CoreException {
        String moduleFileName = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "");
        URI moduleUri = URI.createURI((String)moduleFileName);
        IFile moduleFile = WorkspaceUtils.getWorkspaceFile((URI)moduleUri);
        return moduleFile;
    }

    public static IStatus validate(QvtTransformation transformation, ILaunchConfiguration configuration) throws CoreException {
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        String traceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", "");
        boolean useTraceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
        boolean isIncrementalUpdate = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", false);
        try {
            return QvtValidator.validateTransformation(transformation, targetUris, traceFile, useTraceFile, isIncrementalUpdate, QvtValidator.ValidationType.FULL_VALIDATION);
        }
        catch (MdaException ex) {
            throw new CoreException(StatusUtil.makeErrorStatus((String)ex.getMessage(), (Exception)((Object)ex)));
        }
    }

    public static BaseProcess.IRunnable getSafeRunnable(QvtTransformation transformation, BaseProcess.IRunnable r) throws CoreException {
        return SafeRunner.getSafeRunnable((BaseProcess.IRunnable)r);
    }

    public static void doLaunch(QvtTransformation transformation, ILaunchConfiguration configuration, IContext context) throws Exception {
        ModelContent traceContent;
        ArrayList<ModelContent> inObjects = new ArrayList<ModelContent>();
        ArrayList<TargetUriData> targetData = new ArrayList<TargetUriData>();
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        Iterator<TargetUriData> itrTargetData = targetUris.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (!itrTargetData.hasNext()) {
                throw new MdaException(NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            TargetUriData nextUri = itrTargetData.next();
            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN || transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                ModelContent inModel = null;
                if (nextUri.getContentProvider() != null) {
                    inModel = new ModelContent(nextUri.getContentProvider().getContents());
                } else {
                    URI inUri = QvtLaunchConfigurationDelegateBase.toUri(nextUri.getUriString());
                    inModel = transformation.loadInput(inUri);
                }
                inObjects.add(inModel);
            }
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
            targetData.add(nextUri);
        }
        boolean saveTrace = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
        String traceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", "");
        boolean isIncrementalUpdate = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", false);
        if (isIncrementalUpdate && traceFile != null && (traceContent = EmfUtil.safeLoadModel((URI)URI.createURI((String)traceFile), (ResourceSet)transformation.getResourceSet())) != null) {
            context.getTrace().setTraceContent(traceContent.getContent());
        }
        QvtLaunchConfigurationDelegateBase.doLaunch(transformation, inObjects, targetData, saveTrace ? traceFile : null, context);
    }

    public static void doLaunch(QvtTransformation transformation, List<ModelContent> inObjs, Map<String, Object> configProps, List<ModelExtentContents> outExtents, List<EObject> outMainParams, List<Trace> outTraces, List<String> outConsole) throws MdaException {
        IStatus status = QvtValidator.validateTransformation(transformation, inObjs, null);
        if (status.getSeverity() > 2) {
            throw new MdaException(status);
        }
        Context context = QvtLaunchUtil.createContext(configProps);
        StringWriter consoleLogger = new StringWriter();
        context.setLog((Log)new WriterLog((Writer)consoleLogger));
        TransformationRunner.In in = new TransformationRunner.In(inObjs.toArray(new ModelContent[inObjs.size()]), (IContext)context);
        TransformationRunner.Out out = transformation.run(in);
        outExtents.addAll(out.getExtents());
        for (Object outValue : out.getOutParamValues()) {
            if (outValue instanceof EObject) {
                outMainParams.add((EObject)outValue);
                continue;
            }
            outMainParams.add(null);
        }
        if (out.getTrace() != null) {
            outTraces.add(out.getTrace());
        }
        outConsole.add(consoleLogger.getBuffer().toString());
    }

    public static List<URI> doLaunch(QvtTransformation transformation, List<ModelContent> inObjs, List<TargetUriData> targetData, String traceFileName, IContext context) throws Exception {
        TransformationRunner.In in = new TransformationRunner.In(inObjs.toArray(new ModelContent[inObjs.size()]), context);
        TransformationRunner.Out out = transformation.run(in);
        ResourceSet resSet = transformation.getResourceSet();
        if (resSet == null) {
            for (ModelContent inModel : inObjs) {
                resSet = inModel.getResourceSet();
                if (resSet != null) break;
            }
        }
        if (resSet == null) {
            resSet = EmfUtil.getOutputResourceSet();
        }
        Iterator<ModelExtentContents> itrExtent = out.getExtents().iterator();
        for (TargetUriData outUriData : targetData) {
            if (!itrExtent.hasNext()) {
                throw new MdaException("Incomplete transformation results");
            }
            QvtLaunchConfigurationDelegateBase.saveTransformationResult(itrExtent.next(), outUriData, resSet);
        }
        ArrayList<URI> result = new ArrayList<URI>(out.getOutParamValues().size());
        for (Object outValue : out.getOutParamValues()) {
            if (outValue instanceof EObject) {
                result.add(EcoreUtil.getURI((EObject)((EObject)outValue)));
                continue;
            }
            result.add(null);
        }
        if (out.getTrace() != null && traceFileName != null) {
            URI traceUri = EmfUtil.makeUri((String)traceFileName);
            TraceSerializer traceSerializer = new TraceSerializer(out.getTrace());
            traceSerializer.saveTraceModel(traceUri);
            traceSerializer.markUnboundObjects(traceUri);
        }
        return result;
    }

    private static void saveTransformationResult(ModelExtentContents extent, TargetUriData targetData, ResourceSet resSet) throws MdaException {
        if (targetData.getContentProvider() != null) {
            targetData.getContentProvider().setContents(extent.getAllRootElements());
            return;
        }
        URI outUri = QvtLaunchConfigurationDelegateBase.toUri(targetData.getUriString());
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                try {
                    ModelExtentHelper.saveExtentToResources((List)extent.getAllRootElements(), (ResourceSet)resSet, (URI)outUri);
                    break;
                }
                catch (EmfException e) {
                    throw new MdaException((Throwable)e);
                }
            }
            case EXISTING_CONTAINER: {
                List value;
                EObject container;
                ModelContent loadModel = EmfUtil.loadModel((URI)outUri, (ResourceSet)resSet);
                EObject eObject = container = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
                if (container == null) {
                    throw new MdaException("No object at " + outUri);
                }
                EStructuralFeature feature = container.eClass().getEStructuralFeature(targetData.getFeature());
                if (feature == null) {
                    throw new MdaException("Reference " + targetData.getFeature() + " not found in " + container);
                }
                if (targetData.isClearContents() && FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)feature) && (value = (List)container.eGet(feature)) != null) {
                    value.clear();
                }
                for (EObject out : extent.getAllRootElements()) {
                    if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)feature)) {
                        List value2 = (List)container.eGet(feature);
                        try {
                            value2.add(out);
                            continue;
                        }
                        catch (RuntimeException ex) {
                            throw new MdaException(NLS.bind((String)Messages.QvtLaunchConfigurationDelegateBase_FeatureSetFailure, (Object)EmfUtil.getFullName((EClassifier)out.eClass()), (Object)targetData.getFeature()));
                        }
                    }
                    container.eSet(feature, (Object)out);
                }
                try {
                    QvtLaunchConfigurationDelegateBase.saveResource(container);
                    break;
                }
                catch (IOException e) {
                    throw new MdaException(e.getMessage(), (Throwable)e);
                }
            }
            case INPLACE: {
                throw new MdaException(Messages.QvtValidator_InplaceConfigNotSupported);
            }
        }
        URIUtils.refresh((URI)outUri);
    }

    private static void saveResource(EObject obj) throws IOException {
        Resource resource = obj.eResource();
        if (resource == null) {
            Logger.getLogger().warning("Object has no resource: " + obj);
            return;
        }
        resource.save(EmfUtil.DEFAULT_SAVE_OPTIONS);
    }

    private static URI toUri(String uriString) throws MdaException {
        URI uri = URI.createURI((String)uriString);
        if (uri == null) {
            throw new MdaException(NLS.bind((String)Messages.QvtValidator_InvalidUri, (Object)uriString));
        }
        return uri;
    }
}

