/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.handlers.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.DirectedComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.transition.common.ui.Activator;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.MergeEMFDiffNode;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.Messages;

public class DiffComparisonViewer
extends DirectedComparisonViewer {
    private static final String CHECKIN_ACTION_ALL = "checkin_action_all.gif";
    private static final String CHECKOUT_ACTION_ALL = "checkout_action_all.gif";
    private static boolean mergeAllInProgress = false;
    private static boolean mergeAllSucceed = false;

    public DiffComparisonViewer(Composite parent) {
        super(parent);
    }

    public DiffComparisonViewer(Composite parent, IActionBars actionBars) {
        super(parent, actionBars);
    }

    protected MenuItem createMenuSupportUndoRedo(Menu menu) {
        return null;
    }

    protected void inputChanged(final Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (input instanceof EMFDiffNode) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (IMatch o : DiffComparisonViewer.this.getExpandedElements((EMFDiffNode)input)) {
                        ((ComparisonTreeViewer)DiffComparisonViewer.this._viewerSynthesisMain.getInnerViewer()).expandToLevel((Object)o, 0);
                    }
                }
            });
        }
    }

    protected Collection<IMatch> getExpandedElements(EMFDiffNode node) {
        LinkedList matches = new LinkedList();
        ArrayList<IMatch> result = new ArrayList<IMatch>();
        EComparison comparison = node.getActualComparison();
        matches.addAll(comparison.getContents());
        while (!matches.isEmpty()) {
            IMatch match = (IMatch)matches.removeFirst();
            if (match == null) continue;
            if (node.getCategoryManager().representAsUserDifference(match)) {
                result.add(match);
                continue;
            }
            matches.addAll(comparison.getContentsOf(match));
        }
        return result;
    }

    protected Image getImage(String key) {
        ImageRegistry reg = Activator.getDefault().getImageRegistry();
        Image image = reg.get(key);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.transition.common.ui", (String)("icons/ctool16/" + key));
            image = desc.createImage();
            reg.put(key, image);
        }
        return reg.get(key);
    }

    protected ToolItem createToolMergeAll(ToolBar toolbar, final boolean onLeft) {
        final ToolItem result = new ToolItem(toolbar, 8);
        String imageKey = onLeft ? CHECKIN_ACTION_ALL : CHECKOUT_ACTION_ALL;
        result.setImage(this.getImage(imageKey));
        result.setToolTipText(onLeft ? Messages.ComparisonViewer_MergeAllOnLeftTooltip : Messages.ComparisonViewer_MergeAllOnRightTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiffComparisonViewer.this.mergeAll();
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("PROPERTY_CURRENT_INPUT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_LEFT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_RIGHT".equals(event.getProperty())) {
                    EMFDiffNode input = DiffComparisonViewer.this.getInput();
                    if (input != null && input instanceof MergeEMFDiffNode) {
                        MergeEMFDiffNode mergeInput = (MergeEMFDiffNode)input;
                        result.setEnabled(mergeInput.isMergeAllEnabled(onLeft));
                    }
                } else if ("DIRTY_STATE".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                    mergeAllSucceed = true;
                }
            }
        });
        return result;
    }

    protected boolean interactionsRequiredForMerge(MergeChoiceData choices, EMFDiffNode input, List<EMatch> selectedMatches) {
        if (mergeAllInProgress) {
            return false;
        }
        return super.interactionsRequiredForMerge(choices, input, selectedMatches);
    }

    protected void setupToolsDetailsSide(ToolBar toolbar, boolean onLeft) {
        this.createToolMergeAll(toolbar, onLeft);
        super.setupToolsDetailsSide(toolbar, onLeft);
    }

    boolean mergeAll() {
        IEditableModelScope scope = this.getComparison().getScope(this.getInput().getRoleForSide(true));
        List root = scope.getContents();
        ComparisonSelection selection = this.asComparisonSelection((IStructuredSelection)new StructuredSelection(root));
        mergeAllInProgress = true;
        mergeAllSucceed = false;
        this.merge(false, true, selection);
        mergeAllInProgress = false;
        return mergeAllSucceed;
    }
}

