/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.provider.generic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.kitalpha.validation.ocl.provider.generic.GenericOCLConstraintProvider;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintFactory;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConstraintProviderService {
    private static final GenericConstraintProviderService INSTANCE = new GenericConstraintProviderService();
    private Map<Object, List<? extends AbstractConstraintDescriptor>> registeredProviders = new HashMap<Object, List<? extends AbstractConstraintDescriptor>>();

    public static GenericConstraintProviderService getInstance() {
        return INSTANCE;
    }

    public void registerProvider(GenericConstraintProvider provider) {
        if (!this.registeredProviders.containsKey(provider.getId())) {
            GenericConstraintFactory factory = provider.getConstraintFactory();
            List<AbstractConstraintDescriptor> descriptors = factory.createConstraints();
            this.registeredProviders.put(provider.getId(), descriptors);
            for (AbstractConstraintDescriptor descriptor : descriptors) {
                try {
                    ConstraintRegistry.getInstance().register((IConstraintDescriptor)descriptor);
                    descriptor.setEnabled(!EMFModelValidationPreferences.isConstraintDisabled((String)descriptor.getId()));
                }
                catch (ConstraintExistsException constraintExistsException) {
                    // empty catch block
                }
            }
        }
    }

    public void unregisterProvider(GenericOCLConstraintProvider provider) {
        if (this.registeredProviders.containsKey(provider.getId())) {
            for (AbstractConstraintDescriptor abstractConstraintDescriptor : this.getDescriptors(provider)) {
                ConstraintRegistry.getInstance().unregister((IConstraintDescriptor)abstractConstraintDescriptor);
            }
            this.registeredProviders.remove(provider.getId());
        }
    }

    public List<? extends AbstractConstraintDescriptor> getDescriptors(GenericConstraintProvider provider) {
        List<Object> descriptors = this.registeredProviders.get(provider.getId());
        if (descriptors == null) {
            descriptors = Collections.emptyList();
        }
        return descriptors;
    }
}

