/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static <T> Iterable<T> cast(Iterable<?> iterable, Class<T> type) {
        return new CastedIterable<T>(iterable, type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastedIterable<T>
    implements Iterable<T> {
        private Iterable<?> delegate;
        private Class<T> type;

        public CastedIterable(Iterable<?> delegate, Class<T> type) {
            this.delegate = delegate;
            this.type = type;
        }

        @Override
        public Iterator<T> iterator() {
            return new CastedIterator<T>(this.delegate.iterator(), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastedIterator<T>
    implements Iterator<T> {
        private Iterator<?> delegate;
        private boolean goNext = true;
        private T current = null;
        private Class<T> type;

        public CastedIterator(Iterator<?> delegate, Class<T> type) {
            this.delegate = delegate;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            if (this.goNext) {
                this.current = this.internalNext();
                this.goNext = false;
            }
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.goNext = true;
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        private T internalNext() {
            T next = null;
            while (this.delegate.hasNext() && next == null) {
                Object o = this.delegate.next();
                if (!this.type.isInstance(o)) continue;
                next = this.type.cast(o);
            }
            return next;
        }
    }
}

