/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger.operations;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.helpers.NamespaceExt;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.helpers.ScenarioHelper;
import org.polarsys.capella.core.refinement.merge.merger.operations.AbstractMergerOperation;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;

public class ScenarioCopy
extends AbstractMergerOperation {
    protected Scenario _source;
    protected Scenario _result;
    private boolean _shouldAddMergeLink;

    public Scenario getResult() {
        return this._result;
    }

    public ScenarioCopy(Scenario source, boolean shouldAddMergeLink) {
        this._source = source;
        this._shouldAddMergeLink = shouldAddMergeLink;
    }

    @Override
    public void perform() throws MergeToolException {
        this._result = ScenarioHelper.createScenario(this._source, this._source.getName());
        NamespaceExt.removeTraces((Namespace)this._result);
        this.createInitialMergeLink();
        TimeLapse tlSRC = null;
        InteractionFragment start = null;
        InteractionFragment finish = null;
        for (TimeLapse tl : this._result.getOwnedTimeLapses()) {
            tlSRC = (TimeLapse)LinkUtils.getOutgoingLinkTargets((TraceableElement)tl, LinkEnum.MERGE_LINK).get(0);
            start = (InteractionFragment)LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)tlSRC.getStart(), LinkEnum.MERGE_LINK, this._result).get(0);
            finish = (InteractionFragment)LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)tlSRC.getFinish(), LinkEnum.MERGE_LINK, this._result).get(0);
            tl.setStart(start);
            tl.setFinish(finish);
        }
        MessageEnd sending = null;
        MessageEnd receiving = null;
        SequenceMessage smSrc = null;
        for (SequenceMessage sm : this._result.getOwnedMessages()) {
            smSrc = (SequenceMessage)LinkUtils.getOutgoingLinkTargets((TraceableElement)sm, LinkEnum.MERGE_LINK).get(0);
            sending = (MessageEnd)LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)smSrc.getSendingEnd(), LinkEnum.MERGE_LINK, this._result).get(0);
            receiving = (MessageEnd)LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)smSrc.getReceivingEnd(), LinkEnum.MERGE_LINK, this._result).get(0);
            sm.setSendingEnd(sending);
            sm.setReceivingEnd(receiving);
        }
    }

    @Override
    public void postOperation() throws MergeToolException {
        if (!this._shouldAddMergeLink) {
            NamespaceExt.removeTraces((Namespace)this._result);
        }
    }

    private void createInitialMergeLink() throws MergeToolException {
        MergeHelper.addMergeLink((CapellaElement)this._result, (CapellaElement)this._source);
        List features = ScenarioExt.getElementOfInterestOnScenario();
        List root = null;
        List tgt = null;
        for (EStructuralFeature feature : features) {
            root = (List)this._source.eGet(feature);
            tgt = (List)this._result.eGet(feature);
            int i = 0;
            while (i < root.size()) {
                MergeHelper.addMergeLink((CapellaElement)tgt.get(i), (CapellaElement)root.get(i));
                ++i;
            }
        }
    }

    @Override
    public void preOperation() throws MergeToolException {
    }
}

