/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.queries.basic.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.helpers.query.IQuery;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public abstract class AbstractComponentFilteredComponentExchange
implements IQuery {
    public List<Object> compute(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.isValidComponentForComponentExchanges(object)) {
            Component comp = (Component)object;
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)comp)) {
                EList componentExchanges = port.getComponentExchanges();
                for (ComponentExchange connection : componentExchanges) {
                    List<Port> relatedPorts = this.getRelatedPorts(connection);
                    for (Port relatedPort : relatedPorts) {
                        if (relatedPort == null || !port.equals(relatedPort)) continue;
                        result.add(connection);
                    }
                }
            }
            EList typedElements = comp.getTypedElements();
            for (TypedElement typedElement : typedElements) {
                if (!(typedElement instanceof Part)) continue;
                Part part = (Part)typedElement;
                EList informationFlows = part.getInformationFlows();
                for (AbstractInformationFlow abstractInformationFlow : informationFlows) {
                    if (!(abstractInformationFlow instanceof ComponentExchange)) continue;
                    ComponentExchange connection = (ComponentExchange)abstractInformationFlow;
                    List<Part> relatedParts = this.getRelatedParts(connection);
                    for (Part relatedPart : relatedParts) {
                        if (relatedPart == null || !part.equals(relatedPart)) continue;
                        result.add(connection);
                    }
                }
            }
        }
        return result;
    }

    public boolean isValidComponentForComponentExchanges(Object object) {
        return object instanceof AbstractActor || object instanceof System || object instanceof LogicalComponent || object instanceof PhysicalComponent;
    }

    public abstract List<Port> getRelatedPorts(ComponentExchange var1);

    public abstract List<Part> getRelatedParts(ComponentExchange var1);

    public List<Partition> getOwnedPartitionableElements(Object object) {
        ArrayList<Partition> ownedPartitions = new ArrayList<Partition>(0);
        if (object != null && object instanceof PartitionableElement) {
            PartitionableElement element = (PartitionableElement)object;
            ownedPartitions.addAll((Collection<Partition>)element.getOwnedPartitions());
        }
        return ownedPartitions;
    }
}

