/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.dialogs.Messages;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.ISelectInvokedOperationModel;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.AbstractCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationController;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationFilter;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationLabelProvider;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class SelectInvokedOperationView
extends SelectElementsDialog {
    protected Button optionSelectionA_button;
    protected Button optionSelectionB_button;
    protected Button optionSelectionC_button;
    protected Button optionCreationA_button;
    protected Button optionCreationB_button;
    protected Button synchronousRadioButton;
    protected Button asynchronousRadioButton;
    protected Button eventRadioButton;
    protected Button flowRadioButton;
    protected Button operationRadioButton;
    protected Button sharedRadioButton;
    protected Group eiTypeGroup;
    protected Button unsetRadioButton;
    protected Button createElementButton;
    protected Text exchangeItemNameText;
    protected Text interfaceText;
    protected Button selectInterfaceButton;
    protected ISelectInvokedOperationModel model;
    protected SelectInvokedOperationController controller;

    public SelectInvokedOperationView(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage, ISelectInvokedOperationModel model, SelectInvokedOperationController controller) {
        super(parentShell, (IContentProvider)new DataContentProvider(), (DataLabelProvider)new SelectInvokedOperationLabelProvider(editingDomain, adapterFactory, model), dialogTitle, dialogMessage, model.getPossibleElements(), false, null, -1);
        this.model = model;
        this.controller = controller;
    }

    protected Shell getTheParentShell() {
        return this.getParentShell();
    }

    public void create() {
        super.create();
        this.getShell().setMinimumSize(661, 800);
    }

    protected void updateButtons(ISelection selection) {
        if (this.controller != null) {
            this.controller.selectionHasChanged(selection);
        }
    }

    public AbstractCommunication getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractCommunication) {
            return (AbstractCommunication)selectedElement;
        }
        return null;
    }

    protected int getTreeViewerStyle() {
        return 2;
    }

    protected TreeAndListViewer getTreeViewer() {
        return super.getViewer();
    }

    protected Button getOkButton() {
        return this.getButton(0);
    }

    protected void doCreateDialogArea(Composite parent) {
        this.createSequenceMessageKind_area(parent);
        this.createElementCreation_area(parent);
        this.createInterface_area(parent);
        super.doCreateDialogArea(parent);
        TreeAndListViewer viewer = this.getViewer();
        viewer.getClientViewer().addFilter((ViewerFilter)new SelectInvokedOperationFilter(viewer, this.model));
        this.createSelectionOptions_area(parent);
        this.createCreationOptions_area(parent);
        this.controller.initControlOnView(this);
    }

    protected void addDoubleCLickListener() {
    }

    protected void createTreeViewerPart(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_SelectExistingOperationGroup_Title);
        treeViewerPartGroup.setLayout((Layout)new GridLayout());
        treeViewerPartGroup.setLayoutData((Object)new GridData(1808));
        super.createTreeViewerPart((Composite)treeViewerPartGroup);
    }

    private void createSequenceMessageKind_area(Composite parent) {
        Group messageKindGroup = new Group(parent, 0);
        messageKindGroup.setText(Messages.SelectOperationDialog_SequenceMessageKind);
        messageKindGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        messageKindGroup.setLayout((Layout)new GridLayout(2, false));
        this.synchronousRadioButton = new Button((Composite)messageKindGroup, 16);
        this.synchronousRadioButton.setText(Messages.SelectOperationDialog_SequenceMessageKind_synchronous);
        this.asynchronousRadioButton = new Button((Composite)messageKindGroup, 16);
        this.asynchronousRadioButton.setText(Messages.SelectOperationDialog_SequenceMessageKind_asynchronous);
        boolean isSynchronous = this.model.getMessageKind() == MessageKind.SYNCHRONOUS_CALL;
        this.synchronousRadioButton.setSelection(isSynchronous);
        this.asynchronousRadioButton.setSelection(!isSynchronous);
        this.synchronousRadioButton.setEnabled(this.model.doesTheMessageReturnAValue());
    }

    private void createElementCreation_area(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(3, false));
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_CreateNewExchangeItem);
        this.createElementButton = new Button((Composite)treeViewerPartGroup, 32);
        this.createElementButton.setText(Messages.SelectOperationDialog_EnableCreationButton_Title);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this.createElementButton.setLayoutData((Object)layoutData);
        this.createElementButton.setSelection(this.model.doesElementMustBeCreated());
        this.createLabel((Composite)treeViewerPartGroup, Messages.SelectOperationDialog_Operation_Title);
        this.exchangeItemNameText = this.createText((Composite)treeViewerPartGroup);
        ((GridData)this.exchangeItemNameText.getLayoutData()).horizontalSpan = 3;
        this.eiTypeGroup = new Group((Composite)treeViewerPartGroup, 0);
        this.eiTypeGroup.setText(Messages.SelectOperationDialog_2);
        this.eiTypeGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        this.eiTypeGroup.setLayout((Layout)new GridLayout(5, false));
        this.eventRadioButton = new Button((Composite)this.eiTypeGroup, 16);
        this.eventRadioButton.setText(Messages.SelectOperationDialog_3);
        this.flowRadioButton = new Button((Composite)this.eiTypeGroup, 16);
        this.flowRadioButton.setText(Messages.SelectOperationDialog_4);
        this.operationRadioButton = new Button((Composite)this.eiTypeGroup, 16);
        this.operationRadioButton.setText(Messages.SelectOperationDialog_5);
        this.sharedRadioButton = new Button((Composite)this.eiTypeGroup, 16);
        this.sharedRadioButton.setText(Messages.SelectOperationDialog_6);
        this.unsetRadioButton = new Button((Composite)this.eiTypeGroup, 16);
        this.unsetRadioButton.setText(Messages.SelectOperationDialog_7);
    }

    private void createInterface_area(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_CreateOrSelectInterface);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(3, false));
        this.createLabel((Composite)treeViewerPartGroup, Messages.SelectOperationDialog_Interface_Title);
        this.interfaceText = this.createText((Composite)treeViewerPartGroup);
        this.selectInterfaceButton = new Button((Composite)treeViewerPartGroup, 8);
        this.selectInterfaceButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.browse"));
    }

    protected void refreshPossibleElementsTree() {
        this.getTreeViewer().getClientViewer().expandAll();
        this.getViewer().getClientViewer().refresh();
    }

    private void createSelectionOptions_area(Composite parent) {
        this.optionSelectionA_button = new Button(this.getViewer().getControl(), 32);
        this.optionSelectionA_button.setText(Messages.SelectOperationDialog_HideTechnicalInterfaceNamesButton_Title);
        this.optionSelectionA_button.setSelection(this.model.doesHideTechnicalInterfaceNames());
        this.optionSelectionB_button = new Button(this.getViewer().getControl(), 32);
        this.optionSelectionB_button.setText(Messages.SelectOperationDialog_RestrictedInterfacesButton_Title);
        this.optionSelectionB_button.setSelection(this.model.doesRestrictToExistingStaticCommunicationCompatibility());
        this.optionSelectionC_button = new Button(this.getViewer().getControl(), 32);
        this.optionSelectionC_button.setText(Messages.SelectOperationDialog_1);
        this.optionSelectionC_button.setSelection(this.model.doesAllowSelectionOfExistingExchangeItems());
    }

    private void createCreationOptions_area(Composite parent) {
        this.optionCreationA_button = new Button(parent, 32);
        this.optionCreationA_button.setText(Messages.SelectOperationDialog_0);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this.optionCreationA_button.setLayoutData((Object)layoutData);
        this.optionCreationA_button.setSelection(this.model.doesPortsMustBeCreated());
        this.optionCreationB_button = new Button(parent, 32);
        this.optionCreationB_button.setText(Messages.SelectOperationDialog_8);
        layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this.optionCreationB_button.setLayoutData((Object)layoutData);
        this.optionCreationB_button.setSelection(this.model.doesPortsMustBeCreated());
    }

    protected List<? extends EObject> handleResult() {
        return Collections.singletonList(this.model.createOrUpdateElement());
    }
}

