/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.ui.quickfix.resolver;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.core.ui.quickfix.messages.CoreQuickFixMessages;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelInconsistency;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelInconsistencyDetector;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.quickfix.InterModelErrorNavigatorDialog;

public class I_34_Resolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        List tgts = this.getModelElements(marker);
        SystemEngineering se = (SystemEngineering)tgts.get(0);
        List inconsistencies = new InterModelInconsistencyDetector().getInterModelInconsistencies(se);
        if (inconsistencies.size() > 0) {
            InterModelErrorNavigatorDialog dialog = new InterModelErrorNavigatorDialog(((InterModelInconsistency)inconsistencies.get(0)).getInvolvedObjects(), "Inter-model inconsistency details", "Capella Element(s) involved in detected inter-model inconsistencies (inter-model cycles and dependency violations).", "Select inter-model inconsistency:");
            dialog.setCycles(inconsistencies);
            dialog.setContextMenuManagerFiller(new AbstractContextMenuFiller(){

                public void fillMenuManager(IMenuManager contextMenuManager, final ISelection selection) {
                    final EObject selectedEObject = (EObject)((TreeSelection)selection).iterator().next();
                    final LocateInCapellaExplorerAction selectInExplorerDelegate = new LocateInCapellaExplorerAction(){

                        protected ISelection getSelection() {
                            return selection;
                        }
                    };
                    selectInExplorerDelegate.shouldIgnoreWorkbenchPartSite(true);
                    Action selectInExplorerAction = new Action(){

                        public void run() {
                            selectInExplorerDelegate.run((IAction)this);
                        }
                    };
                    selectInExplorerAction.setText(Messages.ImpactAnalysisAction_ShowInCapellaExplorer_Title);
                    selectInExplorerAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
                    selectInExplorerDelegate.selectionChanged((IAction)selectInExplorerAction, selection);
                    if (selectInExplorerAction.isEnabled()) {
                        contextMenuManager.add((IAction)selectInExplorerAction);
                    }
                    final LocateInCapellaExplorerAction selectInSemanticBrowserDelegate = new LocateInCapellaExplorerAction(){

                        protected ISelection getSelection() {
                            return selection;
                        }
                    };
                    selectInSemanticBrowserDelegate.shouldIgnoreWorkbenchPartSite(true);
                    Action selectInSemanticBrowserAction = new Action(){

                        public void run() {
                            try {
                                this.activateSemanticBrowser();
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                            selectInSemanticBrowserDelegate.run((IAction)this);
                        }

                        private void activateSemanticBrowser() throws CoreException {
                            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            SemanticBrowserView smView = (SemanticBrowserView)activePage.findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                            if (smView == null) {
                                smView = (SemanticBrowserView)activePage.showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                            }
                            activePage.activate((IWorkbenchPart)smView);
                            smView.setInput((Object)selectedEObject);
                        }
                    };
                    selectInSemanticBrowserAction.setText(CoreQuickFixMessages.selectInSemanticBrowser);
                    selectInSemanticBrowserAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
                    selectInSemanticBrowserDelegate.selectionChanged((IAction)selectInSemanticBrowserAction, selection);
                    if (selectInSemanticBrowserAction.isEnabled()) {
                        contextMenuManager.add((IAction)selectInSemanticBrowserAction);
                    }
                }
            });
            dialog.open();
        }
    }

    protected String[] getResolvableRuleIds() {
        return noRuleIds;
    }
}

