/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.UIUtil;
import org.polarsys.capella.common.ui.toolkit.ToolkitPlugin;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.requirement.RequirementsTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.AddSrcElementToTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.AddTgtElementToTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.AddTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.DeleteTrace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.RemoveSourceTraceElement;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands.RemoveTargetTraceElement;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.components.TraceTreeViewer;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.SourceElementContentProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.TargetElementContentProvider;

public class TraceUtil {
    private static boolean _isVoidTrace = false;

    public static void addTraces(TraceableElement workingElement_p, TraceableElement currentElement_p, String traceType_p, TraceTreeViewer.TraceType traceDestinationType_p, Object element_p) {
        if (element_p == null || !(element_p instanceof TraceableElement)) {
            if (element_p instanceof Trace) {
                Trace trace = (Trace)element_p;
                if (traceDestinationType_p.equals((Object)TraceTreeViewer.TraceType.SOURCE_ELEMENT)) {
                    TraceUtil.executeCommand((EObject)trace, new AddSrcElementToTrace(trace, currentElement_p));
                    TraceUtil.setIsVoidTrace(trace.getSourceElement() == null);
                } else {
                    TraceUtil.executeCommand((EObject)trace, new AddTgtElementToTrace(trace, currentElement_p));
                    TraceUtil.setIsVoidTrace(trace.getTargetElement() == null);
                }
            } else if ((element_p == null || element_p instanceof Class) && traceType_p != null) {
                if (traceDestinationType_p.equals((Object)TraceTreeViewer.TraceType.SOURCE_ELEMENT)) {
                    TraceUtil.executeCommand((EObject)currentElement_p, new AddTrace(currentElement_p, workingElement_p, traceType_p));
                } else {
                    TraceUtil.executeCommand((EObject)currentElement_p, new AddTrace(workingElement_p, currentElement_p, traceType_p));
                }
            }
        }
    }

    public static void removeTraces(TraceTreeViewer.TraceType traceDestinationType_p, TreeViewer treeViewer_p) {
        ISelection selectedElement = treeViewer_p.getSelection();
        if (selectedElement instanceof IStructuredSelection && ((IStructuredSelection)selectedElement).size() == 1) {
            boolean confirmDeletion;
            boolean isSourceElement = traceDestinationType_p.equals((Object)TraceTreeViewer.TraceType.SOURCE_ELEMENT);
            SourceElementContentProvider provider = isSourceElement ? (SourceElementContentProvider)treeViewer_p.getContentProvider() : (TargetElementContentProvider)treeViewer_p.getContentProvider();
            Object elem = ((IStructuredSelection)selectedElement).getFirstElement();
            if (elem instanceof Trace) {
                Trace traceToDelete = (Trace)elem;
                boolean confirmDeletion2 = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("TraceTreeViewer.confirmation"), (String)Messages.getString("TraceTreeViewer.delete_trace_question"));
                if (confirmDeletion2) {
                    TraceUtil.removeTrace(traceToDelete, isSourceElement);
                    treeViewer_p.refresh();
                }
            } else if (elem instanceof TraceableElement) {
                Object parent;
                TraceableElement eltToDelete = (TraceableElement)elem;
                boolean confirmDeletion3 = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("TraceTreeViewer.confirmation"), (String)(String.valueOf(Messages.getString("TraceTreeViewer.delete_src_named_elt_question")) + " " + Messages.getString("TraceTreeViewer.question_end")));
                if (confirmDeletion3 && (parent = provider.getParent(elem)) instanceof Trace) {
                    Trace trace = (Trace)parent;
                    if (isSourceElement) {
                        TraceUtil.executeCommand((EObject)trace, new RemoveSourceTraceElement(trace, eltToDelete));
                        TraceUtil.setIsVoidTrace(trace.getSourceElement() == null);
                    } else {
                        TraceUtil.executeCommand((EObject)trace, new RemoveTargetTraceElement(trace, eltToDelete));
                        TraceUtil.setIsVoidTrace(trace.getTargetElement() == null);
                    }
                    TraceUtil.removeTrace(trace, isSourceElement);
                    treeViewer_p.refresh();
                }
            } else if (elem instanceof Class && (confirmDeletion = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("TraceTreeViewer.confirmation"), (String)Messages.getString("TraceTreeViewer.delete_traceinstance_question")))) {
                Object[] traces;
                Object[] objectArray = traces = provider.getChildren(elem);
                int n = traces.length;
                int n2 = 0;
                while (n2 < n) {
                    Object trace = objectArray[n2];
                    Trace traceToDelete = (Trace)trace;
                    TraceUtil.removeTrace(traceToDelete, isSourceElement);
                    ++n2;
                }
                treeViewer_p.refresh();
            }
        }
    }

    private static void removeTrace(Trace traceToDelete, boolean isSourceElementTraceType) {
        boolean containsFlag;
        TraceableElement owningElt = (TraceableElement)traceToDelete.eContainer();
        TraceUtil.executeCommand((EObject)owningElt, new DeleteTrace(traceToDelete));
        boolean bl = containsFlag = isSourceElementTraceType ? owningElt.getIncomingTraces().contains((Object)traceToDelete) : owningElt.getOutgoingTraces().contains((Object)traceToDelete);
        boolean emptyFlag = isSourceElementTraceType ? traceToDelete.getSourceElement() == null : traceToDelete.getTargetElement() == null;
        TraceUtil.setIsVoidTrace(containsFlag && emptyFlag);
    }

    public static boolean containsTraceElement(TraceableElement currentElement_p, TraceableElement element_p) {
        if (currentElement_p.equals(element_p)) {
            return true;
        }
        for (AbstractTrace trace : currentElement_p.getIncomingTraces()) {
            if (trace.getSourceElement() == element_p) {
                return true;
            }
            if (trace.getTargetElement() != element_p) continue;
            return true;
        }
        for (AbstractTrace trace : currentElement_p.getOutgoingTraces()) {
            if (trace.getSourceElement() == element_p) {
                return true;
            }
            if (trace.getTargetElement() != element_p) continue;
            return true;
        }
        return false;
    }

    public static boolean canAddRemoveItemsToTrace(Object element_p) {
        if (element_p instanceof GenericTrace || element_p instanceof RequirementsTrace) {
            return true;
        }
        if (element_p instanceof Class) {
            Class clazz = (Class)element_p;
            if (GenericTrace.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (RequirementsTrace.class.isAssignableFrom(clazz)) {
                return true;
            }
        }
        return false;
    }

    public static boolean canEnableAddItem(Object element_p) {
        if (element_p instanceof AbstractNamedElement) {
            return false;
        }
        return element_p instanceof Class;
    }

    public static void setIsVoidTrace(boolean _isVoidTrace_p) {
        _isVoidTrace = _isVoidTrace_p;
    }

    public static boolean isIsVoidTrace() {
        return _isVoidTrace;
    }

    public static void findAndSelectElement(CapellaElement currentElement_p) {
        UIUtil.getInstance().selectInPackageExplorer((EObject)currentElement_p);
    }

    public static void executeCommand(EObject context_p, AbstractReadWriteCommand command_p) {
        if (ToolkitPlugin.getDefault().isTransactionRunning()) {
            command_p.run();
        } else {
            TransactionHelper.getExecutionManager((EObject)context_p).execute((ICommand)command_p);
        }
    }
}

