/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Trace;

public class SourceElementContentProvider
implements ITreeContentProvider {
    protected CapellaElement _currentElement;
    protected Map<TraceableElement, AbstractTrace> _parentLinkMap = new HashMap<TraceableElement, AbstractTrace>();
    protected List<Class<? extends AbstractTrace>> _traceType = new ArrayList<Class<? extends AbstractTrace>>();

    public Object[] getChildren(Object parentElement_p) {
        TraceableElement result;
        if (parentElement_p instanceof Class) {
            EList srcTraceList = this._currentElement.getIncomingTraces();
            ArrayList<AbstractTrace> result2 = new ArrayList<AbstractTrace>();
            for (AbstractTrace trace : srcTraceList) {
                if (!trace.getClass().equals(parentElement_p)) continue;
                result2.add(trace);
            }
            return result2.toArray();
        }
        if (parentElement_p instanceof Trace && (result = ((Trace)parentElement_p).getSourceElement()) != null) {
            this._parentLinkMap.put(result, (AbstractTrace)parentElement_p);
            return Collections.singleton(result).toArray();
        }
        return null;
    }

    public Object getParent(Object element_p) {
        if (element_p instanceof AbstractNamedElement) {
            return this._parentLinkMap.get(element_p);
        }
        if (element_p instanceof Trace) {
            return ((Trace)element_p).getClass();
        }
        return null;
    }

    public boolean hasChildren(Object element_p) {
        if (element_p instanceof AbstractNamedElement) {
            return false;
        }
        return element_p instanceof Trace || element_p instanceof Class;
    }

    public Object[] getElements(Object inputElement_p) {
        if (inputElement_p instanceof CapellaElement) {
            this._currentElement = (CapellaElement)inputElement_p;
            EList srcTraceList = ((CapellaElement)inputElement_p).getIncomingTraces();
            this._traceType.clear();
            for (AbstractTrace currentTrace : srcTraceList) {
                if (this._traceType.contains(currentTrace.getClass())) continue;
                this._traceType.add(currentTrace.getClass());
            }
            return this._traceType.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        this._currentElement = (CapellaElement)newInput_p;
        this._parentLinkMap.clear();
    }

    public List<Class<? extends AbstractTrace>> getTraceType() {
        return this._traceType;
    }
}

