/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.af.integration.listener;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.core.af.integration.listener.MetadataException;
import org.polarsys.capella.core.af.integration.listener.NoMetadataException;
import org.polarsys.capella.core.af.integration.listener.WrongCapellaVersionException;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class MetadataCheckAdapter
extends AdapterImpl {
    private boolean force = false;

    public boolean isForced() {
        return this.force;
    }

    public MetadataCheckAdapter() {
        this(false);
    }

    public MetadataCheckAdapter(boolean force) {
        this.force = force;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet && notification.getEventType() == 3 && notification.getNewValue() instanceof Resource) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            Resource res = (Resource)notification.getNewValue();
            this.checkMetadata(resourceSet, res);
        }
    }

    protected void checkMetadata(ResourceSet resourceSet, Resource res) {
        URI uri = res.getURI();
        if ("aird".equals(uri.fileExtension()) && uri.isPlatformResource() && CapellaResourceHelper.isCapellaProject((Resource)res)) {
            this.doCheckMetadata(resourceSet, uri);
        }
    }

    protected void doCheckMetadata(ResourceSet resourceSet, URI uri) {
        this.loadRelativeMetadata(uri, resourceSet);
        this.checkNoMetadata(resourceSet);
        this.checkMetadataCompliancy(resourceSet);
    }

    protected void loadRelativeMetadata(URI uri, ResourceSet resourceSet) {
        block3: {
            URI afmUri = uri.trimFileExtension().appendFileExtension("afm");
            try {
                resourceSet.getResource(afmUri, true);
            }
            catch (MetadataException e) {
                throw e;
            }
            catch (Exception e) {
                Resource resource = resourceSet.getResource(afmUri, false);
                if (resource == null || !resource.getContents().isEmpty()) break block3;
                resource.unload();
                resourceSet.getResources().remove((Object)resource);
            }
        }
    }

    protected void checkNoMetadata(ResourceSet resourceSet) {
        if (!ViewpointManager.getInstance((ResourceSet)resourceSet).hasMetadata()) {
            throw new NoMetadataException(MetadataHelper.getViewpointMetadata((ResourceSet)resourceSet).getExpectedMetadataStorageURI().toPlatformString(true));
        }
    }

    protected void checkMetadataCompliancy(ResourceSet resourceSet) {
        IStatus result = ViewpointManager.checkViewpointsCompliancy((ResourceSet)resourceSet);
        if (!result.isOK()) {
            IStatus capella = ViewpointManager.checkViewpointCompliancy((ResourceSet)resourceSet, (String)"org.polarsys.capella.core.viewpoint");
            if (!capella.isOK()) {
                throw new WrongCapellaVersionException(capella);
            }
            throw new MetadataException(result);
        }
    }
}

