/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.interModelInconsistencyDetection;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyChecker;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyViolation;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class ResourceSetListenerForInterModelInconsistencyDetection
extends ResourceSetListenerImpl {
    protected DependencyChecker linkChecker;

    public Command transactionAboutToCommit(ResourceSetChangeEvent event_p) throws RollbackException {
        if (CapellaModelPreferencesPlugin.getDefault().isInterModelDependencyViolationDetectionActivated()) {
            boolean noViolations = true;
            this.linkChecker = new DependencyChecker((SemanticEditingDomainFactory.SemanticEditingDomain)event_p.getEditingDomain());
            try {
                for (Notification notification : event_p.getNotifications()) {
                    boolean bl = noViolations = noViolations && this.checkNotification(notification);
                }
                if (!noViolations) {
                    this.rollBackAndLogError();
                }
            }
            finally {
                this.linkChecker = null;
            }
        }
        return null;
    }

    protected boolean checkNotification(Notification notification_p) {
        Object newValue;
        EStructuralFeature feature;
        boolean res = true;
        int eventType = notification_p.getEventType();
        Object notifier = notification_p.getNotifier();
        if (CapellaResourceHelper.isSemanticElement((Object)notifier) && (eventType == 3 || eventType == 5 || eventType == 7 || eventType == 1) && (feature = (EStructuralFeature)notification_p.getFeature()) != null && feature instanceof EReference && (newValue = notification_p.getNewValue()) instanceof EObject) {
            if (!this.linkChecker.checkLink((EObject)notifier, (EObject)newValue, (EReference)feature)) {
                res = false;
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment() && !this.linkChecker.checkAllLinks((EObject)newValue)) {
                res = false;
            }
        }
        return res;
    }

    protected void rollBackAndLogError() throws RollbackException {
        ArrayList<String> violatedDependencyDescriptions = new ArrayList<String>();
        for (DependencyViolation violation : this.linkChecker.getDependencyViolations()) {
            violatedDependencyDescriptions.add(violation.getViolatedDependencyDescription());
        }
        violatedDependencyDescriptions = new ArrayList(new HashSet(violatedDependencyDescriptions));
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < violatedDependencyDescriptions.size()) {
            String description = (String)violatedDependencyDescriptions.get(i);
            b.append(description);
            if (i < violatedDependencyDescriptions.size() - 1) {
                b.append(", ");
            }
            ++i;
        }
        String message = "Operation has been aborted since it is going to add reference(s) between objects that do not conform to model dependency graph (" + b.toString() + ")";
        Logger.getLogger((String)"Default").error((Object)message);
        for (DependencyViolation dependencyViolation : this.linkChecker.getDependencyViolations()) {
            Logger.getLogger((String)"Default").debug((Object)dependencyViolation.getDescription());
        }
        throw new RollbackException((IStatus)new Status(8, "org.polarsys.capella.common.libraries", message));
    }
}

