/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.LibrariesFactory;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.AbstractCapellaModel;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.libraries.model.ModelIdentifier;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class CapellaModel
extends AbstractCapellaModel
implements IModel.Edit {
    private static final String ACTIVE_STATE_PREF_ID = "LIBRARY_ACTIVE_STATE_INFORMATIONS";

    public CapellaModel(ModelIdentifier identifier_p, TransactionalEditingDomain domain_p) {
        super(identifier_p, domain_p);
    }

    public Collection<IModelIdentifier> getReferences() {
        ArrayList<IModelIdentifier> models = new ArrayList<IModelIdentifier>();
        Resource resource = this.getResource(this._domain, this.uriSemanticFile);
        ModelInformation information = CapellaLibraryExt.getModelInformation(resource, false);
        if (information != null) {
            for (LibraryReference reference : information.getOwnedReferences()) {
                ModelInformation library = reference.getLibrary();
                if (library != null && library.eIsProxy()) {
                    ((InternalEObject)reference).eResolveProxy((InternalEObject)library);
                }
                ModelIdentifier identifier = null;
                if (library != null) {
                    identifier = !library.eIsProxy() ? CapellaModel.createModelIdentifier(library.eResource()) : CapellaModel.createModelIdentifier(((InternalEObject)library).eProxyURI().fragment(), ((InternalEObject)library).eProxyURI().trimFragment());
                }
                if (identifier == null) continue;
                models.add(identifier);
            }
        }
        return models;
    }

    public Collection<IModel> getAvailableReferences() {
        ArrayList<IModel> models = new ArrayList<IModel>();
        for (IModelIdentifier reference : this.getReferences()) {
            IModel model = ILibraryManager.INSTANCE.getModel(this._domain, reference);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    protected static ModelIdentifier createModelIdentifier(String identifier, URI uri_p) {
        return new ModelIdentifier(identifier, uri_p);
    }

    public static ModelIdentifier createModelIdentifier(Resource resource_p) {
        Project project = CapellaLibraryExt.getProject(resource_p);
        if (project != null) {
            Resource rootResource = project.eResource();
            ModelInformation information = CapellaLibraryExt.getModelInformation(rootResource, false);
            String identifier = CapellaLibraryExt.getIdentifier((EObject)information);
            return CapellaModel.createModelIdentifier(identifier, rootResource.getURI());
        }
        return null;
    }

    public static IModel createModel(ModelIdentifier identifier_p, TransactionalEditingDomain domain) {
        if (identifier_p == null) {
            return null;
        }
        return new CapellaModel(identifier_p, domain);
    }

    public void addReference(final IModel referencedLibrary_p) {
        CrossReferencerHelper.enableResolveProxy((TransactionalEditingDomain)this._domain);
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)this._domain).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ModelInformation source = CapellaModel.this.getModelInformation(CapellaModel.this, true);
                ModelInformation target = CapellaModel.this.getModelInformation(referencedLibrary_p, true);
                for (LibraryReference reference : source.getOwnedReferences()) {
                    if (reference.getLibrary() == null || !reference.getLibrary().equals(target)) continue;
                    return;
                }
                LibraryReference result = LibrariesFactory.eINSTANCE.createLibraryReference();
                result.setLibrary(target);
                source.getOwnedReferences().add((Object)result);
                result.setAccessPolicy(CapellaModel.this.getDefaultNewAccess(referencedLibrary_p));
                Resource toAdd = target.eResource();
                Session session = SessionManager.INSTANCE.getSession((EObject)source);
                if (session instanceof DAnalysisSessionImpl) {
                    for (DAnalysis analysis : ((DAnalysisSessionImpl)session).allAnalyses()) {
                        analysis.getSemanticResources().add((Object)new ResourceDescriptor(toAdd.getURI()));
                    }
                }
                if (!toAdd.eAdapters().contains((Object)session.getSemanticCrossReferencer())) {
                    toAdd.eAdapters().add((Object)session.getSemanticCrossReferencer());
                }
                CapellaModel.this.notifyLibraryChange(source);
            }
        });
        CrossReferencerHelper.disableResolveProxy((TransactionalEditingDomain)this._domain);
    }

    public void removeReference(final IModel referencedLibrary_p) {
        CrossReferencerHelper.enableResolveProxy((TransactionalEditingDomain)this._domain);
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)this._domain).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ModelInformation source = CapellaModel.this.getModelInformation(CapellaModel.this, true);
                ModelInformation target = CapellaModel.this.getModelInformation(referencedLibrary_p, true);
                LibraryReference toDelete = null;
                for (LibraryReference reference : source.getOwnedReferences()) {
                    if (reference.getLibrary() == null) continue;
                    if (reference.getLibrary().equals(target)) {
                        toDelete = reference;
                        break;
                    }
                    if (!reference.getLibrary().eIsProxy() || !referencedLibrary_p.getIdentifier().getId().equals(((InternalEObject)reference.getLibrary()).eProxyURI().fragment())) continue;
                    toDelete = reference;
                    break;
                }
                if (toDelete != null) {
                    Resource toRemove = toDelete.getLibrary().eResource();
                    Session session = SessionManager.INSTANCE.getSession((EObject)source);
                    if (session instanceof DAnalysisSessionImpl) {
                        for (DAnalysis analysis : ((DAnalysisSessionImpl)session).allAnalyses()) {
                            analysis.getSemanticResources().remove((Object)new ResourceDescriptor(toDelete.getLibrary().eResource().getURI()));
                        }
                    }
                    new CapellaDeleteCommand(ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)CapellaModel.this._domain), Collections.singleton(toDelete), false, false, false).execute();
                    if (toRemove != null) {
                        toRemove.unload();
                        toRemove.eAdapters().removeAll((Collection)toRemove.eAdapters());
                        toRemove.getResourceSet().getResources().remove((Object)toRemove);
                    }
                }
                CapellaModel.this.notifyLibraryChange(source);
            }
        });
        CrossReferencerHelper.disableResolveProxy((TransactionalEditingDomain)this._domain);
    }

    protected void notifyLibraryChange(ModelInformation source_p) {
        LibraryReference reference = LibrariesFactory.eINSTANCE.createLibraryReference();
        source_p.getOwnedReferences().add((Object)reference);
        source_p.getOwnedReferences().remove((Object)reference);
    }

    public void setAccess(final IModel library_p, final AccessPolicy currentAccessPolicy_p) {
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)this._domain).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ModelInformation source = CapellaModel.this.getModelInformation(CapellaModel.this, true);
                ModelInformation target = CapellaModel.this.getModelInformation(library_p, true);
                LibraryReference result = null;
                for (LibraryReference reference : source.getOwnedReferences()) {
                    if (reference.getLibrary() == null || !reference.getLibrary().equals(target)) continue;
                    result = reference;
                }
                if (result != null) {
                    result.setAccessPolicy(currentAccessPolicy_p);
                }
                CapellaModel.this.notifyLibraryChange(source);
            }
        });
    }

    public boolean canReference(IModel referencedLibrary_p) {
        return referencedLibrary_p instanceof CapellaModel && ((CapellaModel)referencedLibrary_p).isLibrary();
    }

    public boolean isActive(IModel library) {
        Preferences activeLibraryPrefInfos = new ConfigurationScope().getNode("org.polarsys.capella.core.libraries").node(ACTIVE_STATE_PREF_ID);
        Preferences libraryContextPref = activeLibraryPrefInfos.node(this.getIdentifier().getName());
        return libraryContextPref.getBoolean(library.getIdentifier().getName(), this.getDefaultActiveState(library));
    }

    public void setActive(IModel library, boolean activeState) {
        final Preferences activeLibraryPrefInfos = new ConfigurationScope().getNode("org.polarsys.capella.core.libraries").node(ACTIVE_STATE_PREF_ID);
        Preferences libraryContextPref = activeLibraryPrefInfos.node(this.getIdentifier().getName());
        libraryContextPref.putBoolean(library.getIdentifier().getName(), activeState);
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)this._domain).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                try {
                    activeLibraryPrefInfos.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                ModelInformation source = CapellaModel.this.getModelInformation(CapellaModel.this, true);
                CapellaModel.this.notifyLibraryChange(source);
            }
        });
    }

    public AccessPolicy getDefaultNewAccess(IModel referencedLibrary_p) {
        return AccessPolicy.READ_ONLY;
    }
}

