/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.AbstractStateRealization;
import org.polarsys.capella.core.data.capellacommon.StateTransitionRealization;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionalChainRealization;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.helpers.ctx.services.CapabilityPkgExt;
import org.polarsys.capella.core.data.helpers.la.services.CapabilityRealizationPkgExt;
import org.polarsys.capella.core.data.information.ExchangeItemRealization;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.interaction.ScenarioRealization;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.ContextInterfaceRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class CapellaElementExt {
    public static List<Component> getComponentHierarchy(CapellaElement element) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (element != null) {
            EObject owner = element.eContainer();
            if (owner instanceof Component) {
                result.add((Component)owner);
            }
            result.addAll(CapellaElementExt.getComponentHierarchy((CapellaElement)owner));
        }
        return result;
    }

    public static boolean areInSameDecompositionAlternative(CapellaElement element1, CapellaElement element2) {
        ComponentArchitecture arch2;
        boolean result = false;
        ComponentArchitecture arch1 = (ComponentArchitecture)EcoreUtil2.getFirstContainer((EObject)element1, (EClass)CsPackage.Literals.COMPONENT_ARCHITECTURE);
        if (arch1 == (arch2 = (ComponentArchitecture)EcoreUtil2.getFirstContainer((EObject)element2, (EClass)CsPackage.Literals.COMPONENT_ARCHITECTURE))) {
            result = true;
        }
        return result;
    }

    public static void cleanTraces(CapellaElement elt) {
        if (elt != null) {
            ArrayList traces = new ArrayList();
            traces.addAll(elt.getOutgoingTraces());
            traces.addAll(elt.getIncomingTraces());
            Namespace ns = null;
            for (AbstractTrace trace : traces) {
                trace.setSourceElement(null);
                trace.setTargetElement(null);
                ns = (Namespace)trace.eContainer();
                ns.getOwnedTraces().remove((Object)trace);
            }
        }
    }

    public static List<AbstractCapabilityPkg> getAbstractCapabilityPkgs(LogicalArchitecture logArch) {
        ArrayList<AbstractCapabilityPkg> list = new ArrayList<AbstractCapabilityPkg>(1);
        if (logArch != null) {
            list.add(logArch.getOwnedAbstractCapabilityPkg());
            list.add(logArch.getOwnedLogicalComponent().getOwnedAbstractCapabilityPkg());
            list.addAll(CapellaElementExt.getAbstractCapabilityPkgs(logArch.getOwnedLogicalComponentPkg()));
        }
        return list;
    }

    public static List<AbstractCapabilityPkg> getAbstractCapabilityPkgs(LogicalComponentPkg lcPkg) {
        ArrayList<AbstractCapabilityPkg> list = new ArrayList<AbstractCapabilityPkg>(1);
        if (lcPkg != null) {
            for (LogicalComponent alc : lcPkg.getOwnedLogicalComponents()) {
                list.add(alc.getOwnedAbstractCapabilityPkg());
            }
        }
        return list;
    }

    public static List<AbstractCapabilityPkg> getAbstractCapabilityPkgs(PhysicalComponent component) {
        ArrayList<AbstractCapabilityPkg> list = new ArrayList<AbstractCapabilityPkg>(1);
        if (component != null) {
            list.add(component.getOwnedAbstractCapabilityPkg());
            for (Partition partition : ComponentExt.getSubParts((PartitionableElement)component)) {
                list.add(((Block)partition.getType()).getOwnedAbstractCapabilityPkg());
            }
        }
        return list;
    }

    public static List<Capability> getAllCapabilities(CapellaElement element) {
        ArrayList<Capability> list = new ArrayList<Capability>();
        if (element != null) {
            AbstractCapabilityPkg aspectPkg = CapellaElementExt.getOwnedAbstractCapabilityPkg(element);
            aspectPkg = element instanceof SystemEngineering ? CapellaElementExt.getOwnedAbstractCapabilityPkg((CapellaElement)SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)element)) : CapellaElementExt.getOwnedAbstractCapabilityPkg(element);
            if (aspectPkg != null && aspectPkg instanceof CapabilityPkg) {
                for (Capability capability : ((CapabilityPkg)aspectPkg).getOwnedCapabilities()) {
                    if (capability == null) continue;
                    list.add(capability);
                }
                for (CapabilityPkg capPkg : ((CapabilityPkg)aspectPkg).getOwnedCapabilityPkgs()) {
                    for (Capability capability : CapabilityPkgExt.getAllCapabilities((CapabilityPkg)capPkg)) {
                        if (capability == null) continue;
                        list.add(capability);
                    }
                }
            }
        }
        return list;
    }

    public static List<CapabilityRealization> getAllCapabilityRealization(CapellaElement currentElement) {
        Set realSet = EObjectExt.getAll((EObject)currentElement, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        ArrayList<CapabilityRealization> realList = new ArrayList<CapabilityRealization>();
        for (EObject obj : realSet) {
            realList.add((CapabilityRealization)obj);
        }
        return realList;
    }

    public static List<CapabilityRealization> getAllCapabilityRealizationInvolvedWith(CapellaElement element) {
        ArrayList<CapabilityRealization> list = new ArrayList<CapabilityRealization>();
        if (element != null) {
            if (element instanceof LogicalComponent) {
                list.addAll(CapellaElementExt.getAllCapabilityRealizationsFromAbstractCapabilityPkg(((LogicalComponent)element).getOwnedAbstractCapabilityPkg()));
            } else {
                AbstractCapabilityPkg aspectPkg = CapellaElementExt.getOwnedAbstractCapabilityPkg(element);
                list.addAll(CapellaElementExt.getAllCapabilityRealizationsFromAbstractCapabilityPkg(aspectPkg));
            }
        }
        return list;
    }

    public static List<CapabilityRealization> getAllCapabilityRealizationsFromAbstractCapabilityPkg(AbstractCapabilityPkg aspectPkg) {
        ArrayList<CapabilityRealization> list = new ArrayList<CapabilityRealization>();
        if (aspectPkg != null && aspectPkg instanceof CapabilityRealizationPkg) {
            for (CapabilityRealization realization : ((CapabilityRealizationPkg)aspectPkg).getOwnedCapabilityRealizations()) {
                if (realization == null) continue;
                list.add(realization);
            }
            for (CapabilityRealizationPkg capRealizationPkg : ((CapabilityRealizationPkg)aspectPkg).getOwnedCapabilityRealizationPkgs()) {
                for (CapabilityRealization realization : CapabilityRealizationPkgExt.getAllCapabilityRealization((CapabilityRealizationPkg)capRealizationPkg)) {
                    if (realization == null) continue;
                    list.add(realization);
                }
            }
        }
        return list;
    }

    public static List<Mission> getAllMissions(SystemEngineering element) {
        List<Mission> list = new ArrayList<Mission>();
        if (element != null) {
            SystemAnalysis arch = SystemEngineeringExt.getOwnedSystemAnalysis(element);
            list = CapellaElementExt.getAllMissionsFromSystemAnalysis(arch);
        }
        return list;
    }

    private static List<Mission> getAllMissionsFromMissionPkg(MissionPkg ownedMissionPkg) {
        ArrayList<Mission> list = new ArrayList<Mission>(1);
        if (ownedMissionPkg != null) {
            list.addAll((Collection<Mission>)ownedMissionPkg.getOwnedMissions());
            for (MissionPkg subClassPkg : ownedMissionPkg.getOwnedMissionPkgs()) {
                list.addAll(CapellaElementExt.getAllMissionsFromMissionPkg(subClassPkg));
            }
        }
        return list;
    }

    private static List<Mission> getAllMissionsFromSystemAnalysis(SystemAnalysis arch) {
        MissionPkg ownedMissionPkg = arch.getOwnedMissionPkg();
        return CapellaElementExt.getAllMissionsFromMissionPkg(ownedMissionPkg);
    }

    public static List<AbstractCapabilityPkg> getAspectPkgs(LogicalComponent component) {
        ArrayList<AbstractCapabilityPkg> list = new ArrayList<AbstractCapabilityPkg>(1);
        if (component != null) {
            list.add(component.getOwnedAbstractCapabilityPkg());
            for (LogicalComponent alc : component.getSubLogicalComponents()) {
                list.addAll(CapellaElementExt.getAspectPkgs(alc));
            }
            for (LogicalArchitecture logArch : component.getOwnedLogicalArchitectures()) {
                list.addAll(CapellaElementExt.getAbstractCapabilityPkgs(logArch));
            }
            for (LogicalComponentPkg lcPkg : component.getOwnedLogicalComponentPkgs()) {
                list.addAll(CapellaElementExt.getAbstractCapabilityPkgs(lcPkg));
            }
        }
        return list;
    }

    public static String getFullPath(NamedElement elt) {
        return CapellaElementExt.getRecursiveFullPath(elt.getName(), elt, null);
    }

    public static String getFullPathFromModel(NamedElement elt) {
        return CapellaElementExt.getRecursiveFullPath(elt.getName(), elt, CapellamodellerPackage.Literals.MODEL_ROOT);
    }

    public static String getFullPathFromProject(NamedElement elt) {
        return CapellaElementExt.getRecursiveFullPath(elt.getName(), elt, CapellamodellerPackage.Literals.PROJECT);
    }

    @Deprecated
    public static Collection<EStructuralFeature.Setting> getInverseReferencesOfEObject(EObject eObj) {
        SemanticEditingDomainFactory.SemanticEditingDomain semEditDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)eObj);
        SemanticCrossReferencer crossReferencer = semEditDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences(eObj);
        return inverseReferences;
    }

    public static String getName(EObject element) {
        String name = "";
        if (element != null && element instanceof AbstractNamedElement) {
            name = ((AbstractNamedElement)element).getName();
        }
        return name;
    }

    public static String getName(List<EObject> elements) {
        StringBuilder builder = new StringBuilder();
        for (EObject element : elements) {
            builder.append(CapellaElementExt.getName(element));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static AbstractCapabilityPkg getOwnedAbstractCapabilityPkg(CapellaElement element) {
        AbstractCapabilityPkg aspectPkg = null;
        if (element != null) {
            if (element instanceof PhysicalComponent) {
                PhysicalArchitecture arch = SystemEngineeringExt.getPhysicalArchitecture(element);
                if (arch != null) {
                    aspectPkg = arch.getOwnedAbstractCapabilityPkg();
                }
            } else if (element instanceof ConfigurationItem) {
                EPBSArchitecture arch = SystemEngineeringExt.getEPBSArchitecture(element);
                if (arch != null) {
                    aspectPkg = arch.getOwnedAbstractCapabilityPkg();
                }
            } else if (element instanceof ComponentArchitecture) {
                aspectPkg = ((ComponentArchitecture)element).getOwnedAbstractCapabilityPkg();
            }
        }
        return aspectPkg;
    }

    private static String getRecursiveFullPath(String name, NamedElement elt, EClass cls) {
        EObject container = elt.eContainer();
        if (cls != null && cls.isSuperTypeOf(container.eClass())) {
            return String.valueOf(((NamedElement)container).getName()) + "." + name;
        }
        if (container != null && container instanceof NamedElement) {
            return CapellaElementExt.getRecursiveFullPath(String.valueOf(((NamedElement)container).getName()) + "." + name, (NamedElement)container, cls);
        }
        return name;
    }

    private static CapellaElement getRecursiveRoot(CapellaElement elt, EClass cls) {
        CapellaElement container = elt;
        if (container != null) {
            if (cls != null && cls.isSuperTypeOf(container.eClass())) {
                return container;
            }
            if ((container = container.eContainer()) != null && container instanceof CapellaElement) {
                return CapellaElementExt.getRecursiveRoot(container, cls);
            }
        }
        return null;
    }

    public static CapellaElement getRefinementSrcElement(CapellaElement srcElement, EClass eclass, EObject linkOwner) {
        for (CapellaElement elt : RefinementLinkExt.getRefinementRelatedSourceElements(srcElement, eclass)) {
            if (!elt.eContainer().equals(linkOwner)) continue;
            return elt;
        }
        return null;
    }

    public static List<CapellaElement> getRefinementSrcElements(CapellaElement srcElement, EClass eclass, EObject linkOwner) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        for (CapellaElement elt : RefinementLinkExt.getRefinementRelatedSourceElements(srcElement, eclass)) {
            if (!elt.eContainer().equals(linkOwner)) continue;
            result.add(elt);
        }
        return result;
    }

    public static CapellaElement getRefinementTgtElement(CapellaElement srcElement, EClass eclass) {
        Iterator<CapellaElement> iterator = RefinementLinkExt.getRefinementRelatedTargetElements(srcElement, eclass).iterator();
        if (iterator.hasNext()) {
            CapellaElement elt = iterator.next();
            return elt;
        }
        return null;
    }

    public static CapellaElement getRoot(CapellaElement elt) {
        return CapellaElementExt.getRecursiveRoot(elt, CapellamodellerPackage.Literals.PROJECT);
    }

    @Deprecated
    public static ModellingArchitecture getArchi(EObject eObject) {
        EObject e = eObject;
        while (!(e instanceof ModellingArchitecture)) {
            e = e.eContainer();
        }
        return (ModellingArchitecture)e;
    }

    public static boolean isLegalArchitecture(ModellingArchitecture interfArchi, ModellingArchitecture componentArchi) {
        EClass[] classes = new EClass[]{OaPackage.Literals.OPERATIONAL_ANALYSIS, CtxPackage.Literals.SYSTEM_ANALYSIS, LaPackage.Literals.LOGICAL_ARCHITECTURE, PaPackage.Literals.PHYSICAL_ARCHITECTURE, EpbsPackage.Literals.EPBS_ARCHITECTURE};
        int interfIndex = 0;
        int componentIndex = 0;
        int i = 0;
        while (i < classes.length) {
            if (classes[i] == interfArchi.eClass()) {
                interfIndex = i;
            }
            if (classes[i] == componentArchi.eClass()) {
                componentIndex = i;
            }
            ++i;
        }
        return interfIndex <= componentIndex;
    }

    public static String getElementNamesSeperatedByComma(List<?> element) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Object object : element) {
            if (!(object instanceof AbstractNamedElement)) continue;
            String eleName = ((AbstractNamedElement)object).getName();
            if (first) {
                result.append(eleName);
                first = false;
                continue;
            }
            result.append(',');
            result.append(' ');
            result.append(eleName);
        }
        return result.toString();
    }

    public static EObject creationService(EObject context, String namingPrefix) {
        TransactionalEditingDomain editingDomain;
        StrictCompoundCommand command;
        if (context instanceof ModelElement && (command = CreationHelper.getAdditionnalCommand((EditingDomain)(editingDomain = TransactionHelper.getEditingDomain((EObject)context)), (ModelElement)((ModelElement)context), (String)namingPrefix)).canExecute()) {
            command.execute();
        }
        return context;
    }

    public static EObject creationService(EObject context) {
        return CapellaElementExt.creationService(context, context.eClass().getName());
    }

    public static String getCapellaExplorerLabel(EObject object) {
        return EObjectLabelProviderHelper.getText((EObject)object);
    }

    public static String getValidationRuleMessagePrefix(AbstractNamedElement ele) {
        if (ele != null) {
            return String.valueOf(ele.getName()) + " (" + ele.eClass().getName() + ") ";
        }
        return "";
    }

    public static boolean isValidTransitionTrace(AbstractTrace abstractTrace) {
        if (abstractTrace == null) {
            return false;
        }
        if (abstractTrace instanceof ComponentAllocation) {
            return true;
        }
        if (abstractTrace instanceof FunctionRealization) {
            return true;
        }
        if (abstractTrace instanceof InformationRealization) {
            return true;
        }
        if (abstractTrace instanceof PortRealization) {
            return true;
        }
        if (abstractTrace instanceof ScenarioRealization) {
            return true;
        }
        if (abstractTrace instanceof StateTransitionRealization) {
            return true;
        }
        if (abstractTrace instanceof FunctionalExchangeRealization) {
            return true;
        }
        if (abstractTrace instanceof FunctionalChainRealization) {
            return true;
        }
        if (abstractTrace instanceof ComponentExchangeRealization) {
            return true;
        }
        if (abstractTrace instanceof ExchangeItemRealization) {
            return true;
        }
        if (abstractTrace instanceof AbstractStateRealization) {
            return true;
        }
        if (abstractTrace instanceof AbstractCapabilityRealization) {
            return true;
        }
        if (abstractTrace instanceof LogicalInterfaceRealization) {
            return true;
        }
        if (abstractTrace instanceof ContextInterfaceRealization) {
            return true;
        }
        return abstractTrace instanceof TransfoLink;
    }
}

