/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecturePkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.TypeDeploymentLink;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class PhysicalComponentExt {
    public static void addDeployedElement(PhysicalComponent location, PhysicalComponent deployedElement) {
        TypeDeploymentLink link = DeploymentFactory.eINSTANCE.createTypeDeploymentLink();
        CapellaElement cont = (CapellaElement)location.eContainer();
        if (cont != null) {
            ((PhysicalComponentPkg)cont).getOwnedDeployments().add((Object)link);
        } else {
            cont = (CapellaElement)location.eContainer();
            ((PhysicalArchitecture)cont).getOwnedDeployments().add((Object)link);
        }
        link.setLocation((DeploymentTarget)location);
        link.setDeployedElement((DeployableElement)deployedElement);
    }

    public static void addDeployerElement(PhysicalComponent deployedElement, PhysicalComponent location) {
        PhysicalComponentExt.addDeployedElement(location, deployedElement);
    }

    public static void addImplementedLogicalComponent(PhysicalComponent physicalComponent, LogicalComponent logicalComponent) {
        LogicalComponentRealization impl = PaFactory.eINSTANCE.createLogicalComponentRealization();
        impl.setTargetElement((TraceableElement)logicalComponent);
        impl.setSourceElement((TraceableElement)physicalComponent);
        physicalComponent.getOwnedLogicalComponentRealizations().add((Object)impl);
    }

    public static Collection<ComponentExchange> findConnectionsBetweenPhysicalComponentes(List<Component> sourceDeployedElements, List<Component> targetDeployedElements) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>(1);
        for (Component component : sourceDeployedElements) {
            Collection<ComponentExchange> allRelatedConnection = ComponentExt.getAllRelatedComponentExchange(component);
            for (ComponentExchange connection : allRelatedConnection) {
                Component targetComponent = ComponentExchangeExt.getTargetComponent(connection);
                if (!targetDeployedElements.contains(targetComponent)) continue;
                result.add(connection);
            }
        }
        return result;
    }

    public static List<PhysicalComponent> getDeployedElements(PhysicalComponent location) {
        ArrayList<PhysicalComponent> deployedElements = new ArrayList<PhysicalComponent>(1);
        EList deployments = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            deployedElements.add((PhysicalComponent)abstractDeployment.getDeployedElement());
        }
        return deployedElements;
    }

    public static List<PhysicalComponent> getDeploymentTargets(PhysicalComponent element) {
        ArrayList<PhysicalComponent> deploymentTargets = new ArrayList<PhysicalComponent>();
        EList deployments = element.getDeployingLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            deploymentTargets.add((PhysicalComponent)abstractDeployment.getLocation());
        }
        return deploymentTargets;
    }

    public static ConfigurationItem getImplementor(PhysicalComponent component, EPBSArchitecture epbsArchitecture) {
        ConfigurationItem implementorCI = null;
        for (ConfigurationItem ci : PhysicalComponentExt.getImplementors(component)) {
            if (!EcoreUtil2.isContainedBy((EObject)ci, (EObject)epbsArchitecture)) continue;
            implementorCI = ci;
        }
        return implementorCI;
    }

    public static List<ConfigurationItem> getImplementors(PhysicalComponent component) {
        ArrayList<ConfigurationItem> configurationItemsList = new ArrayList<ConfigurationItem>(1);
        EList incomingTraces = component.getIncomingTraces();
        for (AbstractTrace incomingTrace : incomingTraces) {
            TraceableElement source;
            if (!(incomingTrace instanceof PhysicalArtifactRealization) || !((source = ((PhysicalArtifactRealization)incomingTrace).getSourceElement()) instanceof ConfigurationItem)) continue;
            configurationItemsList.add((ConfigurationItem)source);
        }
        return configurationItemsList;
    }

    public static List<CapellaElement> getLCsFromLogicalArchitecture(LogicalArchitecture logArch, PhysicalComponent currentPC, boolean isFilterRequired) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        if (logArch != null) {
            for (LogicalComponent lc : LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer(logArch)) {
                if (isFilterRequired && PhysicalComponentExt.hasImplementedLC(currentPC, lc)) continue;
                list.add((CapellaElement)lc);
            }
        }
        return list;
    }

    public static PhysicalArchitecture getOwningPhysicalArchitecture(PhysicalComponent component) {
        return (PhysicalArchitecture)EcoreUtil2.getFirstContainer((EObject)component, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE);
    }

    public static Component getParentContainer(PhysicalComponent component) {
        return PhysicalComponentExt.getRecursiveParentContainer(component);
    }

    public static PhysicalComponent getPhysicalComponentContainerFromScenario(Scenario scenario) {
        PhysicalComponent containerPc = null;
        containerPc = (PhysicalComponent)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
        if (containerPc == null) {
            PhysicalArchitecture pa = (PhysicalArchitecture)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE);
            containerPc = SystemEngineeringExt.getRootPhysicalComponent(pa);
        }
        return containerPc;
    }

    public static List<Interface> getProvidedInterfaces(PhysicalComponent component) {
        ArrayList<Interface> providedItfList = new ArrayList<Interface>(1);
        EList exposedPorts = component.getOwnedPartitions();
        providedItfList.addAll((Collection<Interface>)component.getImplementedInterfaces());
        for (Partition port : exposedPorts) {
            if (!(port instanceof ComponentPort)) continue;
            ComponentPort stdPort = (ComponentPort)port;
            providedItfList.addAll(PortExt.getProvidedInterfaces(stdPort));
        }
        return providedItfList;
    }

    private static PhysicalArchitecture getRecursiveParentArchitecture(PhysicalComponent component) {
        EObject container = component.eContainer();
        if (container instanceof PhysicalArchitecture) {
            return (PhysicalArchitecture)container;
        }
        if (container instanceof PhysicalComponentPkg) {
            return PhysicalComponentExt.getRecursiveParentArchitecture((PhysicalComponentPkg)container);
        }
        if (container instanceof PhysicalComponent) {
            return PhysicalComponentExt.getRecursiveParentArchitecture((PhysicalComponent)container);
        }
        return null;
    }

    private static PhysicalArchitecture getRecursiveParentArchitecture(PhysicalComponentPkg comppkg) {
        EObject container = comppkg.eContainer();
        if (container instanceof PhysicalArchitecture) {
            return (PhysicalArchitecture)container;
        }
        if (container instanceof PhysicalComponentPkg) {
            return PhysicalComponentExt.getRecursiveParentArchitecture((PhysicalComponentPkg)container);
        }
        if (container instanceof PhysicalComponent) {
            return PhysicalComponentExt.getRecursiveParentArchitecture((PhysicalComponent)container);
        }
        return null;
    }

    private static Component getRecursiveParentContainer(PhysicalArchitecture component) {
        System cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof System) {
            cpnt = (System)container;
        } else if (container instanceof PhysicalComponent) {
            cpnt = (PhysicalComponent)container;
        } else if (container instanceof PhysicalArchitecturePkg) {
            cpnt = PhysicalComponentExt.getRecursiveParentContainer((PhysicalArchitecturePkg)container);
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(PhysicalArchitecturePkg component) {
        System cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof System) {
            cpnt = (System)container;
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(PhysicalComponent component) {
        Component cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof PhysicalArchitecture) {
            cpnt = PhysicalComponentExt.getRecursiveParentContainer((PhysicalArchitecture)container);
        } else if (container instanceof PhysicalComponentPkg) {
            cpnt = PhysicalComponentExt.getRecursiveParentContainer((PhysicalComponentPkg)container);
        } else if (container instanceof PhysicalComponent) {
            cpnt = (PhysicalComponent)container;
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(PhysicalComponentPkg componentPkg) {
        Component cpnt = null;
        EObject container = componentPkg.eContainer();
        if (container instanceof PhysicalArchitecture) {
            cpnt = PhysicalComponentExt.getRecursiveParentContainer((PhysicalArchitecture)container);
        } else if (container instanceof PhysicalComponentPkg) {
            cpnt = PhysicalComponentExt.getRecursiveParentContainer((PhysicalComponentPkg)container);
        } else if (container instanceof PhysicalComponent) {
            cpnt = (PhysicalComponent)container;
        }
        return cpnt;
    }

    public static List<Interface> getRequiredInterfaces(PhysicalComponent component) {
        ArrayList<Interface> requiredItfList = new ArrayList<Interface>(1);
        EList exposedPorts = component.getOwnedPartitions();
        requiredItfList.addAll((Collection<Interface>)component.getUsedInterfaces());
        for (Partition port : exposedPorts) {
            if (!(port instanceof ComponentPort)) continue;
            ComponentPort stdPort = (ComponentPort)port;
            requiredItfList.addAll(PortExt.getRequiredInterfaces(stdPort));
        }
        return requiredItfList;
    }

    public static boolean hasImplementedLC(PhysicalComponent currentPC, LogicalComponent lc) {
        boolean flag = false;
        for (LogicalComponentRealization lcImpl : currentPC.getOwnedLogicalComponentRealizations()) {
            if (!lcImpl.getAllocatedComponent().equals(lc)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean haveSameImplementor(PhysicalComponent PC1, PhysicalComponent PC2, EPBSArchitecture epbsArchitecture) {
        ConfigurationItem CI1 = PhysicalComponentExt.getImplementor(PC1, epbsArchitecture);
        ConfigurationItem CI2 = PhysicalComponentExt.getImplementor(PC2, epbsArchitecture);
        if (CI1 == null || CI2 == null) {
            return false;
        }
        return CI1.equals(CI2);
    }

    public static boolean isDeployedOn(PhysicalComponent location, PhysicalComponent deployedElement) {
        EList deployments = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            if (!abstractDeployment.getDeployedElement().equals(deployedElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhysicalComponentRoot(EObject element) {
        if (!(element instanceof PhysicalComponent)) {
            return false;
        }
        return !EcoreUtil2.isContainedBy((EObject)element, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
    }

    public static void removeImplementedLogicalComponent(PhysicalComponent physicalComponent, LogicalComponent logicalComponent) {
        LogicalComponentRealization implementLink = null;
        ListIterator it = physicalComponent.getLogicalComponentRealizations().listIterator();
        while (it.hasNext()) {
            LogicalComponentRealization lnk = (LogicalComponentRealization)it.next();
            if (!lnk.getAllocatedComponent().equals(logicalComponent)) continue;
            implementLink = lnk;
        }
        if (implementLink != null) {
            physicalComponent.getLogicalComponentRealizations().remove(implementLink);
            physicalComponent.getOwnedLogicalComponentRealizations().remove(implementLink);
            implementLink.destroy();
        }
    }

    public static void undeployElement(PhysicalComponent location, PhysicalComponent deployedElement) {
        ArrayList<AbstractDeploymentLink> elementsToDelete = new ArrayList<AbstractDeploymentLink>();
        EList deployements = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployements) {
            if (!abstractDeployment.getDeployedElement().equals(deployedElement)) continue;
            elementsToDelete.add(abstractDeployment);
        }
        for (AbstractDeploymentLink toDelete : elementsToDelete) {
            toDelete.destroy();
        }
    }

    public static boolean isDeploymentPossible(Part sourcePart, Part targetPart) {
        AbstractType sourceType = sourcePart.getAbstractType();
        AbstractType targetType = targetPart.getAbstractType();
        if (sourceType != null && targetType != null && sourceType instanceof PhysicalComponent && targetType instanceof PhysicalComponent) {
            PhysicalComponent sourcePC = (PhysicalComponent)sourceType;
            PhysicalComponent targetPC = (PhysicalComponent)targetType;
            if (sourcePC.getNature() == PhysicalComponentNature.BEHAVIOR && targetPC.getNature() == PhysicalComponentNature.NODE) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNode(PhysicalComponent physicalComponent) {
        return PhysicalComponentNature.NODE == physicalComponent.getNature();
    }

    public static boolean isBehaviour(PhysicalComponent physicalComponent) {
        return PhysicalComponentNature.BEHAVIOR == physicalComponent.getNature();
    }
}

