/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class SystemAnalysisExt {
    public static List<Component> getComponentsFromComponentArchitecture(ComponentArchitecture componentArchitecture) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Object obj : componentArchitecture.eContents()) {
            if (obj instanceof Component) {
                list.add((Component)obj);
                continue;
            }
            if (!(obj instanceof Structure)) continue;
            for (Object content : ((Structure)obj).eContents()) {
                if (!(content instanceof Component)) continue;
                list.add((Component)content);
                list.addAll(ComponentExt.getComponentsFromComponent((Component)content));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof SystemFunctionPkg) {
            list = SystemAnalysisExt.getAllFunctionsFromFunctionPkg((SystemFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof SystemFunctionPkg) {
            list = SystemAnalysisExt.getAllFunctionsFromAbstractFunctionPkg((SystemFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunctionPkg(SystemFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedSystemFunctions = sysFunPkg.getOwnedSystemFunctions();
            list.addAll((Collection<AbstractFunction>)ownedSystemFunctions);
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromFunction(function));
            }
            for (SystemFunctionPkg ownedSysFunPkg : sysFunPkg.getOwnedSystemFunctionPkgs()) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromFunctionPkg(ownedSysFunPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromAbstractFunctionPkg(SystemFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedSystemFunctions = sysFunPkg.getOwnedSystemFunctions();
            list.addAll((Collection<AbstractFunction>)ownedSystemFunctions);
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromAbstractFunction(function));
            }
            for (SystemFunctionPkg ownedSysFunPkg : sysFunPkg.getOwnedSystemFunctionPkgs()) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromAbstractFunctionPkg(ownedSysFunPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromFunction(function));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromAbstractFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(SystemAnalysisExt.getAllFunctionsFromAbstractFunction(function));
            }
        }
        return list;
    }

    public static MissionPkg getMissionPkg(SystemAnalysis architecture) {
        if (architecture.getOwnedMissionPkg() == null) {
            MissionPkg pkg = CtxFactory.eINSTANCE.createMissionPkg("Missions");
            architecture.setOwnedMissionPkg(pkg);
        }
        return architecture.getOwnedMissionPkg();
    }
}

