/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSArchitecturePkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecturePkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecturePkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;

public class CapellaLayerCheckingExt {
    public static void getAll_ContainerElements(CapellaElement ele, ArrayList<CapellaElement> eleList) {
        EObject elodyElement = ele.eContainer();
        if (elodyElement != null) {
            eleList.add((CapellaElement)elodyElement);
            CapellaLayerCheckingExt.getAll_ContainerElements((CapellaElement)elodyElement, eleList);
        }
    }

    public static boolean isAOrInOperationalAnalysisLayer(CapellaElement ele) {
        return ele instanceof OperationalAnalysis || CapellaLayerCheckingExt.isInOperationalAnalysisLayer(ele);
    }

    public static boolean isInOperationalAnalysisLayer(CapellaElement ele) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements(ele, meleList);
        for (CapellaElement element : meleList) {
            if (!(element instanceof OperationalAnalysis) && !(element instanceof OperationalActivityPkg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAOrInLogicalLayer(CapellaElement ele) {
        return ele instanceof LogicalArchitecture || CapellaLayerCheckingExt.isInLogicalLayer(ele);
    }

    public static boolean isInLogicalLayer(CapellaElement ele) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements(ele, meleList);
        meleList.add(ele);
        for (CapellaElement element : meleList) {
            if (!(element instanceof LogicalArchitecture) && !(element instanceof LogicalArchitecturePkg) && !(element instanceof LogicalComponent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAOrInContextLayer(CapellaElement ele) {
        return ele instanceof SystemAnalysis || CapellaLayerCheckingExt.isInContextLayer(ele);
    }

    public static boolean isInContextLayer(CapellaElement ele) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements(ele, meleList);
        for (CapellaElement element : meleList) {
            if (!(element instanceof SystemAnalysis)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAOrInPhysicalLayer(CapellaElement ele) {
        return ele instanceof PhysicalArchitecture || CapellaLayerCheckingExt.isInPhysicalLayer(ele);
    }

    public static boolean isInPhysicalLayer(CapellaElement ele) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements(ele, meleList);
        meleList.add(ele);
        for (CapellaElement element : meleList) {
            if (!(element instanceof PhysicalArchitecture) && !(element instanceof PhysicalArchitecturePkg) && !(element instanceof PhysicalComponent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAOrInEPBSLayer(CapellaElement ele) {
        return ele instanceof EPBSArchitecture || CapellaLayerCheckingExt.isInEPBSLayer(ele);
    }

    public static boolean isInEPBSLayer(CapellaElement ele) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements(ele, meleList);
        meleList.add(ele);
        for (CapellaElement element : meleList) {
            if (!(element instanceof ConfigurationItem) && !(element instanceof EPBSArchitecture) && !(element instanceof EPBSArchitecturePkg)) continue;
            return true;
        }
        return false;
    }

    public static LAYERSNAME getLayersName(CapellaElement ele) {
        if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer(ele) || ele instanceof OperationalAnalysis) {
            return LAYERSNAME.OA;
        }
        if (CapellaLayerCheckingExt.isInContextLayer(ele) || ele instanceof SystemAnalysis) {
            return LAYERSNAME.CTX;
        }
        if (CapellaLayerCheckingExt.isInLogicalLayer(ele) || ele instanceof LogicalArchitecture) {
            return LAYERSNAME.LA;
        }
        if (CapellaLayerCheckingExt.isInPhysicalLayer(ele) || ele instanceof PhysicalArchitecture) {
            return LAYERSNAME.PA;
        }
        if (CapellaLayerCheckingExt.isInEPBSLayer(ele) || ele instanceof EPBSArchitecture) {
            return LAYERSNAME.EPBS;
        }
        return LAYERSNAME.INVALID;
    }

    public static boolean areInSameLayer(EObject ele, EObject ele2) {
        BlockArchitecture archi2;
        BlockArchitecture archi1 = BlockArchitectureExt.getRootBlockArchitecture(ele);
        return archi1 == (archi2 = BlockArchitectureExt.getRootBlockArchitecture(ele2)) || archi1.equals(archi2);
    }

    public static boolean isElementFromCurrentOrUpperLayer(CapellaElement elementToCheck, CapellaElement elementOnCurrentLayer) {
        return CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementOnCurrentLayer) ? CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementToCheck) : (CapellaLayerCheckingExt.isAOrInContextLayer(elementOnCurrentLayer) ? CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementToCheck) || CapellaLayerCheckingExt.isAOrInContextLayer(elementToCheck) : (CapellaLayerCheckingExt.isAOrInLogicalLayer(elementOnCurrentLayer) ? !CapellaLayerCheckingExt.isAOrInPhysicalLayer(elementToCheck) && !CapellaLayerCheckingExt.isAOrInEPBSLayer(elementToCheck) : (CapellaLayerCheckingExt.isAOrInPhysicalLayer(elementOnCurrentLayer) ? !CapellaLayerCheckingExt.isAOrInEPBSLayer(elementToCheck) : CapellaLayerCheckingExt.isAOrInEPBSLayer(elementOnCurrentLayer) && CapellaLayerCheckingExt.isAOrInEPBSLayer(elementToCheck))));
    }

    public static boolean isElementFromUpperLayer(CapellaElement elementToCheck, CapellaElement elementOnCurrentLayer) {
        if (elementToCheck == null || elementOnCurrentLayer == null) {
            return false;
        }
        if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementOnCurrentLayer)) {
            return false;
        }
        return CapellaLayerCheckingExt.isAOrInContextLayer(elementOnCurrentLayer) ? CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementToCheck) : (CapellaLayerCheckingExt.isAOrInLogicalLayer(elementOnCurrentLayer) ? CapellaLayerCheckingExt.isAOrInContextLayer(elementToCheck) || CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementToCheck) : (CapellaLayerCheckingExt.isAOrInPhysicalLayer(elementOnCurrentLayer) ? CapellaLayerCheckingExt.isAOrInLogicalLayer(elementToCheck) || CapellaLayerCheckingExt.isAOrInContextLayer(elementToCheck) || CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer(elementOnCurrentLayer) : CapellaLayerCheckingExt.isAOrInEPBSLayer(elementOnCurrentLayer) && !CapellaLayerCheckingExt.isAOrInEPBSLayer(elementToCheck)));
    }

    public static enum LAYERSNAME {
        OA,
        CTX,
        LA,
        PA,
        EPBS,
        INVALID;

    }
}

