/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.CapabilityRealizationExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.refinement.processor.UpdateRealizationContributionProcessor;
import org.polarsys.capella.core.transfo.misc.TransfoHelper;

public class StaticRealizationContributionProcessor
extends UpdateRealizationContributionProcessor {
    public StaticRealizationContributionProcessor() {
        super(UpdateRealizationContributionProcessor.Kind.STATIC);
    }

    public StaticRealizationContributionProcessor(NamedElement context) {
        super(UpdateRealizationContributionProcessor.Kind.STATIC, context);
    }

    public Object getName() {
        return "realization contribution update based on static informations";
    }

    @Override
    protected void updateInvolvements(AbstractCapability currentCapability, EClass target) {
        List<Component> involvedCpnts = this.retrieveInvolvedComponents(currentCapability);
        ArrayList<Object> tgtInvolvedCpnts = new ArrayList<Object>();
        for (Component cpnt : involvedCpnts) {
            if (cpnt instanceof Actor) {
                LogicalActor logicalActor = (LogicalActor)TransfoHelper.getReconciliation((TraceableElement)cpnt, (EClass)LaPackage.Literals.LOGICAL_ACTOR, (EClass)LaPackage.Literals.SYSTEM_ACTOR_REALIZATION);
                if (tgtInvolvedCpnts.contains(logicalActor)) continue;
                tgtInvolvedCpnts.add(logicalActor);
                continue;
            }
            if (cpnt instanceof LogicalActor) {
                PhysicalActor physicalActor = (PhysicalActor)TransfoHelper.getReconciliation((TraceableElement)cpnt, (EClass)PaPackage.Literals.PHYSICAL_ACTOR, (EClass)PaPackage.Literals.LOGICAL_ACTOR_REALIZATION);
                if (tgtInvolvedCpnts.contains(physicalActor)) continue;
                tgtInvolvedCpnts.add(physicalActor);
                continue;
            }
            if (cpnt instanceof PhysicalActor) {
                if (tgtInvolvedCpnts.contains(cpnt)) continue;
                tgtInvolvedCpnts.add(cpnt);
                continue;
            }
            if (cpnt instanceof LogicalComponent) {
                List pc = LogicalComponentExt.getImplementors((LogicalComponent)((LogicalComponent)cpnt));
                for (PhysicalComponent physicalComponent : pc) {
                    if (tgtInvolvedCpnts.contains(physicalComponent)) continue;
                    tgtInvolvedCpnts.add(physicalComponent);
                }
                continue;
            }
            if (!(cpnt instanceof PhysicalComponent)) continue;
            List epbsList = PhysicalComponentExt.getImplementors((PhysicalComponent)((PhysicalComponent)cpnt));
            Iterator iterator = epbsList.iterator();
            while (iterator.hasNext()) {
                ConfigurationItem configurationItem = (ConfigurationItem)iterator.next();
                if (tgtInvolvedCpnts.contains(configurationItem)) continue;
                tgtInvolvedCpnts.add(configurationItem);
            }
        }
        CapabilityRealization updatedUseCase = null;
        for (CapellaElement elt : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)currentCapability, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION)) {
            if (!EcoreUtil2.isContainedBy((EObject)elt, (EClass)target)) continue;
            updatedUseCase = (CapabilityRealization)elt;
        }
        if (updatedUseCase != null) {
            ArrayList<Component> tgtAlreadyInvoldedCpnts = new ArrayList<Component>();
            for (Component cpnt : CapabilityRealizationExt.getInvolvedComponents(updatedUseCase)) {
                tgtAlreadyInvoldedCpnts.add(cpnt);
            }
            List setCpntToAdd = ListExt.substract(tgtInvolvedCpnts, tgtAlreadyInvoldedCpnts);
            List setCpntToRemove = ListExt.substract(tgtAlreadyInvoldedCpnts, tgtInvolvedCpnts);
            for (CapellaElement cpnt : setCpntToAdd) {
                if (CapabilityRealizationExt.getInvolvedComponents((CapabilityRealization)updatedUseCase).contains(cpnt)) continue;
                CapabilityRealizationExt.addInvolvedComponent((CapabilityRealization)updatedUseCase, (Component)((Component)cpnt));
            }
            for (CapellaElement cpnt : setCpntToRemove) {
                if (!CapabilityRealizationExt.getInvolvedComponents((CapabilityRealization)updatedUseCase).contains(cpnt)) continue;
                CapabilityRealizationExt.removeInvolvedComponent((CapabilityRealization)updatedUseCase, (Component)((Component)cpnt));
            }
        }
    }

    private List<Component> retrieveInvolvedComponents(AbstractCapability currentUseCase) {
        ArrayList<Component> interactingComponents = new ArrayList<Component>();
        for (Component cpnt : AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)currentUseCase)) {
            if (interactingComponents.contains(cpnt)) continue;
            interactingComponents.add(cpnt);
        }
        return interactingComponents;
    }
}

