/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.ui;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.kitalpha.resourcereuse.emfscheme.dialog.LoadingResourceReuseDialog;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.context.ModelReuseContext;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.services.ResourceSetLoaderServices;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.services.SiriusLoaderServices;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class LoadResourceReuseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ModelReuseContext context = ModelReuseContext.INSTANCE;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            EList contents;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof GraphicalEditPart) {
                firstElement = ((GraphicalEditPart)firstElement).resolveSemanticElement();
            }
            if (firstElement instanceof Resource && !(contents = ((Resource)firstElement).getContents()).isEmpty()) {
                firstElement = contents.get(0);
            }
            if (firstElement instanceof EObject) {
                LoadingResourceReuseDialog dialog = new LoadingResourceReuseDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                EObject eObject = (EObject)firstElement;
                dialog.setSelection(eObject);
                dialog.open();
                Session session = context.getSession();
                List criterias = context.getCriterias();
                for (SearchCriteria settedCriteria : criterias) {
                    List modelToLoad = ModelReuseHelper.findModelsURIAccordingToCriteria((SearchCriteria)settedCriteria);
                    if (session != null) {
                        if (modelToLoad.size() != 1) continue;
                        SiriusLoaderServices.loadModelsForSiriusSession((Session)session, (List)modelToLoad);
                        continue;
                    }
                    if (modelToLoad.size() != 1) continue;
                    ResourceSetLoaderServices.loadResourceForCurrentRessourceSet((EObject)eObject, (List)modelToLoad);
                }
            }
        }
        return null;
    }
}

