/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.core.model.links.helpers.LinkInfo;
import org.polarsys.capella.core.ui.fastlinker.view.FilteringGridData;
import org.polarsys.capella.core.ui.fastlinker.view.FilteringGridLayout;
import org.polarsys.capella.core.ui.fastlinker.view.IDoubleClickListener;
import org.polarsys.capella.core.ui.fastlinker.view.providers.FastLinkerLabelProvider;

public class FastLinkerFigureCanvas
extends FigureCanvas
implements ISelectionProvider {
    protected static final TreeSearch LABEL_FILTER = new TreeSearch(){

        public boolean accept(IFigure figure_p) {
            return figure_p instanceof Label;
        }

        public boolean prune(IFigure figure_p) {
            return false;
        }
    };
    protected final List<IDoubleClickListener> _doubleClickListeners;
    protected final Figure _fastLinkerFigure;
    protected final Map<IFigure, Collection> _figureToModelElement = new HashMap<IFigure, Collection>();
    protected final FastLinkerLabelProvider _capellaElementLabelProvider;
    protected IFigure _selectedFigure;
    protected final List<ISelectionChangedListener> _selectionListeners = new ArrayList<ISelectionChangedListener>();
    protected final SelectionDragManager _sharedDragManager;

    public FastLinkerFigureCanvas(Composite parent_p, int style) {
        super(parent_p, style);
        this._doubleClickListeners = new ArrayList<IDoubleClickListener>();
        this._capellaElementLabelProvider = new FastLinkerLabelProvider();
        this._fastLinkerFigure = new Figure();
        this.setContents((IFigure)this._fastLinkerFigure);
        this._sharedDragManager = new SelectionDragManager();
        this._fastLinkerFigure.addMouseListener((MouseListener)this._sharedDragManager);
        this._fastLinkerFigure.addMouseMotionListener((MouseMotionListener)this._sharedDragManager);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setScrollBarVisibility(FigureCanvas.AUTOMATIC);
    }

    public void addDoubleClickListener(IDoubleClickListener listener_p) {
        this._doubleClickListeners.add(listener_p);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
        this._selectionListeners.add(listener_p);
    }

    protected IFigure createConnection(IFigure sourceFigure_p, IFigure targetFigure_p, LinkInfo.LinkStyle linkGraphicalRepresentation_p) {
        PolylineConnection connection = new PolylineConnection();
        connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(sourceFigure_p));
        connection.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(targetFigure_p));
        connection.setAntialias(1);
        if (LinkInfo.LinkStyle.LINE_DASHED == linkGraphicalRepresentation_p) {
            connection.setLineStyle(6);
            connection.setLineDash(new float[]{4.0f, 4.0f});
        } else {
            connection.setLineStyle(1);
        }
        if (LinkInfo.LinkStyle.LINE_SOLID_WITH_EMPTY_ARROW == linkGraphicalRepresentation_p) {
            PolygonDecoration pd = new PolygonDecoration();
            pd.setBackgroundColor(Display.getCurrent().getSystemColor(1));
            connection.setTargetDecoration((RotatableDecoration)pd);
        } else if (LinkInfo.LinkStyle.LINE_SOLID_WITH_FILLED_ARROW == linkGraphicalRepresentation_p) {
            PolygonDecoration pd = new PolygonDecoration();
            connection.setTargetDecoration((RotatableDecoration)pd);
        }
        return connection;
    }

    protected Label createModelElementFigure(Collection modelElement_p, boolean displayInBold_p) {
        Label modelElementFigure = new Label(this._capellaElementLabelProvider.getText(modelElement_p), this._capellaElementLabelProvider.getImage(modelElement_p));
        if (displayInBold_p) {
            Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            modelElementFigure.setFont(boldFont);
        }
        this._figureToModelElement.put((IFigure)modelElementFigure, modelElement_p);
        return modelElementFigure;
    }

    public void fillFigure(Collection firstElement_p, Collection secondElement_p, Collection pinnedElement_p, LinkInfo linkRepresentation_p) {
        this._figureToModelElement.clear();
        this._fastLinkerFigure.removeAll();
        this._selectedFigure = null;
        this.fireSelectionChanged();
        this._fastLinkerFigure.setLayoutManager((LayoutManager)new FilteringGridLayout(1, false));
        Label secondElementFigure = null;
        if (secondElement_p != null) {
            secondElementFigure = this.createModelElementFigure(secondElement_p, secondElement_p == pinnedElement_p);
            this._fastLinkerFigure.add((IFigure)secondElementFigure, (Object)new FilteringGridData(0x1000000, 0x1000000, true, true));
        }
        Label firstElementFigure = null;
        if (firstElement_p != null) {
            firstElementFigure = this.createModelElementFigure(firstElement_p, firstElement_p == pinnedElement_p);
            this._fastLinkerFigure.add((IFigure)firstElementFigure, (Object)new FilteringGridData(0x1000000, 0x1000000, true, true));
        }
        if (linkRepresentation_p != null) {
            IFigure connection = null;
            if (firstElement_p != null && firstElement_p.contains(linkRepresentation_p._sourceElement) && secondElement_p != null && secondElement_p.contains(linkRepresentation_p._targetElement)) {
                connection = this.createConnection((IFigure)firstElementFigure, (IFigure)secondElementFigure, linkRepresentation_p._linkStyle);
            } else if (secondElement_p != null && secondElement_p.contains(linkRepresentation_p._sourceElement) && firstElement_p != null && firstElement_p.contains(linkRepresentation_p._targetElement)) {
                connection = this.createConnection((IFigure)secondElementFigure, (IFigure)firstElementFigure, linkRepresentation_p._linkStyle);
            }
            if (connection != null) {
                this._fastLinkerFigure.add(connection);
            }
        }
    }

    protected void fireDoubleClick() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (IDoubleClickListener listener : this._doubleClickListeners) {
            listener.doubleClick(event);
        }
    }

    protected void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this._selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public ISelection getSelection() {
        if (this._selectedFigure == null || this._figureToModelElement.get(this._selectedFigure) == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this._figureToModelElement.get(this._selectedFigure));
    }

    public void removeDoubleClickListener(IDoubleClickListener listener_p) {
        this._doubleClickListeners.remove(listener_p);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener_p) {
        this._selectionListeners.remove(listener_p);
    }

    public void setSelection(ISelection selection_p) {
    }

    protected void switchToXYLayout(IFigure figure_p) {
        figure_p.setLayoutManager((LayoutManager)new XYLayout());
        List children = figure_p.getChildren();
        for (Object child : children) {
            IFigure childFigure = (IFigure)child;
            figure_p.setConstraint(childFigure, (Object)childFigure.getBounds());
        }
    }

    protected class SelectionDragManager
    extends MouseMotionListener.Stub
    implements MouseListener {
        private IFigure _draggedFigure;
        private Point _lastFigureLocation;

        protected SelectionDragManager() {
        }

        public void mouseDoubleClicked(MouseEvent me_p) {
            FastLinkerFigureCanvas.this.fireDoubleClick();
        }

        public void mouseDragged(MouseEvent e) {
            if (this._draggedFigure == null) {
                return;
            }
            Point newFigureLocation = e.getLocation();
            Dimension delta = newFigureLocation.getDifference(this._lastFigureLocation);
            this._lastFigureLocation = newFigureLocation;
            if (FastLinkerFigureCanvas.this._fastLinkerFigure.getLayoutManager() instanceof FilteringGridLayout) {
                FastLinkerFigureCanvas.this.switchToXYLayout((IFigure)FastLinkerFigureCanvas.this._fastLinkerFigure);
            }
            Rectangle newBounds = this._draggedFigure.getBounds().getTranslated(delta.width, delta.height);
            if (newBounds.x > 0 && newBounds.y > 0) {
                this._draggedFigure.getParent().setConstraint(this._draggedFigure, (Object)newBounds);
            }
        }

        public void mousePressed(MouseEvent e) {
            this._lastFigureLocation = e.getLocation();
            e.consume();
            IFigure newSelectedFigure = FastLinkerFigureCanvas.this._fastLinkerFigure.findFigureAt(e.x, e.y, LABEL_FILTER);
            if (FastLinkerFigureCanvas.this._selectedFigure != newSelectedFigure) {
                if (FastLinkerFigureCanvas.this._selectedFigure != null) {
                    FastLinkerFigureCanvas.this._selectedFigure.setBorder(null);
                }
                if (newSelectedFigure != null) {
                    newSelectedFigure.setBorder((Border)new LineBorder());
                    if (FastLinkerFigureCanvas.this._fastLinkerFigure.getLayoutManager().getConstraint(newSelectedFigure) instanceof Rectangle) {
                        ((Rectangle)FastLinkerFigureCanvas.this._fastLinkerFigure.getLayoutManager().getConstraint(newSelectedFigure)).setSize(newSelectedFigure.getPreferredSize());
                    }
                }
                FastLinkerFigureCanvas.this._selectedFigure = newSelectedFigure;
                FastLinkerFigureCanvas.this.fireSelectionChanged();
            }
            if (newSelectedFigure != null) {
                this._draggedFigure = newSelectedFigure;
            }
        }

        public void mouseReleased(MouseEvent e) {
            this._draggedFigure = null;
        }
    }
}

