/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker.view;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerState;
import org.polarsys.capella.core.ui.fastlinker.view.FastLinkerFigureCanvas;
import org.polarsys.capella.core.ui.fastlinker.view.IDoubleClickListener;
import org.polarsys.capella.core.ui.fastlinker.view.Messages;
import org.polarsys.capella.core.ui.fastlinker.view.providers.FastLinkerLabelProvider;
import org.polarsys.capella.core.ui.properties.CapellaTabbedPropertySheetPage;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class FastLinkerView
extends ViewPart
implements ITabbedPropertySheetPageContributor,
IEditingDomainProvider {
    public static final String ID = "org.polarsys.capella.core.ui.fastlinker.view";
    public static final String VIEW_ID = "org.polarsys.capella.core.ui.fastlinker.view";
    protected Action _clearFastLinkerAction;
    protected FastLinkerFigureCanvas _fastLinkerFigureCanvas;
    protected FastLinkerLabelProvider _capellaNavigatorLabelProvider;
    protected Action _pinElementAction;
    protected CapellaTabbedPropertySheetPage _propertySheetPage;

    public AbstractCreateLinksCommand chooseCommandToExecute(List<AbstractCreateLinksCommand> firstToSecondCommands_p, List<AbstractCreateLinksCommand> secondToFirstCommands_p) {
        final AbstractCreateLinksCommand[] selectedCommand = new AbstractCreateLinksCommand[1];
        SelectionAdapter menuItemSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (!(e_p.getSource() instanceof MenuItem)) {
                    return;
                }
                Object data = ((MenuItem)e_p.getSource()).getData();
                if (data instanceof AbstractCreateLinksCommand) {
                    selectedCommand[0] = (AbstractCreateLinksCommand)data;
                }
            }
        };
        String firstElementName = this._capellaNavigatorLabelProvider.getText(FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState().getFirstElement());
        String secondElementName = this._capellaNavigatorLabelProvider.getText(FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState().getSecondElement());
        Menu myMenu = new Menu((Control)this._fastLinkerFigureCanvas);
        if (!firstToSecondCommands_p.isEmpty() && !secondToFirstCommands_p.isEmpty()) {
            Menu firstToSecondSubMenu = new Menu(myMenu);
            MenuItem firstToSecondSubMenuItem = new MenuItem(myMenu, 64);
            firstToSecondSubMenuItem.setText(String.valueOf(firstElementName) + " -> " + secondElementName);
            firstToSecondSubMenuItem.setMenu(firstToSecondSubMenu);
            this.fillMenuWithCommands(firstToSecondSubMenu, firstToSecondCommands_p, (SelectionListener)menuItemSelectionAdapter);
            Menu secondToFirstSubMenu = new Menu(myMenu);
            MenuItem secondToFirstSubMenuItem = new MenuItem(myMenu, 64);
            secondToFirstSubMenuItem.setText(String.valueOf(secondElementName) + " -> " + firstElementName);
            secondToFirstSubMenuItem.setMenu(secondToFirstSubMenu);
            this.fillMenuWithCommands(secondToFirstSubMenu, secondToFirstCommands_p, (SelectionListener)menuItemSelectionAdapter);
        } else if (!firstToSecondCommands_p.isEmpty()) {
            this.fillMenuWithCommands(myMenu, firstToSecondCommands_p, (SelectionListener)menuItemSelectionAdapter);
        } else if (!secondToFirstCommands_p.isEmpty()) {
            this.fillMenuWithCommands(myMenu, secondToFirstCommands_p, (SelectionListener)menuItemSelectionAdapter);
        }
        new MenuItem(myMenu, 2);
        MenuItem mi1 = new MenuItem(myMenu, 0);
        mi1.setText(Messages.FastLinkerView_MenuItem_Cancel_Text);
        Point fastLinkerSize = this._fastLinkerFigureCanvas.getSize();
        myMenu.setLocation(this._fastLinkerFigureCanvas.toDisplay(fastLinkerSize.x / 2, fastLinkerSize.y / 2));
        myMenu.setVisible(true);
        while (!myMenu.isDisposed() && myMenu.isVisible()) {
            if (myMenu.getDisplay().readAndDispatch()) continue;
            myMenu.getDisplay().sleep();
        }
        return selectedCommand[0];
    }

    protected void createActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this._clearFastLinkerAction = this.createClearAction();
        toolBarManager.add((IAction)this._clearFastLinkerAction);
        this._pinElementAction = this.createPinElementAction();
        toolBarManager.add((IAction)this._pinElementAction);
    }

    protected Action createClearAction() {
        Action action = new Action(Messages.FastLinkerView_Action_ClearView_Text){

            public void run() {
                FastLinkerActivator.getDefault().getFastLinkerManager().clearFastLinker();
            }
        };
        action.setToolTipText(Messages.FastLinkerView_Action_ClearView_Text);
        action.setImageDescriptor(FastLinkerActivator.getDefault().getImageRegistry().getDescriptor("IMG_CLEAR"));
        return action;
    }

    public void createPartControl(Composite parent_p) {
        parent_p.setLayout((Layout)new FillLayout());
        this._capellaNavigatorLabelProvider = new FastLinkerLabelProvider();
        this._fastLinkerFigureCanvas = new FastLinkerFigureCanvas(parent_p, 0);
        this._fastLinkerFigureCanvas.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                FastLinkerView.this.refreshPropertyPage(event_p.getSelectionProvider());
                FastLinkerView.this.updateStatusBar(FastLinkerView.this.getFirstModelElementFromSelection(event_p.getSelection()));
            }
        });
        this._fastLinkerFigureCanvas.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(SelectionChangedEvent event_p) {
                Collection doubleClickedModelElement = FastLinkerView.this.getFirstModelElementFromSelection(event_p.getSelection());
                if (doubleClickedModelElement != null && !doubleClickedModelElement.isEmpty()) {
                    CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)doubleClickedModelElement.iterator().next());
                }
            }
        });
        this.createActions();
        this.initializeContextMenu();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this._fastLinkerFigureCanvas);
        int operations = 2;
        DropTarget target = new DropTarget((Control)this._fastLinkerFigureCanvas, operations);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                Collection draggedElement = FastLinkerView.this.getFirstModelElementFromSelection(LocalSelectionTransfer.getTransfer().getSelection());
                if (!FastLinkerActivator.getDefault().getFastLinkerManager().acceptElementInFastLinker(draggedElement)) {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                Collection draggedElement = FastLinkerView.this.getFirstModelElementFromSelection(LocalSelectionTransfer.getTransfer().getSelection());
                FastLinkerActivator.getDefault().getFastLinkerManager().putElementInFastLinker(draggedElement);
            }
        });
        this.update();
    }

    protected Action createPinElementAction() {
        Action action = new Action(Messages.FastLinkerView_Action_PinUnpinSelectedElement_Text, 4){

            public void run() {
                Collection selectedModelElement = FastLinkerView.this.getFirstModelElementFromSelection(FastLinkerView.this._fastLinkerFigureCanvas.getSelection());
                FastLinkerActivator.getDefault().getFastLinkerManager().pinModelElement(selectedModelElement);
            }
        };
        action.setMenuCreator((IMenuCreator)new PinDropDownMenuCreator());
        action.setToolTipText(Messages.FastLinkerView_Action_PinUnpinSelectedElement_Text);
        action.setImageDescriptor(FastLinkerActivator.getDefault().getImageRegistry().getDescriptor("IMG_PIN"));
        return action;
    }

    protected void fillMenuWithCommands(Menu menu_p, List<AbstractCreateLinksCommand> commands_p, SelectionListener menuItemSelectionListener_p) {
        for (Command command : commands_p) {
            MenuItem mi = new MenuItem(menu_p, 0);
            mi.setText(command.getLabel());
            mi.setData((Object)command);
            mi.addSelectionListener(menuItemSelectionListener_p);
        }
    }

    public Object getAdapter(Class adapter_p) {
        if (IPropertySheetPage.class.equals((Object)adapter_p)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter_p);
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    public EditingDomain getEditingDomain() {
        Object elt;
        ISelection selection = this._fastLinkerFigureCanvas.getSelection();
        if (selection instanceof IStructuredSelection && (elt = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return TransactionHelper.getEditingDomain((EObject)((EObject)elt));
        }
        return null;
    }

    protected Collection getFirstModelElementFromSelection(ISelection selection_p) {
        if (!(selection_p instanceof IStructuredSelection)) {
            return null;
        }
        List firstElements = ((IStructuredSelection)selection_p).toList();
        for (Object firstElement : firstElements) {
            if (firstElement instanceof ModelElement) continue;
            return null;
        }
        return firstElements;
    }

    protected TabbedPropertySheetPage getPropertySheetPage() {
        if (this._propertySheetPage == null) {
            this._propertySheetPage = new CapellaTabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    FastLinkerView.this._propertySheetPage = null;
                }

                public void init(IPageSite pageSite_p) {
                    super.init(pageSite_p);
                    pageSite_p.setSelectionProvider(FastLinkerView.this.getViewSite().getSelectionProvider());
                }
            };
        }
        return this._propertySheetPage;
    }

    private void initializeContextMenu() {
        MenuManager menuManager = new MenuManager("FastLinkerPopupMenu", "org.polarsys.capella.core.ui.fastlinker.view");
        menuManager.setRemoveAllWhenShown(true);
        Menu currentMenu = menuManager.createContextMenu((Control)this._fastLinkerFigureCanvas);
        this._fastLinkerFigureCanvas.setMenu(currentMenu);
        this.getSite().registerContextMenu("org.polarsys.capella.core.ui.fastlinker.view", menuManager, (ISelectionProvider)this._fastLinkerFigureCanvas);
    }

    protected void refreshPropertyPage(ISelectionProvider selectionProvider_p) {
        IStructuredSelection selection = (IStructuredSelection)selectionProvider_p.getSelection();
        if (this._propertySheetPage != null && !this._propertySheetPage.getControl().isDisposed()) {
            ISelectionProvider pageSelectionProvider = this._propertySheetPage.getSite().getSelectionProvider();
            if (pageSelectionProvider == null || pageSelectionProvider != selectionProvider_p) {
                this._propertySheetPage.getSite().setSelectionProvider(selectionProvider_p);
            }
            this._propertySheetPage.selectionChanged((IWorkbenchPart)this, (ISelection)selection);
        }
    }

    public void setFocus() {
        this._fastLinkerFigureCanvas.setFocus();
    }

    public void update() {
        FastLinkerState currentState = FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState();
        this._fastLinkerFigureCanvas.fillFigure(currentState.getFirstElement(), currentState.getSecondElement(), currentState.getPinnedElement(), currentState.getLinkCreated());
        this._pinElementAction.setEnabled(currentState.getFirstElement() != null || currentState.getSecondElement() != null);
        this._clearFastLinkerAction.setEnabled(currentState.getFirstElement() != null || currentState.getSecondElement() != null);
    }

    public void updateStatusBar(Object elementToDisplay_p) {
        Image elementImage = this._capellaNavigatorLabelProvider.getImage(elementToDisplay_p);
        String elementDescription = this._capellaNavigatorLabelProvider.getDescription(elementToDisplay_p);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(elementImage, elementDescription);
    }

    protected class PinDropDownMenuCreator
    implements IMenuCreator {
        private Menu _menu;

        protected PinDropDownMenuCreator() {
        }

        protected MenuItem createPinMenuItem(Menu parentMenu_p, final Collection modelElement_p, Collection<EObject> pinnedElement_p) {
            MenuItem menuItem = new MenuItem(parentMenu_p, 32);
            menuItem.setImage(FastLinkerView.this._capellaNavigatorLabelProvider.getImage(modelElement_p));
            menuItem.setText(FastLinkerView.this._capellaNavigatorLabelProvider.getText(modelElement_p));
            menuItem.setSelection(modelElement_p == pinnedElement_p);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_p) {
                    FastLinkerActivator.getDefault().getFastLinkerManager().pinModelElement(modelElement_p);
                }
            });
            return menuItem;
        }

        public void dispose() {
            if (this._menu != null) {
                this._menu.dispose();
            }
        }

        public Menu getMenu(Control parent_p) {
            if (this._menu != null) {
                this._menu.dispose();
            }
            this._menu = new Menu(parent_p);
            FastLinkerState state = FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState();
            if (state.getSecondElement() != null) {
                this.createPinMenuItem(this._menu, state.getSecondElement(), state.getPinnedElement());
            }
            if (state.getFirstElement() != null) {
                this.createPinMenuItem(this._menu, state.getFirstElement(), state.getPinnedElement());
            }
            return this._menu;
        }

        public Menu getMenu(Menu parent_p) {
            return null;
        }
    }
}

