/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.statements;

import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.template.Template;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateNodeElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateForStatement
extends TemplateNodeElement {
    protected TemplateExpression condition;
    protected Template block;

    public TemplateForStatement(TemplateExpression condition, Template block, IScript script) {
        super(script);
        this.condition = condition;
        this.condition.setParent(this);
        this.block = block;
        this.block.setParent(this);
    }

    public TemplateExpression getCondition() {
        return this.condition;
    }

    public Template getBlock() {
        return this.block;
    }

    @Override
    public ENode evaluate(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        try {
            ENode result = this.evaluateSub(object, mode);
            return result;
        }
        catch (ENodeException e) {
            ENode result = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
            result.log().addError(new EvalFailure(e.getMessage()));
            return result;
        }
    }

    private ENode evaluateSub(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        ENode node = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
        ENode all = this.condition.evaluate(new ENode(object, this.condition, mode.isSynchronize()), this.script, mode);
        if (mode.getMode() == 2) {
            node.log().getAll(all.log(), false);
        }
        if (!all.isNull()) {
            ENodeList list;
            ENodeIterator it;
            boolean containsEObject;
            if (all.isList()) {
                try {
                    containsEObject = false;
                    it = all.getList().iterator();
                    while (it.hasNext() && !containsEObject) {
                        ENode child = it.next();
                        if (!child.isEObject()) continue;
                        containsEObject = true;
                    }
                    it = all.getList().iterator();
                }
                catch (ENodeCastException eNodeCastException) {
                    containsEObject = false;
                    it = new ENodeList().iterator();
                }
            } else if (all.isInt()) {
                try {
                    containsEObject = true;
                    list = new ENodeList();
                    int count = all.getInt();
                    int i = 0;
                    while (i < count) {
                        list.add(new ENode(object, this.condition, mode.isSynchronize()));
                        ++i;
                    }
                    it = list.iterator();
                }
                catch (ENodeCastException eNodeCastException) {
                    containsEObject = false;
                    it = new ENodeList().iterator();
                }
            } else {
                containsEObject = all.isEObject();
                list = new ENodeList();
                list.add(all);
                it = list.iterator();
            }
            if (it.hasNext()) {
                int iObject = 0;
                while (it.hasNext()) {
                    ENode child = it.next();
                    if (!containsEObject) {
                        String value;
                        if (child.isString()) {
                            try {
                                EEnumLiteral literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                value = child.getString();
                                literal.setName(value);
                                literal.setLiteral(value);
                                child = new ENode((EObject)literal, child);
                            }
                            catch (ENodeCastException eNodeCastException) {}
                        } else if (child.isInt()) {
                            try {
                                EEnumLiteral literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                value = String.valueOf(child.getInt());
                                literal.setName(value);
                                literal.setLiteral(value);
                                child = new ENode((EObject)literal, child);
                            }
                            catch (ENodeCastException eNodeCastException) {}
                        } else if (child.isDouble()) {
                            try {
                                EEnumLiteral literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                value = String.valueOf(child.getDouble());
                                literal.setName(value);
                                literal.setLiteral(value);
                                child = new ENode((EObject)literal, child);
                            }
                            catch (ENodeCastException eNodeCastException) {}
                        } else if (child.isBoolean()) {
                            try {
                                EEnumLiteral literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                value = String.valueOf(child.getBoolean());
                                literal.setName(value);
                                literal.setLiteral(value);
                                child = new ENode((EObject)literal, child);
                            }
                            catch (ENodeCastException eNodeCastException) {}
                        }
                    }
                    this.script.contextPush(IScript.CURRENT_NODE, child);
                    this.script.contextPush(IScript.WHILE_INDEX, new Integer(iObject));
                    try {
                        if (child.isEObject()) {
                            try {
                                ENode n = this.block.evaluate(child.getEObject(), mode);
                                node.append(n);
                            }
                            catch (ENodeCastException eNodeCastException) {}
                            ++iObject;
                            continue;
                        }
                        if (!containsEObject) continue;
                        node.append(child);
                    }
                    finally {
                        this.script.contextPop(IScript.CURRENT_NODE);
                        this.script.contextPop(IScript.WHILE_INDEX);
                    }
                }
            }
        }
        return node;
    }

    @Override
    public String toString() {
        return String.valueOf(TemplateConstants.FOR_BEGIN) + this.condition.toString() + TemplateConstants.FOR_THEN + this.block.toString() + TemplateConstants.FOR_END;
    }

    @Override
    public String getOutlineText() {
        return "for " + this.condition.toString();
    }

    public static TemplateNodeElement fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Template block;
        TemplateExpression condition;
        Int2 iThen = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.FOR_THEN, limits.b(), limits.e(), TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
        if (iThen.b() > -1) {
            condition = TemplateExpression.fromString(buffer, new Int2(limits.b(), iThen.b()), script);
            Int2 blockPos = new Int2(iThen.e(), limits.e());
            blockPos = Template.formatTemplate(buffer, blockPos, 0);
            block = Template.read(buffer, blockPos, script);
        } else {
            condition = TemplateExpression.fromString(buffer, new Int2(limits.b(), limits.e()), script);
            block = new Template(script);
        }
        TemplateForStatement element = new TemplateForStatement(condition, block, script);
        element.setPos(limits);
        return element;
    }
}

