/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.console;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.MessageConsoleStream;
import org.polarsys.capella.common.tools.report.appenders.console.ConsoleAppenderActivator;
import org.polarsys.capella.common.tools.report.appenders.console.IReportConsole;

public class ReportManagerConsoleAppender
extends AppenderSkeleton {
    public Map<Level, Writer> _logWriters;
    protected IReportConsole _console;
    private Thread _worker;
    private volatile boolean _running;
    private final List<LoggingEvent> _pending;

    public ReportManagerConsoleAppender(Layout layout) {
        this.setLayout(layout);
        this.setName("Console");
        this._console = ConsoleAppenderActivator.getDefault().getReportConsole();
        this._logWriters = new HashMap<Level, Writer>();
        if (this._console != null) {
            HashMap<Level, MessageConsoleStream> messageStreams = this._console.getOutputStreams();
            for (Level lev : messageStreams.keySet()) {
                this._logWriters.put(lev, new BufferedWriter(new OutputStreamWriter((OutputStream)messageStreams.get(lev))));
            }
        }
        this._running = true;
        this._pending = Collections.synchronizedList(new ArrayList());
        this._worker = new Thread(null, new ConsoleAppenderJob(), "ReportManagerConsoleAppender");
        this._worker.start();
    }

    public ReportManagerConsoleAppender() {
        this((Layout)new PatternLayout("%d{MM-dd HH:mm:ss} %-5.5p %m%n"));
    }

    protected void append(LoggingEvent event) {
        this._pending.add(event);
    }

    private void writeToConsole(LoggingEvent event) {
        try {
            String[] s;
            Writer writer = this._logWriters.get(event.getLevel());
            writer.write(" [From " + event.getLoggerName() + "] ");
            writer.write(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                int len = s.length;
                int i = 0;
                while (i < len) {
                    writer.write(s[i]);
                    writer.write(Layout.LINE_SEP);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            ConsoleAppenderActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.console", e.getMessage(), (Throwable)e));
        }
    }

    public void close() {
        this._running = false;
    }

    public boolean requiresLayout() {
        return true;
    }

    class ConsoleAppenderJob
    implements Runnable {
        ConsoleAppenderJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ReportManagerConsoleAppender.this._running) {
                if (!ReportManagerConsoleAppender.this._pending.isEmpty()) {
                    ArrayList pendingCopy = null;
                    List list = ReportManagerConsoleAppender.this._pending;
                    synchronized (list) {
                        pendingCopy = new ArrayList(ReportManagerConsoleAppender.this._pending);
                        ReportManagerConsoleAppender.this._pending.clear();
                    }
                    for (LoggingEvent e : pendingCopy) {
                        ReportManagerConsoleAppender.this.writeToConsole(e);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

