/*******************************************************************************
 * Copyright (c) 2006, 2017 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.projection.common.rules.core;

import java.util.List;

import org.eclipse.emf.ecore.EObject;

import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.projection.common.context.IContext;

public class Rule_Constraint extends Rule_CapellaElement {

  public Rule_Constraint() {
    super(CapellacorePackage.Literals.CONSTRAINT, CapellacorePackage.Literals.CONSTRAINT);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
    super.retrieveGoDeep(source_p, result_p, context_p);
    Constraint sourceElement = (Constraint) source_p;
    result_p.addAll(sourceElement.getOwnedPropertyValueGroups());
    result_p.addAll(sourceElement.getOwnedPropertyValues());
    result_p.add(sourceElement.getOwnedSpecification());
  }

}
