/*******************************************************************************
 * Copyright (c) 2006, 2015 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.ctx.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.capellacore.impl.RelationshipImpl;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Capability Exploitation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.polarsys.capella.core.data.ctx.impl.CapabilityExploitationImpl#getMission <em>Mission</em>}</li>
 *   <li>{@link org.polarsys.capella.core.data.ctx.impl.CapabilityExploitationImpl#getCapability <em>Capability</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CapabilityExploitationImpl extends RelationshipImpl implements CapabilityExploitation {





	/**
	 * The cached value of the '{@link #getCapability() <em>Capability</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCapability()
	 * @generated
	 * @ordered
	 */
	protected Capability capability;




	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CapabilityExploitationImpl() {

		super();

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CtxPackage.Literals.CAPABILITY_EXPLOITATION;
	}





	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public Mission getMission() {

		if (eContainerFeatureID() != CtxPackage.CAPABILITY_EXPLOITATION__MISSION) return null;
		return (Mission)eContainer();
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public Mission basicGetMission() {

		if (eContainerFeatureID() != CtxPackage.CAPABILITY_EXPLOITATION__MISSION) return null;
		return (Mission)eInternalContainer();
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public NotificationChain basicSetMission(Mission newMission, NotificationChain msgs) {

		msgs = eBasicSetContainer((InternalEObject)newMission, CtxPackage.CAPABILITY_EXPLOITATION__MISSION, msgs);

		return msgs;
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public void setMission(Mission newMission) {

		if (newMission != eInternalContainer() || (eContainerFeatureID() != CtxPackage.CAPABILITY_EXPLOITATION__MISSION && newMission != null)) {
			if (EcoreUtil.isAncestor(this, newMission))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString()); //$NON-NLS-1$
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newMission != null)
				msgs = ((InternalEObject)newMission).eInverseAdd(this, CtxPackage.MISSION__OWNED_CAPABILITY_EXPLOITATIONS, Mission.class, msgs);
			msgs = basicSetMission(newMission, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CtxPackage.CAPABILITY_EXPLOITATION__MISSION, newMission, newMission));

	}






	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public Capability getCapability() {

		if (capability != null && capability.eIsProxy()) {
			InternalEObject oldCapability = (InternalEObject)capability;
			capability = (Capability)eResolveProxy(oldCapability);
			if (capability != oldCapability) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY, oldCapability, capability));
			}
		}
		return capability;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public Capability basicGetCapability() {

		return capability;
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public NotificationChain basicSetCapability(Capability newCapability, NotificationChain msgs) {

		Capability oldCapability = capability;
		capability = newCapability;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY, oldCapability, newCapability);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}

		return msgs;
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public void setCapability(Capability newCapability) {

		if (newCapability != capability) {
			NotificationChain msgs = null;
			if (capability != null)
				msgs = ((InternalEObject)capability).eInverseRemove(this, CtxPackage.CAPABILITY__PURPOSES, Capability.class, msgs);
			if (newCapability != null)
				msgs = ((InternalEObject)newCapability).eInverseAdd(this, CtxPackage.CAPABILITY__PURPOSES, Capability.class, msgs);
			msgs = basicSetCapability(newCapability, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY, newCapability, newCapability));

	}




	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetMission((Mission)otherEnd, msgs);
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				if (capability != null)
					msgs = ((InternalEObject)capability).eInverseRemove(this, CtxPackage.CAPABILITY__PURPOSES, Capability.class, msgs);
				return basicSetCapability((Capability)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				return basicSetMission(null, msgs);
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				return basicSetCapability(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				return eInternalContainer().eInverseRemove(this, CtxPackage.MISSION__OWNED_CAPABILITY_EXPLOITATIONS, Mission.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				if (resolve) return getMission();
				return basicGetMission();
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				if (resolve) return getCapability();
				return basicGetCapability();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				// begin-extension-code
				if (newValue == null || newValue instanceof Mission) {
				// end-extension-code
					setMission((Mission)newValue);
				// begin-extension-code
				}
				// end-extension-code
				return;
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				// begin-extension-code
				if (newValue == null || newValue instanceof Capability) {
				// end-extension-code
					setCapability((Capability)newValue);
				// begin-extension-code
				}
				// end-extension-code
				return;
		}
		super.eSet(featureID, newValue);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				setMission((Mission)null);
				return;
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				setCapability((Capability)null);
				return;
		}
		super.eUnset(featureID);
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CtxPackage.CAPABILITY_EXPLOITATION__MISSION:
				return basicGetMission() != null;
			case CtxPackage.CAPABILITY_EXPLOITATION__CAPABILITY:
				return capability != null;
		}
		return super.eIsSet(featureID);
	}



} //CapabilityExploitationImpl