/*******************************************************************************
 * Copyright (c) 2006, 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.fa.validation.functionalExchange;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;

import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;

/**
 * Checks realization consistency between functional exchanges and component exchanges.
 */
public class MDCHK_FunctionalExchange_ConnectionFunctionalExchangeAllocation extends AbstractValidationRule {
  /**
   * @see org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.emf.validation.IValidationContext)
   */
  @Override
  public IStatus validate(IValidationContext ctx) {
    EObject eObj = ctx.getTarget();
    EMFEventType eType = ctx.getEventType();
    if (eType == EMFEventType.NULL && eObj instanceof FunctionalExchange) {
      FunctionalExchange exch = (FunctionalExchange) eObj;
      for (AbstractTrace trace : exch.getIncomingTraces()) {
        if (trace instanceof ComponentExchangeFunctionalExchangeAllocation
            && !(trace.getSourceElement() instanceof ComponentExchange)) {
          return ctx.createFailureStatus(EObjectLabelProviderHelper.getText(exch));
        }
      }
    }
    return ctx.createSuccessStatus();
  }
}
