/*******************************************************************************
 * Copyright (c) 2007-2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.diagram.sequence.description.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.sirius.diagram.sequence.description.util.DescriptionAdapterFactory;
import org.eclipse.sirius.diagram.sequence.internal.description.provider.SequenceDiagramDescriptionItemProviderSpec;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The
 * adapters also support Eclipse property sheets. Note that most of the adapters
 * are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class DescriptionItemProviderAdapterFactory extends DescriptionAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this
     * adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement
     * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by
     * {@link #isFactoryForType isFactoryForType}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     *
     * @generated
     */
    public DescriptionItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SequenceDiagramDescriptionItemProvider sequenceDiagramDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @not-generated
     */
    @Override
    public Adapter createSequenceDiagramDescriptionAdapter() {
        if (sequenceDiagramDescriptionItemProvider == null) {
            sequenceDiagramDescriptionItemProvider = new SequenceDiagramDescriptionItemProviderSpec(this);
        }

        return sequenceDiagramDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InstanceRoleMappingItemProvider instanceRoleMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInstanceRoleMappingAdapter() {
        if (instanceRoleMappingItemProvider == null) {
            instanceRoleMappingItemProvider = new InstanceRoleMappingItemProvider(this);
        }

        return instanceRoleMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.ExecutionMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExecutionMappingItemProvider executionMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.ExecutionMapping}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExecutionMappingAdapter() {
        if (executionMappingItemProvider == null) {
            executionMappingItemProvider = new ExecutionMappingItemProvider(this);
        }

        return executionMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.StateMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected StateMappingItemProvider stateMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.StateMapping}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStateMappingAdapter() {
        if (stateMappingItemProvider == null) {
            stateMappingItemProvider = new StateMappingItemProvider(this);
        }

        return stateMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EndOfLifeMappingItemProvider endOfLifeMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEndOfLifeMappingAdapter() {
        if (endOfLifeMappingItemProvider == null) {
            endOfLifeMappingItemProvider = new EndOfLifeMappingItemProvider(this);
        }

        return endOfLifeMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.BasicMessageMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BasicMessageMappingItemProvider basicMessageMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.BasicMessageMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBasicMessageMappingAdapter() {
        if (basicMessageMappingItemProvider == null) {
            basicMessageMappingItemProvider = new BasicMessageMappingItemProvider(this);
        }

        return basicMessageMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.ReturnMessageMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ReturnMessageMappingItemProvider returnMessageMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.ReturnMessageMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createReturnMessageMappingAdapter() {
        if (returnMessageMappingItemProvider == null) {
            returnMessageMappingItemProvider = new ReturnMessageMappingItemProvider(this);
        }

        return returnMessageMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.CreationMessageMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CreationMessageMappingItemProvider creationMessageMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.CreationMessageMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCreationMessageMappingAdapter() {
        if (creationMessageMappingItemProvider == null) {
            creationMessageMappingItemProvider = new CreationMessageMappingItemProvider(this);
        }

        return creationMessageMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.DestructionMessageMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DestructionMessageMappingItemProvider destructionMessageMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.DestructionMessageMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDestructionMessageMappingAdapter() {
        if (destructionMessageMappingItemProvider == null) {
            destructionMessageMappingItemProvider = new DestructionMessageMappingItemProvider(this);
        }

        return destructionMessageMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.MessageEndVariable}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MessageEndVariableItemProvider messageEndVariableItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.MessageEndVariable}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMessageEndVariableAdapter() {
        if (messageEndVariableItemProvider == null) {
            messageEndVariableItemProvider = new MessageEndVariableItemProvider(this);
        }

        return messageEndVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.CoveredLifelinesVariable}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CoveredLifelinesVariableItemProvider coveredLifelinesVariableItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.CoveredLifelinesVariable}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCoveredLifelinesVariableAdapter() {
        if (coveredLifelinesVariableItemProvider == null) {
            coveredLifelinesVariableItemProvider = new CoveredLifelinesVariableItemProvider(this);
        }

        return coveredLifelinesVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.InteractionUseMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InteractionUseMappingItemProvider interactionUseMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.InteractionUseMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInteractionUseMappingAdapter() {
        if (interactionUseMappingItemProvider == null) {
            interactionUseMappingItemProvider = new InteractionUseMappingItemProvider(this);
        }

        return interactionUseMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.CombinedFragmentMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CombinedFragmentMappingItemProvider combinedFragmentMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.CombinedFragmentMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCombinedFragmentMappingAdapter() {
        if (combinedFragmentMappingItemProvider == null) {
            combinedFragmentMappingItemProvider = new CombinedFragmentMappingItemProvider(this);
        }

        return combinedFragmentMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.OperandMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected OperandMappingItemProvider operandMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.OperandMapping}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOperandMappingAdapter() {
        if (operandMappingItemProvider == null) {
            operandMappingItemProvider = new OperandMappingItemProvider(this);
        }

        return operandMappingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.diagram.sequence.description.ObservationPointMapping}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ObservationPointMappingItemProvider observationPointMappingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.diagram.sequence.description.ObservationPointMapping}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createObservationPointMappingAdapter() {
        if (observationPointMappingItemProvider == null) {
            observationPointMappingItemProvider = new ObservationPointMappingItemProvider(this);
        }

        return observationPointMappingItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the
     * adapter. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to
     * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
     * -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (sequenceDiagramDescriptionItemProvider != null) {
            sequenceDiagramDescriptionItemProvider.dispose();
        }
        if (instanceRoleMappingItemProvider != null) {
            instanceRoleMappingItemProvider.dispose();
        }
        if (executionMappingItemProvider != null) {
            executionMappingItemProvider.dispose();
        }
        if (stateMappingItemProvider != null) {
            stateMappingItemProvider.dispose();
        }
        if (endOfLifeMappingItemProvider != null) {
            endOfLifeMappingItemProvider.dispose();
        }
        if (basicMessageMappingItemProvider != null) {
            basicMessageMappingItemProvider.dispose();
        }
        if (returnMessageMappingItemProvider != null) {
            returnMessageMappingItemProvider.dispose();
        }
        if (creationMessageMappingItemProvider != null) {
            creationMessageMappingItemProvider.dispose();
        }
        if (destructionMessageMappingItemProvider != null) {
            destructionMessageMappingItemProvider.dispose();
        }
        if (messageEndVariableItemProvider != null) {
            messageEndVariableItemProvider.dispose();
        }
        if (coveredLifelinesVariableItemProvider != null) {
            coveredLifelinesVariableItemProvider.dispose();
        }
        if (interactionUseMappingItemProvider != null) {
            interactionUseMappingItemProvider.dispose();
        }
        if (combinedFragmentMappingItemProvider != null) {
            combinedFragmentMappingItemProvider.dispose();
        }
        if (operandMappingItemProvider != null) {
            operandMappingItemProvider.dispose();
        }
        if (observationPointMappingItemProvider != null) {
            observationPointMappingItemProvider.dispose();
        }
    }

}
