/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.expressions.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationSignature {
    private final EClassifier _owner;
    private final String _name;
    private final EClassifier _type;
    private final boolean _isMany;
    private final List<Variable<EClassifier, EParameter>> _parameters;

    public OperationSignature(EClassifier owner_p, String name_p, EClassifier type_p, boolean isMany_p, List<Variable<EClassifier, EParameter>> parameters_p) {
        this._owner = owner_p;
        this._name = name_p;
        this._type = type_p;
        this._isMany = isMany_p;
        this._parameters = new ModelsUtil.ROrderedSet(parameters_p);
    }

    public OperationSignature(EClassifier owner_p, String name_p, EClassifier type_p, boolean isMany_p) {
        this(owner_p, name_p, type_p, isMany_p, Collections.emptyList());
    }

    public OperationSignature(EOperation operation_p) {
        this((EClassifier)operation_p.getEContainingClass(), operation_p.getName(), operation_p.getEType(), operation_p.isMany());
    }

    private Constraint createConstraint() {
        return EcoreFactory.eINSTANCE.createConstraint();
    }

    public void defineIn(EcoreEnvironment env_p) {
        EOperation op = env_p.defineOperation(this.getOwner(), this.getName(), this.getType(), this.getParameters(), this.createConstraint());
        if (this._isMany) {
            op.setUpperBound(-1);
        }
    }

    public boolean equals(Object obj_p) {
        boolean result = false;
        if (obj_p instanceof OperationSignature) {
            OperationSignature peer = (OperationSignature)obj_p;
            result = this.getName().equals(peer.getName());
        }
        return result;
    }

    public String getName() {
        return this._name;
    }

    public EClassifier getOwner() {
        return this._owner;
    }

    public List<Variable<EClassifier, EParameter>> getParameters() {
        return Collections.unmodifiableList(this._parameters);
    }

    public EClassifier getType() {
        return this._type;
    }

    public boolean isMany() {
        return this._isMany;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

