/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class WorkbenchHelper {
    public static void exportZipFile(IResource resource, IFile theZipFile) {
        try {
            FileOutputStream fos = new FileOutputStream(theZipFile.getLocation().toOSString());
            final ZipOutputStream zos = new ZipOutputStream(fos);
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    byte[] buffer = new byte[1024];
                    try {
                        if (resource instanceof IFile) {
                            int len;
                            ZipEntry ze = new ZipEntry(resource.getFullPath().toString().substring(1));
                            zos.putNextEntry(ze);
                            FileInputStream in = new FileInputStream(resource.getLocation().toOSString());
                            while ((len = in.read(buffer)) > 0) {
                                zos.write(buffer, 0, len);
                            }
                            in.close();
                            zos.closeEntry();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
            };
            try {
                resource.accept(visitor);
            }
            finally {
                zos.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

