/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.CapabilityRealizationExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;

public class ContextQuery {
    public static CapabilityRealization buildMergedCapability(CapabilityRealization capabilityRealization) {
        CapabilityRealization cr = LaFactory.eINSTANCE.createCapabilityRealization();
        List<Component> components = ContextQuery.findInvolvedComponentOfCapabilityRealizations(capabilityRealization);
        for (Component component : components) {
            ActorCapabilityRealizationInvolvement involvement;
            if (component instanceof Actor) {
                Actor actor = (Actor)component;
                involvement = CsFactory.eINSTANCE.createActorCapabilityRealizationInvolvement();
                involvement.setInvolved((InvolvedElement)actor);
                cr.getOwnedActorCapabilityRealizations().add((Object)involvement);
            }
            if (!(component instanceof LogicalComponent)) continue;
            LogicalComponent logicalComponent = (LogicalComponent)component;
            involvement = CsFactory.eINSTANCE.createSystemComponentCapabilityRealizationInvolvement();
            involvement.setInvolved((InvolvedElement)logicalComponent);
            cr.getOwnedSystemComponentCapabilityRealizations().add((Object)involvement);
        }
        return cr;
    }

    private static boolean containsSubComponent(Component component, List<Component> componentList) {
        for (Component cpnt : componentList) {
            if (!EcoreUtil2.isContainedBy((EObject)cpnt, (EObject)component)) continue;
            return true;
        }
        return false;
    }

    public static List<Actor> findActorTransfoSourceList(SystemComponent transfoSource) {
        ArrayList<Actor> actorTransfoSourceList = new ArrayList<Actor>();
        EList involvements1 = transfoSource.getParticipationsInCapabilityRealizations();
        for (SystemComponentCapabilityRealizationInvolvement involvement1 : involvements1) {
            CapabilityRealization usecase = (CapabilityRealization)involvement1.getInvolvedCapabilityRealizationInvolvedElement();
            EList involvements2 = usecase.getInvolvedActors();
            for (ActorCapabilityRealizationInvolvement involvement2 : involvements2) {
                Actor actor = (Actor)involvement2.getInvolver();
                actorTransfoSourceList.add(actor);
            }
        }
        return actorTransfoSourceList;
    }

    public static List<CapabilityRealization> findCapabilityRealizationsOfComponent(Component component) {
        EList involvements = ((SystemComponent)component).getParticipationsInCapabilityRealizations();
        ArrayList<CapabilityRealization> capabilityRealizations = new ArrayList<CapabilityRealization>();
        for (SystemComponentCapabilityRealizationInvolvement involvement : involvements) {
            capabilityRealizations.add((CapabilityRealization)involvement.getInvolved());
        }
        return capabilityRealizations;
    }

    public static List<Part> findComponentInstanceList(Component component) {
        ArrayList<Part> componentInstanceList = new ArrayList<Part>();
        Component pkg = component;
        if (pkg != null) {
            TreeIterator iterator = pkg.eAllContents();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof Part)) continue;
                Part componentInstance = (Part)object;
                componentInstanceList.add(componentInstance);
            }
        }
        return componentInstanceList;
    }

    public static List<Part> findComponentInstanceList(List<? extends Component> componentList) {
        ArrayList<Part> componentInstanceList = new ArrayList<Part>();
        for (Component component : componentList) {
            componentInstanceList.addAll(ContextQuery.findComponentInstanceList(component));
        }
        return componentInstanceList;
    }

    public static void findContext(Component transfoSource, List<Actor> exportedActorList, List<Component> exportedExternalComponentList, List<CapabilityRealization> exportedCapabilityRealizationList, List<ActorCapabilityRealizationInvolvement> exportedActorInvolvementList, List<SystemComponentCapabilityRealizationInvolvement> exportedComponentSystemInvolvementList, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        ArrayList<Component> internalComponents = new ArrayList<Component>();
        internalComponents.add(transfoSource);
        ContextQuery.findContext(transfoSource, exportedActorList, exportedExternalComponentList, internalComponents, exportedCapabilityRealizationList, exportedActorInvolvementList, exportedComponentSystemInvolvementList, exportedInterfaceUseList, exportedInterfaceImplList, exportedInterfaceList);
    }

    public static void findContext(Component transfoSource, List<Actor> exportedActorList, List<Component> exportedExternalComponentList, List<Component> exportedInternalComponentList, List<CapabilityRealization> exportedCapabilityRealizationList, List<ActorCapabilityRealizationInvolvement> exportedActorInvolvementList, List<SystemComponentCapabilityRealizationInvolvement> exportedComponentSystemInvolvementList, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        ArrayList<Component> internalComponentsList = new ArrayList<Component>();
        if (transfoSource instanceof LogicalComponent) {
            internalComponentsList.add(transfoSource);
        } else if (transfoSource instanceof ConfigurationItem) {
            internalComponentsList.addAll(ContextQuery.findLogicalComponentsOfCI((ConfigurationItem)transfoSource));
        }
        exportedInternalComponentList.addAll(internalComponentsList);
        List<CapabilityRealization> capabilityRealizationList = ContextQuery.findRootCapabilityRealizationsOfComponent(transfoSource);
        for (CapabilityRealization capabilityRealization : capabilityRealizationList) {
            List<Component> involvedComponents = ContextQuery.findInvolvedComponentOfCapabilityRealizations(capabilityRealization);
            ContextQuery.findExternalComponents(internalComponentsList, involvedComponents, capabilityRealization, exportedExternalComponentList, exportedActorList, exportedCapabilityRealizationList, exportedActorInvolvementList, exportedComponentSystemInvolvementList, exportedInterfaceUseList, exportedInterfaceImplList, exportedInterfaceList);
        }
    }

    public static void findDirectContext(SystemComponent transfoSource, List<Actor> exportedActorList, List<Component> exportedExternalComponentList, List<CapabilityRealization> exportedCapabilityRealizationList, List<ActorCapabilityRealizationInvolvement> exportedActorInvolvementList, List<SystemComponentCapabilityRealizationInvolvement> exportedComponentSystemInvolvementList, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        EList systemInvolvements = transfoSource.getParticipationsInCapabilityRealizations();
        for (SystemComponentCapabilityRealizationInvolvement systemInvolvement : systemInvolvements) {
            CapabilityRealization useCase = (CapabilityRealization)systemInvolvement.getInvolvedCapabilityRealizationInvolvedElement();
            EList actorInvolvements = useCase.getInvolvedActors();
            EList systemComponentInvolvements = useCase.getInvolvedSystemComponents();
            boolean possibleExchangeFounded = false;
            ArrayList<InterfaceUse> exportedInterfaceUses = new ArrayList<InterfaceUse>();
            ArrayList<InterfaceImplementation> exportedInterfaceImpls = new ArrayList<InterfaceImplementation>();
            ArrayList<Interface> exportedInterfaces = new ArrayList<Interface>();
            for (ActorCapabilityRealizationInvolvement actorInvolvement : actorInvolvements) {
                Actor actor = (Actor)actorInvolvement.getInvolver();
                if (ContextQuery.findPossibleExchangeByInterface((Component)transfoSource, (Component)actor, exportedInterfaceUses, exportedInterfaceImpls, exportedInterfaces)) {
                    exportedActorList.add(actor);
                    exportedActorInvolvementList.add(actorInvolvement);
                    exportedInterfaceUseList.addAll(exportedInterfaceUses);
                    exportedInterfaceImplList.addAll(exportedInterfaceImpls);
                    exportedInterfaceList.addAll(exportedInterfaces);
                    possibleExchangeFounded = true;
                }
                exportedInterfaceUses.clear();
                exportedInterfaceImpls.clear();
                exportedInterfaces.clear();
            }
            for (SystemComponentCapabilityRealizationInvolvement systemComponentInvolvement : systemComponentInvolvements) {
                SystemComponent systemComponent = (SystemComponent)systemComponentInvolvement.getInvolver();
                if (ContextQuery.findPossibleExchangeByInterface((Component)transfoSource, (Component)systemComponent, exportedInterfaceUses, exportedInterfaceImpls, exportedInterfaces)) {
                    exportedExternalComponentList.add((Component)systemComponent);
                    exportedComponentSystemInvolvementList.add(systemComponentInvolvement);
                    exportedInterfaceUseList.addAll(exportedInterfaceUses);
                    exportedInterfaceImplList.addAll(exportedInterfaceImpls);
                    exportedInterfaceList.addAll(exportedInterfaces);
                    possibleExchangeFounded = true;
                }
                exportedInterfaceUses.clear();
                exportedInterfaceImpls.clear();
                exportedInterfaces.clear();
            }
            if (!possibleExchangeFounded) continue;
            exportedCapabilityRealizationList.add(useCase);
        }
    }

    public static List<Scenario> findDirectScenarioList(List<CapabilityRealization> capabilityRealizationList, List<Part> componentInstanceList) {
        ArrayList<Scenario> exportedScenarioList = new ArrayList<Scenario>();
        for (CapabilityRealization capabilityRealization : capabilityRealizationList) {
            EList scenarioList = capabilityRealization.getOwnedScenarios();
            for (Scenario scenario : scenarioList) {
                if (scenario.isMerged()) continue;
                ArrayList<AbstractInstance> componentInstances = new ArrayList<AbstractInstance>();
                EList instanceRoleList = scenario.getOwnedInstanceRoles();
                for (InstanceRole instanceRole : instanceRoleList) {
                    AbstractInstance representedInstance = instanceRole.getRepresentedInstance();
                    if (!componentInstanceList.contains(representedInstance)) continue;
                    componentInstances.add(representedInstance);
                }
                if (componentInstances.isEmpty()) continue;
                exportedScenarioList.add(scenario);
                componentInstances.clear();
            }
        }
        return exportedScenarioList;
    }

    public static void findExternalComponents(List<Component> internalComponents, List<Component> involvedComponents, CapabilityRealization capabilityRealization, List<Component> externalComponents, List<Actor> externalActors, List<CapabilityRealization> exportedCapabilityRealizationList, List<ActorCapabilityRealizationInvolvement> exportedActorInvolvementList, List<SystemComponentCapabilityRealizationInvolvement> exportedComponentSystemInvolvementList, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        for (Component internalComponent : internalComponents) {
            for (Component involvedComponent : involvedComponents) {
                if (!ContextQuery.findPossibleExchangeByInterface(internalComponent, involvedComponent, exportedInterfaceUseList, exportedInterfaceImplList, exportedInterfaceList) || externalComponents.contains(involvedComponent) || internalComponents.contains(involvedComponent)) continue;
                if (involvedComponent instanceof Actor) {
                    if (!externalActors.contains(involvedComponent)) {
                        externalActors.add((Actor)involvedComponent);
                    }
                } else if (!externalComponents.contains(involvedComponent)) {
                    Component parent = ContextQuery.findParentComponentInList(involvedComponent, externalComponents);
                    if (parent != null) {
                        externalComponents.remove(parent);
                    }
                    if (!externalComponents.contains(involvedComponent) && !ContextQuery.containsSubComponent(involvedComponent, externalComponents)) {
                        externalComponents.add(involvedComponent);
                    }
                }
                if (exportedCapabilityRealizationList.contains(capabilityRealization)) continue;
                exportedCapabilityRealizationList.add(capabilityRealization);
            }
        }
    }

    public static List<SystemComponent> findExternalComponentTransfoSourceList(SystemComponent transfoSource) {
        ArrayList<SystemComponent> externalComponentTransfoSourceList = new ArrayList<SystemComponent>();
        EList involvements1 = transfoSource.getParticipationsInCapabilityRealizations();
        for (SystemComponentCapabilityRealizationInvolvement involvement1 : involvements1) {
            CapabilityRealization usecase = (CapabilityRealization)involvement1.getInvolvedCapabilityRealizationInvolvedElement();
            EList involvements2 = usecase.getInvolvedSystemComponents();
            for (SystemComponentCapabilityRealizationInvolvement involvement2 : involvements2) {
                SystemComponent systemComponent = (SystemComponent)involvement2.getInvolver();
                if (systemComponent == transfoSource || externalComponentTransfoSourceList.contains(systemComponent)) continue;
                externalComponentTransfoSourceList.add(systemComponent);
            }
        }
        return externalComponentTransfoSourceList;
    }

    public static List<Component> findInvolvedComponentOfCapabilityRealizations(CapabilityRealization capabilityRealization) {
        CapabilityRealization currentCapability = ContextQuery.findRootCapabilityRealization(capabilityRealization);
        ArrayList<Component> involvedComponents = new ArrayList<Component>();
        List newComponents = AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)currentCapability);
        for (Component newComponent : newComponents) {
            if (!(newComponent instanceof LogicalComponent) && !(newComponent instanceof Actor)) continue;
            Component parent = ContextQuery.findParentComponentInList(newComponent, involvedComponents);
            if (parent != null) {
                involvedComponents.remove(parent);
            }
            if (involvedComponents.contains(newComponent)) continue;
            involvedComponents.add(newComponent);
        }
        List elements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)currentCapability, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        ArrayList<CapabilityRealization> agenda = new ArrayList<CapabilityRealization>();
        agenda.add((CapabilityRealization)elements.get(0));
        AbstractCapability currentCapabilityRealization = null;
        while (agenda.size() > 0) {
            currentCapabilityRealization = (AbstractCapability)agenda.get(0);
            elements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)currentCapabilityRealization, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
            List newSystemComponents = CapabilityRealizationExt.getInvolvedSystemComponents((CapabilityRealization)((CapabilityRealization)currentCapabilityRealization));
            for (Component newSystemComponent : newSystemComponents) {
                if (!(newSystemComponent instanceof LogicalComponent) && !(newSystemComponent instanceof Actor)) continue;
                Component parent = ContextQuery.findParentComponentInList(newSystemComponent, involvedComponents);
                if (parent != null) {
                    involvedComponents.remove(parent);
                }
                if (involvedComponents.contains(newSystemComponent)) continue;
                involvedComponents.add(newSystemComponent);
            }
            agenda.remove(currentCapabilityRealization);
            for (CapellaElement capellaElement : elements) {
                agenda.add((CapabilityRealization)capellaElement);
            }
        }
        return involvedComponents;
    }

    public static List<LogicalComponent> findLogicalComponentsOfCI(ConfigurationItem configurationItem) {
        ArrayList<LogicalComponent> logicalComponents = new ArrayList<LogicalComponent>();
        ArrayList<PhysicalComponent> physicalComponents = new ArrayList<PhysicalComponent>();
        for (PhysicalArtifactRealization physicalComponentRealization : configurationItem.getOwnedPhysicalArtifactRealizations()) {
            if (!(physicalComponentRealization.getTargetElement() instanceof PhysicalComponent)) continue;
            physicalComponents.add((PhysicalComponent)physicalComponentRealization.getTargetElement());
        }
        for (PhysicalComponent physicalComponent : physicalComponents) {
            EList logicalComponentImplementationList = physicalComponent.getLogicalComponentRealizations();
            for (LogicalComponentRealization logicalComponentImplementation : logicalComponentImplementationList) {
                logicalComponents.add((LogicalComponent)logicalComponentImplementation.getAllocatedComponent());
            }
        }
        return logicalComponents;
    }

    private static Component findParentComponentInList(Component component, List<Component> componentList) {
        Iterator<Component> iterator = componentList.iterator();
        boolean containsComponents = false;
        while (iterator.hasNext() && !containsComponents) {
            Component currentComponent = iterator.next();
            if (!EcoreUtil2.isContainedBy((EObject)component, (EObject)currentComponent)) continue;
            return currentComponent;
        }
        return null;
    }

    public static boolean findPossibleExchangeByInterface(Component sourceComponent, Component externalComponent, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        if (externalComponent == sourceComponent) {
            return false;
        }
        EList interfaceUseList = sourceComponent.getUsedInterfaceLinks();
        for (InterfaceUse interfaceUse : interfaceUseList) {
            Interface usedInterface = interfaceUse.getUsedInterface();
            EList externalInterfaceImplList = externalComponent.getImplementedInterfaceLinks();
            for (InterfaceImplementation interfaceImplementation : externalInterfaceImplList) {
                Interface realizedInterface = interfaceImplementation.getImplementedInterface();
                if (usedInterface != realizedInterface) continue;
                if (!exportedInterfaceUseList.contains(interfaceUse)) {
                    exportedInterfaceUseList.add(interfaceUse);
                }
                if (!exportedInterfaceImplList.contains(interfaceImplementation)) {
                    exportedInterfaceImplList.add(interfaceImplementation);
                }
                if (exportedInterfaceList.contains(realizedInterface)) continue;
                exportedInterfaceList.add(realizedInterface);
            }
        }
        EList interfaceImplList = sourceComponent.getImplementedInterfaceLinks();
        for (InterfaceImplementation interfaceImplementation : interfaceImplList) {
            Interface realizedInterface = interfaceImplementation.getImplementedInterface();
            EList externalInterfaceUseList = externalComponent.getUsedInterfaceLinks();
            for (InterfaceUse interfaceUse : externalInterfaceUseList) {
                Interface usedInterface = interfaceUse.getUsedInterface();
                if (usedInterface != realizedInterface) continue;
                if (!exportedInterfaceUseList.contains(interfaceUse)) {
                    exportedInterfaceUseList.add(interfaceUse);
                }
                if (!exportedInterfaceImplList.contains(interfaceImplementation)) {
                    exportedInterfaceImplList.add(interfaceImplementation);
                }
                if (exportedInterfaceList.contains(realizedInterface)) continue;
                exportedInterfaceList.add(realizedInterface);
            }
        }
        return exportedInterfaceList.size() > 0;
    }

    private static CapabilityRealization findRootCapabilityRealization(CapabilityRealization capabilityRealization) {
        CapabilityRealization currentCapability = capabilityRealization;
        boolean done = false;
        while (currentCapability != null && !done) {
            List elements = RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)currentCapability, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
            if (elements.size() == 0) {
                done = true;
                continue;
            }
            currentCapability = (CapabilityRealization)elements.get(0);
        }
        return currentCapability;
    }

    public static List<CapabilityRealization> findRootCapabilityRealizationsOfComponent(Component component) {
        EList involvements = ((SystemComponent)component).getParticipationsInCapabilityRealizations();
        ArrayList<CapabilityRealization> capabilityRealizations = new ArrayList<CapabilityRealization>();
        for (SystemComponentCapabilityRealizationInvolvement involvement : involvements) {
            CapabilityRealization rootCapabilityRealization = (CapabilityRealization)involvement.getInvolved();
            capabilityRealizations.add(rootCapabilityRealization);
        }
        return capabilityRealizations;
    }

    public static List<Scenario> findScenarioList(List<CapabilityRealization> capabilityRealizationUseCaseList, List<Part> componentInstanceList) {
        ArrayList<Scenario> exportedScenarioList = new ArrayList<Scenario>();
        for (CapabilityRealization useCase : capabilityRealizationUseCaseList) {
            EList scenarioList = useCase.getOwnedScenarios();
            for (Scenario scenario : scenarioList) {
                if (!scenario.isMerged()) continue;
                ArrayList<AbstractInstance> componentInstances = new ArrayList<AbstractInstance>();
                EList instanceRoleList = scenario.getOwnedInstanceRoles();
                for (InstanceRole instanceRole : instanceRoleList) {
                    AbstractInstance representedInstance = instanceRole.getRepresentedInstance();
                    if (!componentInstanceList.contains(representedInstance)) continue;
                    componentInstances.add(representedInstance);
                }
                if (componentInstances.isEmpty()) continue;
                exportedScenarioList.add(scenario);
                componentInstances.clear();
            }
        }
        return exportedScenarioList;
    }

    public static void findUseImplementationInterfaceForExport(SystemComponent transfoSource, List<Component> externalComponents, List<InterfaceUse> exportedInterfaceUseList, List<InterfaceImplementation> exportedInterfaceImplList, List<Interface> exportedInterfaceList) {
        EList interfaceUseList = transfoSource.getUsedInterfaceLinks();
        for (InterfaceUse interfaceUse : interfaceUseList) {
            Interface usedInterface = interfaceUse.getUsedInterface();
            for (Component component : externalComponents) {
                EList externalInterfaceImplList = component.getImplementedInterfaceLinks();
                for (InterfaceImplementation interfaceImplementation : externalInterfaceImplList) {
                    Interface realizedInterface = interfaceImplementation.getImplementedInterface();
                    if (usedInterface != realizedInterface) continue;
                    exportedInterfaceUseList.add(interfaceUse);
                    exportedInterfaceImplList.add(interfaceImplementation);
                    exportedInterfaceList.add(realizedInterface);
                }
            }
        }
        EList interfaceImplList = transfoSource.getImplementedInterfaceLinks();
        for (InterfaceImplementation interfaceImplementation : interfaceImplList) {
            Interface realizedInterface = interfaceImplementation.getImplementedInterface();
            for (Component component : externalComponents) {
                EList externalInterfaceUseList = component.getUsedInterfaceLinks();
                for (InterfaceUse interfaceUse : externalInterfaceUseList) {
                    Interface usedInterface = interfaceUse.getUsedInterface();
                    if (usedInterface != realizedInterface) continue;
                    exportedInterfaceUseList.add(interfaceUse);
                    exportedInterfaceImplList.add(interfaceImplementation);
                    exportedInterfaceList.add(usedInterface);
                }
            }
        }
    }
}

